/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import io.dataease.plugins.common.constants.datasource.SQLConstants;
import io.dataease.plugins.common.util.ClassloaderResponsity;
import io.dataease.plugins.common.util.ModuleClassLoader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.ResolverUtil;
import org.springframework.util.ReflectionUtils;

public class ConstantsUtil {
    public static final String TYPE_KEY_FIELD = "NAME";
    private static final String constsPackageName = "io.dataease.plugins.common.constants";
    private static final List<Class> SQLConstantsCache = new ArrayList<Class>();

    public static List<Class> getAllSQLConstants() {
        if (CollectionUtils.isEmpty(SQLConstantsCache)) {
            SQLConstantsCache.addAll(ConstantsUtil.scanConstants(constsPackageName, SQLConstants.class));
        }
        return SQLConstantsCache;
    }

    public static Object getFieldValue(Class<?> classz, String key) {
        if (ObjectUtils.isEmpty((Object)ReflectionUtils.findField(classz, (String)key))) {
            return null;
        }
        return ReflectionUtils.getField((Field)Objects.requireNonNull(ReflectionUtils.findField(classz, (String)key)), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String constantsValue(String dsType, String constantKey) {
        String[] mysqlTreaties = new String[]{"mariadb", "ds_doris", "TiDB", "StarRocks"};
        if (Stream.of(mysqlTreaties).collect(Collectors.toList()).contains(dsType)) {
            dsType = "mysql";
        }
        List<Class> allSQLConstantsClass = ConstantsUtil.getAllSQLConstants();
        for (int i = 0; i < allSQLConstantsClass.size(); ++i) {
            Class classz = allSQLConstantsClass.get(i);
            Object fieldValue = ConstantsUtil.getFieldValue(classz, TYPE_KEY_FIELD);
            if (!ObjectUtils.isNotEmpty((Object)fieldValue) || !StringUtils.equals((CharSequence)dsType, (CharSequence)fieldValue.toString())) continue;
            Object result = ConstantsUtil.getFieldValue(classz, constantKey);
            return ObjectUtils.isNotEmpty((Object)result) ? result.toString() : null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            for (ModuleClassLoader moduleClassLoader : ClassloaderResponsity.getInstance().getAllClassLoader()) {
                Thread.currentThread().setContextClassLoader(moduleClassLoader);
                for (Class<? extends Class<?>> clazz : ConstantsUtil.scanConstants("io.dataease.plugins.datasource", SQLConstants.class)) {
                    Object fieldValue = ConstantsUtil.getFieldValue(clazz, TYPE_KEY_FIELD);
                    if (!ObjectUtils.isNotEmpty((Object)fieldValue) || !StringUtils.equals((CharSequence)dsType, (CharSequence)fieldValue.toString())) continue;
                    Object result = ConstantsUtil.getFieldValue(clazz, constantKey);
                    String string = ObjectUtils.isNotEmpty((Object)result) ? result.toString() : null;
                    return string;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return null;
    }

    private static Set<Class<? extends Class<?>>> scanConstants(String packageName, Class<?> superType) {
        ResolverUtil resolverUtil = new ResolverUtil();
        resolverUtil.find((ResolverUtil.Test)new ResolverUtil.IsA(superType), packageName);
        Set classesSet = resolverUtil.getClasses();
        return classesSet;
    }
}

