/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class GlobalDateUtils {
    public static final String DATE_PATTERM = "yyyy-MM-dd";
    public static final String TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static Date getDate(String dateString) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERM);
        return dateFormat.parse(dateString);
    }

    public static Date getTime(String timeString) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_PATTERN);
        return dateFormat.parse(timeString);
    }

    public static String getDateString(Date date) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERM);
        return dateFormat.format(date);
    }

    public static String formatDate(Date date) {
        try {
            return GlobalDateUtils.getDateString(date);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getDateString(long timeStamp) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERM);
        return dateFormat.format(timeStamp);
    }

    public static String getTimeString(Date date) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_PATTERN);
        return dateFormat.format(date);
    }

    public static String getTimeString(long timeStamp) throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_PATTERN);
        return dateFormat.format(timeStamp);
    }

    public static String getTimeStr(long timeStamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIME_PATTERN);
        return dateFormat.format(timeStamp);
    }

    public static Date dateSum(Date date, int countDays) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, countDays);
        return calendar.getTime();
    }

    public static Map<String, Date> getWeedFirstTimeAndLastTime(Date date) {
        HashMap<String, Date> returnMap = new HashMap<String, Date>();
        Calendar calendar = Calendar.getInstance();
        int weekDayAdd = 1;
        try {
            calendar.setTime(date);
            calendar.set(7, calendar.getActualMinimum(7));
            calendar.add(5, weekDayAdd);
            Date thisWeekFirstTime = GlobalDateUtils.getDate(GlobalDateUtils.getDateString(calendar.getTime()));
            calendar.clear();
            calendar.setTime(date);
            calendar.set(7, calendar.getActualMaximum(7));
            calendar.add(5, weekDayAdd);
            calendar.add(5, 1);
            Date nextWeekFirstDay = GlobalDateUtils.getDate(GlobalDateUtils.getDateString(calendar.getTime()));
            Date thisWeekLastTime = GlobalDateUtils.getTime(GlobalDateUtils.getTimeString(nextWeekFirstDay.getTime() - 1L));
            returnMap.put("firstTime", thisWeekFirstTime);
            returnMap.put("lastTime", thisWeekLastTime);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnMap;
    }

    public static Date getDayStartTime(Date time) throws Exception {
        return GlobalDateUtils.getDate(GlobalDateUtils.getDateString(time));
    }
}

