/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import io.dataease.plugins.common.util.FileUtil;
import io.dataease.plugins.common.util.GlobalDateUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class GlobalFileUtil {
    private static String root;
    private static final String SPLITOR = "-de-";

    @Value(value="${dataease.busiFilePath:/opt/dataease/data/business/}")
    public void setRoot(String root) {
        GlobalFileUtil.root = root;
    }

    public static String upload(byte[] bytes, String suffix) {
        String dateStr = null;
        try {
            dateStr = GlobalDateUtils.getDateString(new Date());
            String formatRoot = GlobalFileUtil.formatRoot();
            String dirPath = formatRoot + dateStr;
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                dirFile.mkdirs();
            }
            String fileId = GlobalFileUtil.fileIdByDate(dateStr);
            String filePath = formatRoot + dateStr + "/" + fileId + "." + suffix;
            File file = new File(filePath);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(bytes);
            fos.close();
            return fileId;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ResponseEntity<byte[]> showPicture(String fileId) {
        String filePath = GlobalFileUtil.filePathById(fileId, null);
        byte[] bytes = FileUtil.readBytes(filePath);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.IMAGE_PNG);
        return new ResponseEntity((Object)bytes, (MultiValueMap)headers, HttpStatus.OK);
    }

    public static ResponseEntity<ByteArrayResource> down(String fileId, String fileName) throws Exception {
        String suffix = FileUtil.getSuffix(fileName);
        String filePath = GlobalFileUtil.filePathById(fileId, suffix);
        byte[] bytes = FileUtil.readBytes(filePath);
        ByteArrayResource bar = new ByteArrayResource(bytes);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        ContentDisposition contentDisposition = ContentDisposition.parse((String)("attachment; filename=" + URLEncoder.encode(fileName, "UTF-8")));
        headers.setContentDisposition(contentDisposition);
        return new ResponseEntity((Object)bar, (MultiValueMap)headers, HttpStatus.OK);
    }

    private static String formatRoot() {
        if (!StringUtils.endsWith((CharSequence)root, (CharSequence)"/")) {
            return root + "/";
        }
        return root;
    }

    private static String dateByFileId(String fileId) {
        return fileId.substring(0, 10);
    }

    private static String fileIdByDate(String dateStr) {
        dateStr = StringUtils.isBlank((CharSequence)dateStr) ? GlobalDateUtils.formatDate(new Date()) : dateStr;
        String uuid = UUID.randomUUID().toString().replace("-", "");
        return dateStr + SPLITOR + uuid;
    }

    public static String filePathById(String fileId, String suffix) {
        String dateStr = GlobalFileUtil.dateByFileId(fileId);
        String dirPath = GlobalFileUtil.formatRoot() + dateStr;
        if (!FileUtil.exist(dirPath)) {
            throw new RuntimeException("dir path is not exist [" + dirPath + "]");
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            String filePath = dirPath + "/" + fileId + "." + suffix;
            if (!FileUtil.exist(filePath)) {
                throw new RuntimeException("file path is not exist [" + filePath + "]");
            }
            return filePath;
        }
        List<String> fileNames = FileUtil.listFileNames(dirPath);
        assert (fileNames != null);
        for (String fileName : fileNames) {
            String prefix = FileUtil.getPrefix(fileName);
            if (!StringUtils.equals((CharSequence)fileId, (CharSequence)prefix)) continue;
            return dirPath + "/" + fileName;
        }
        return null;
    }
}

