/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import io.dataease.plugins.common.util.HttpClientConfig;
import java.io.File;
import java.net.ProxySelector;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static final String HTTPS = "https";

    private static CloseableHttpClient buildHttpClient(String url) {
        try {
            if (url.startsWith(HTTPS)) {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.loadTrustMaterial(null, (x509Certificates, s) -> true);
                SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(builder.build(), new String[]{"TLSv1.1", "TLSv1.2", "SSLv3"}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register(HTTPS, (Object)socketFactory).build();
                PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry);
                SystemDefaultRoutePlanner routePlanner = new SystemDefaultRoutePlanner(ProxySelector.getDefault());
                return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setRoutePlanner((HttpRoutePlanner)routePlanner).build();
            }
            return HttpClientBuilder.create().build();
        }
        catch (Exception e) {
            throw new RuntimeException("HttpClient\u6784\u5efa\u5931\u8d25", e);
        }
    }

    public static String get(String url, HttpClientConfig config) {
        CloseableHttpClient httpClient = HttpClientUtil.buildHttpClient(url);
        HttpGet httpGet = new HttpGet(url);
        if (config == null) {
            config = new HttpClientConfig();
        }
        try {
            httpGet.setConfig(config.buildRequestConfig());
            Map<String, String> header = config.getHeader();
            for (String key : header.keySet()) {
                httpGet.addHeader(key, header.get(key));
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            String string = HttpClientUtil.getResponseStr((HttpResponse)response, config);
            return string;
        }
        catch (Exception e) {
            logger.error("HttpClient\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("HttpClient\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                logger.error("HttpClient\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static String post(String url, String json, HttpClientConfig config) {
        CloseableHttpClient httpClient = HttpClientUtil.buildHttpClient(url);
        HttpPost httpPost = new HttpPost(url);
        if (config == null) {
            config = new HttpClientConfig();
        }
        try {
            httpPost.setConfig(config.buildRequestConfig());
            Map<String, String> header = config.getHeader();
            for (String key : header.keySet()) {
                httpPost.addHeader(key, header.get(key));
            }
            EntityBuilder entityBuilder = EntityBuilder.create();
            entityBuilder.setText(json);
            entityBuilder.setContentType(ContentType.APPLICATION_JSON);
            HttpEntity requestEntity = entityBuilder.build();
            httpPost.setEntity(requestEntity);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String string = HttpClientUtil.getResponseStr((HttpResponse)response, config);
            return string;
        }
        catch (Exception e) {
            logger.error("HttpClient\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("HttpClient\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                logger.error("HttpClient\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    public static String post(String url, String json) {
        return HttpClientUtil.post(url, json, null);
    }

    public static String post(String url, Map<String, String> body, HttpClientConfig config) {
        CloseableHttpClient httpClient = HttpClientUtil.buildHttpClient(url);
        HttpPost httpPost = new HttpPost(url);
        if (config == null) {
            config = new HttpClientConfig();
        }
        try {
            httpPost.setConfig(config.buildRequestConfig());
            Map<String, String> header = config.getHeader();
            for (String string : header.keySet()) {
                httpPost.addHeader(string, header.get(string));
            }
            if (body != null && body.size() > 0) {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (String key : body.keySet()) {
                    nvps.add(new BasicNameValuePair(key, body.get(key)));
                }
                try {
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, config.getCharset()));
                }
                catch (Exception exception) {
                    logger.error("HttpClient\u8f6c\u6362\u7f16\u7801\u9519\u8bef", (Throwable)exception);
                    throw new RuntimeException("HttpClient\u8f6c\u6362\u7f16\u7801\u9519\u8bef", exception);
                }
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String string = HttpClientUtil.getResponseStr((HttpResponse)response, config);
            return string;
        }
        catch (Exception e) {
            logger.error("HttpClient\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("HttpClient\u67e5\u8be2\u5931\u8d25: " + e.getMessage());
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                logger.error("HttpClient\u5173\u95ed\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private static String getResponseStr(HttpResponse response, HttpClientConfig config) throws Exception {
        if (response.getStatusLine().getStatusCode() >= 400) {
            Object msg = EntityUtils.toString((HttpEntity)response.getEntity(), (String)config.getCharset());
            if (StringUtils.isEmpty((CharSequence)msg)) {
                msg = "StatusCode: " + response.getStatusLine().getStatusCode();
            }
            throw new Exception((String)msg);
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (String)config.getCharset());
    }

    public static String postFile(String fileServer, File file, Map<String, String> param, HttpClientConfig config) {
        CloseableHttpClient httpClient = HttpClientUtil.buildHttpClient(fileServer);
        HttpPost postRequest = new HttpPost(fileServer);
        if (config == null) {
            config = new HttpClientConfig();
        }
        postRequest.setConfig(config.buildRequestConfig());
        Map<String, String> header = config.getHeader();
        String fileFlag = param.get("fileFlag");
        String fileName = param.get("fileName");
        param.remove("fileFlag");
        param.remove("fileName");
        if (MapUtils.isNotEmpty(header)) {
            for (String string : header.keySet()) {
                postRequest.addHeader(string, header.get(string));
            }
        }
        postRequest.setHeader("Content-Type", "multipart/form-data");
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody(StringUtils.isNotBlank((CharSequence)fileFlag) ? fileFlag : "file", file, ContentType.APPLICATION_OCTET_STREAM, StringUtils.isNotBlank((CharSequence)fileName) ? fileName : file.getName());
        if (MapUtils.isNotEmpty(param)) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                StringBody stringBody = new StringBody(entry.getValue(), ContentType.TEXT_PLAIN.withCharset("utf-8"));
                builder.addPart(entry.getKey(), (ContentBody)stringBody);
            }
        }
        try {
            postRequest.setEntity(builder.build());
            return HttpClientUtil.getResponseStr((HttpResponse)httpClient.execute((HttpUriRequest)postRequest), config);
        }
        catch (Exception exception) {
            logger.error("HttpClient\u67e5\u8be2\u5931\u8d25", (Throwable)exception);
            throw new RuntimeException("HttpClient\u67e5\u8be2\u5931\u8d25: " + exception.getMessage());
        }
    }

    public static String postFile(String fileServer, byte[] bytes, String fileName, Map<String, String> param, HttpClientConfig config) {
        CloseableHttpClient httpClient = HttpClientUtil.buildHttpClient(fileServer);
        HttpPost postRequest = new HttpPost(fileServer);
        if (config == null) {
            config = new HttpClientConfig();
        }
        postRequest.setConfig(config.buildRequestConfig());
        Map<String, String> header = config.getHeader();
        if (MapUtils.isNotEmpty(header)) {
            for (String string : header.keySet()) {
                postRequest.addHeader(string, header.get(string));
            }
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(StandardCharsets.UTF_8);
        builder.addBinaryBody("image", bytes, ContentType.DEFAULT_BINARY, fileName);
        if (param != null) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                builder.addTextBody(entry.getKey(), entry.getValue());
            }
        }
        try {
            postRequest.setEntity(builder.build());
            return HttpClientUtil.getResponseStr((HttpResponse)httpClient.execute((HttpUriRequest)postRequest), config);
        }
        catch (Exception exception) {
            logger.error("HttpClient\u67e5\u8be2\u5931\u8d25", (Throwable)exception);
            throw new RuntimeException("HttpClient\u67e5\u8be2\u5931\u8d25: " + exception.getMessage());
        }
    }
}

