/*
 * Decompiled with CFR 0.152.
 */
package io.dataease.plugins.common.util;

import io.dataease.plugins.common.annotation.PluginResultMap;
import io.dataease.plugins.common.util.SpringContextUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

public class ModuleClassLoader
extends URLClassLoader {
    private JarFile jarFile;
    private Map<String, Class> cacheClassMap = new HashMap<String, Class>();
    private Map<String, byte[]> classBytesMap = new HashMap<String, byte[]>();
    private List<String> registeredBean = new ArrayList<String>();
    private List<String> registeredController = new ArrayList<String>();

    public ModuleClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        URL url = urls[0];
        String path = url.getPath();
        try {
            this.jarFile = new JarFile(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.init();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.findLoadedClass(name) == null) {
            Class<?> aClass = super.loadClass(name);
            Optional.ofNullable(aClass.getAnnotation(PluginResultMap.class)).ifPresent(anno -> {
                SqlSessionFactory sqlSessionFactory = SpringContextUtil.getBean(SqlSessionFactory.class);
                Configuration configuration = sqlSessionFactory.getConfiguration();
                TypeAliasRegistry typeAliasRegistry = configuration.getTypeAliasRegistry();
                typeAliasRegistry.registerAlias(name.toLowerCase(), aClass);
            });
            return aClass;
        }
        return this.cacheClassMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Enumeration<JarEntry> en = this.jarFile.entries();
        InputStream input = null;
        try {
            while (en.hasMoreElements()) {
                JarEntry je = en.nextElement();
                String name = je.getName();
                if (!name.endsWith(".class")) continue;
                String className = name.replace(".class", "").replaceAll("/", ".");
                input = this.jarFile.getInputStream(je);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int bufferSize = 4096;
                byte[] buffer = new byte[bufferSize];
                int bytesNumRead = 0;
                while ((bytesNumRead = input.read(buffer)) != -1) {
                    baos.write(buffer, 0, bytesNumRead);
                }
                byte[] classBytes = baos.toByteArray();
                this.classBytesMap.put(className, classBytes);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Map.Entry<String, byte[]> entry : this.classBytesMap.entrySet()) {
            String key = entry.getKey();
            Class<?> aClass = null;
            try {
                aClass = this.loadClass(key);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            this.cacheClassMap.put(key, aClass);
        }
    }

    public void initBean() {
        for (Map.Entry<String, Class> entry : this.cacheClassMap.entrySet()) {
            String className = entry.getKey();
            Class cla = entry.getValue();
            if (!this.isSpringBeanClass(cla)) continue;
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)cla);
            AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
            beanDefinition.setScope("singleton");
            String beanName = StringUtils.uncapitalize((String)className);
            beanName = beanName.substring(beanName.lastIndexOf(".") + 1);
            beanName = StringUtils.uncapitalize((String)beanName);
            SpringContextUtil.getBeanFactory().registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            if (this.isHandler(cla)) {
                this.registeredController.add(beanName);
            }
            this.registeredBean.add(beanName);
        }
    }

    public List<String> getRegisteredBean() {
        return this.registeredBean;
    }

    public List<String> getRegisteredController() {
        return this.registeredController;
    }

    public boolean isSpringBeanClass(Class<?> cla) {
        if (cla == null) {
            return false;
        }
        if (cla.isInterface()) {
            return false;
        }
        if (Modifier.isAbstract(cla.getModifiers())) {
            return false;
        }
        if (this.isHandler(cla)) {
            return true;
        }
        if (cla.getAnnotation(Component.class) != null) {
            return true;
        }
        if (cla.getAnnotation(Repository.class) != null) {
            return true;
        }
        if (cla.getAnnotation(Service.class) != null) {
            return true;
        }
        return cla.getAnnotation(Service.class) != null;
    }

    protected boolean isHandler(Class<?> beanType) {
        return AnnotatedElementUtils.hasAnnotation(beanType, Controller.class) || AnnotatedElementUtils.hasAnnotation(beanType, RequestMapping.class);
    }
}

