package io.dekorate.knative.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

/**
 * Generated
 */
@Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.project.BuildInfo.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.HostAlias.class),@io.sundr.builder.annotations.BuildableReference(io.dekorate.kubernetes.config.RollingUpdate.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
public class Traffic{
  public Traffic() {
  }
  
  public Traffic(String tag,String revisionName,Boolean latestRevision,Integer percentage) {
    this.tag = tag;
    this.revisionName = revisionName;
    this.latestRevision = latestRevision;
    this.percentage = percentage;
  }
  private String tag;
  private String revisionName;
  private Boolean latestRevision;
  private Integer percentage;
  
  
  /**
   * Tag is optionally used to expose a dedicated url for referencing
   * this target exclusively.
   */
  public String getTag() {
    return this.tag;
  }
  
  
  /**
   * RevisionName of a specific revision to which to send this portion of traffic.
   */
  public String getRevisionName() {
    return this.revisionName;
  }
  
  
  /**
   * LatestRevision may be optionally provided to indicate that the latest
   * ready Revision of the Configuration should be used for this traffic
   * target. When provided LatestRevision must be true if RevisionName is
   * empty.
   */
  public Boolean getLatestRevision() {
    return this.latestRevision;
  }
  
  
  /**
   * LatestRevision may be optionally provided to indicate that the latest
   * ready Revision of the Configuration should be used for this traffic
   * target. When provided LatestRevision must be true if RevisionName is
   * empty.
   */
  public boolean isLatestRevision() {
    return this.latestRevision != null &&  this.latestRevision;
  }
  
  
  /**
   * Percent indicates that percentage based routing should be used and
   * the value indicates the percent of traffic that is be routed to this
   * Revision or Configuration. `0` (zero) mean no traffic, `100` means all
   * traffic.
   */
  public Integer getPercentage() {
    return this.percentage;
  }
  
  public static TrafficBuilder newBuilder() {
    return new TrafficBuilder();
  }
  
  public static TrafficBuilder newBuilderFromDefaults() {
    return new TrafficBuilder().withLatestRevision(false).withPercentage(100);
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Traffic that = (Traffic) o;
    if (!java.util.Objects.equals(tag, that.tag)) return false;
    if (!java.util.Objects.equals(revisionName, that.revisionName)) return false;
    if (!java.util.Objects.equals(latestRevision, that.latestRevision)) return false;
    if (!java.util.Objects.equals(percentage, that.percentage)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(tag,  revisionName,  latestRevision,  percentage,  super.hashCode());
  }
  

}