/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Ingress;
import io.dekorate.kubernetes.config.IngressFluent;
import io.dekorate.kubernetes.config.IngressRule;
import io.dekorate.kubernetes.config.IngressRuleBuilder;
import io.dekorate.kubernetes.config.IngressRuleFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class IngressFluentImpl<A extends IngressFluent<A>>
extends BaseFluent<A>
implements IngressFluent<A> {
    private String host;
    private String ingressClassName;
    private Boolean expose;
    private String tlsSecretName;
    private List<String> tlsHosts = new ArrayList<String>();
    private ArrayList<IngressRuleBuilder> rules = new ArrayList();

    public IngressFluentImpl() {
    }

    public IngressFluentImpl(Ingress instance) {
        this.withHost(instance.getHost());
        this.withIngressClassName(instance.getIngressClassName());
        this.withExpose(instance.getExpose());
        this.withTlsSecretName(instance.getTlsSecretName());
        this.withTlsHosts(instance.getTlsHosts());
        this.withRules(instance.getRules());
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    public String getIngressClassName() {
        return this.ingressClassName;
    }

    @Override
    public A withIngressClassName(String ingressClassName) {
        this.ingressClassName = ingressClassName;
        return (A)this;
    }

    @Override
    public Boolean hasIngressClassName() {
        return this.ingressClassName != null;
    }

    @Override
    public Boolean getExpose() {
        return this.expose;
    }

    @Override
    public A withExpose(Boolean expose) {
        this.expose = expose;
        return (A)this;
    }

    @Override
    public Boolean hasExpose() {
        return this.expose != null;
    }

    @Override
    public String getTlsSecretName() {
        return this.tlsSecretName;
    }

    @Override
    public A withTlsSecretName(String tlsSecretName) {
        this.tlsSecretName = tlsSecretName;
        return (A)this;
    }

    @Override
    public Boolean hasTlsSecretName() {
        return this.tlsSecretName != null;
    }

    @Override
    public A withTlsHosts(String ... tlsHosts) {
        if (this.tlsHosts != null) {
            this.tlsHosts.clear();
        }
        if (tlsHosts != null) {
            for (String item : tlsHosts) {
                this.addToTlsHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getTlsHosts() {
        int size = this.tlsHosts != null ? this.tlsHosts.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.tlsHosts) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToTlsHosts(Integer index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTlsHosts(Integer index, String item) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        this.tlsHosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTlsHosts(String ... items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTlsHosts(Collection<String> items) {
        if (this.tlsHosts == null) {
            this.tlsHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.tlsHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTlsHosts(String ... items) {
        for (String item : items) {
            if (this.tlsHosts == null) continue;
            this.tlsHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTlsHosts(Collection<String> items) {
        for (String item : items) {
            if (this.tlsHosts == null) continue;
            this.tlsHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsHosts() {
        return this.tlsHosts != null && !this.tlsHosts.isEmpty();
    }

    @Override
    public A withRules(IngressRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (IngressRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public IngressRule[] getRules() {
        int size = this.rules != null ? this.rules.size() : 0;
        IngressRule[] result = new IngressRule[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.rules) {
            result[index++] = (IngressRule)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public IngressRule[] buildRules() {
        int size = this.rules != null ? this.rules.size() : 0;
        IngressRule[] result = new IngressRule[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.rules) {
            result[index++] = (IngressRule)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public IngressRule buildRule(Integer index) {
        return this.rules.get(index).build();
    }

    @Override
    public IngressRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public IngressRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        for (IngressRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToRules(Integer index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        this._visitables.get((Object)"rules").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"rules").size(), builder);
        this.rules.add(index >= 0 ? index.intValue() : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(Integer index, IngressRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        IngressRuleBuilder builder = new IngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"rules").size()) {
            this._visitables.get((Object)"rules").add(builder);
        } else {
            this._visitables.get((Object)"rules").set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(IngressRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<IngressRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(IngressRule ... items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<IngressRule> items) {
        for (IngressRule item : items) {
            IngressRuleBuilder builder = new IngressRuleBuilder(item);
            this._visitables.get((Object)"rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<IngressRuleBuilder> each = this.rules.iterator();
        List visitables = this._visitables.get((Object)"rules");
        while (each.hasNext()) {
            IngressRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public IngressFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public IngressFluent.RulesNested<A> addNewRuleLike(IngressRule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public IngressFluent.RulesNested<A> setNewRuleLike(Integer index, IngressRule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public IngressFluent.RulesNested<A> editRule(Integer index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public IngressFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public IngressFluent.RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressFluentImpl that = (IngressFluentImpl)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.ingressClassName != null ? !this.ingressClassName.equals(that.ingressClassName) : that.ingressClassName != null) {
            return false;
        }
        if (this.expose != null ? !this.expose.equals(that.expose) : that.expose != null) {
            return false;
        }
        if (this.tlsSecretName != null ? !this.tlsSecretName.equals(that.tlsSecretName) : that.tlsSecretName != null) {
            return false;
        }
        if (this.tlsHosts != null ? !this.tlsHosts.equals(that.tlsHosts) : that.tlsHosts != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.ingressClassName, this.expose, this.tlsSecretName, this.tlsHosts, this.rules, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.ingressClassName != null) {
            sb.append("ingressClassName:");
            sb.append(this.ingressClassName + ",");
        }
        if (this.expose != null) {
            sb.append("expose:");
            sb.append(this.expose + ",");
        }
        if (this.tlsSecretName != null) {
            sb.append("tlsSecretName:");
            sb.append(this.tlsSecretName + ",");
        }
        if (this.tlsHosts != null && !this.tlsHosts.isEmpty()) {
            sb.append("tlsHosts:");
            sb.append(this.tlsHosts + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withExpose() {
        return this.withExpose(true);
    }

    class RulesNestedImpl<N>
    extends IngressRuleFluentImpl<IngressFluent.RulesNested<N>>
    implements IngressFluent.RulesNested<N>,
    Nested<N> {
        IngressRuleBuilder builder;
        Integer index;

        RulesNestedImpl(Integer index, IngressRule item) {
            this.index = index;
            this.builder = new IngressRuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new IngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)IngressFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }
}

