/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.KeyToPath;
import io.fabric8.kubernetes.api.model.KeyToPathBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Description(value="Add a emptyDir volume to all pod specs.")
public class AddEmptyDirVolumeDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final EmptyDirVolume volume;

    public AddEmptyDirVolumeDecorator(EmptyDirVolume volume) {
        this(ANY, volume);
    }

    public AddEmptyDirVolumeDecorator(String name, EmptyDirVolume volume) {
        super(name);
        this.volume = volume;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        ((PodSpecFluent.VolumesNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewEmptyDir().endEmptyDir()).endVolume();
    }

    private List<KeyToPath> toKeyToPathList(Item[] items) {
        if (items == null || items.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<KeyToPath> keyToPathList = new ArrayList<KeyToPath>(items.length);
        for (Item item : items) {
            KeyToPathBuilder builder = (KeyToPathBuilder)((KeyToPathBuilder)new KeyToPathBuilder().withKey(item.getKey())).withPath(item.getPath());
            if (item.getMode() > 0) {
                builder.withMode(item.getMode());
            }
            keyToPathList.add(builder.build());
        }
        return keyToPathList;
    }
}

