/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.RoleBindingFluent;
import java.util.Collections;

@Description(value="Add a Rolebinding resource to the list of generated resources.")
public class AddRoleBindingResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final String DEFAULT_RBAC_API_GROUP = "rbac.authorization.k8s.io";
    private final String serviceAccount;
    private final String name;
    private final String role;
    private final RoleKind kind;

    public AddRoleBindingResourceDecorator(String role) {
        this(null, null, role, RoleKind.ClusterRole);
    }

    public AddRoleBindingResourceDecorator(String role, RoleKind kind) {
        this(null, null, role, kind);
    }

    public AddRoleBindingResourceDecorator(String name, String serviceAccount, String role, RoleKind kind) {
        this.name = name;
        this.serviceAccount = serviceAccount;
        this.role = role;
        this.kind = kind;
    }

    public void visit(KubernetesListBuilder list) {
        String serviceAccount;
        ObjectMeta meta = this.getMandatoryDeploymentMetadata(list, this.name);
        String actualName = Strings.isNotNullOrEmpty((String)this.name) ? this.name : meta.getName();
        String roleBindingName = actualName + "-" + this.role;
        String string = serviceAccount = Strings.isNotNullOrEmpty((String)this.serviceAccount) ? this.serviceAccount : actualName;
        if (this.contains(list, "rbac.authorization.k8s.io/v1", "RoleBinding", roleBindingName)) {
            return;
        }
        list.addToItems((VisitableBuilder)((RoleBindingFluent.SubjectsNested)((RoleBindingFluent.SubjectsNested)((RoleBindingBuilder)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingFluent.RoleRefNested)((RoleBindingBuilder)((RoleBindingFluent.MetadataNested)((RoleBindingFluent.MetadataNested)new RoleBindingBuilder().withNewMetadata().withName(roleBindingName)).withLabels(Strings.isNotNullOrEmpty((String)this.name) ? meta.getLabels() : Collections.emptyMap())).endMetadata()).withNewRoleRef().withKind(this.kind.name())).withName(this.role)).withApiGroup(DEFAULT_RBAC_API_GROUP)).endRoleRef()).addNewSubject().withKind("ServiceAccount")).withName(serviceAccount)).endSubject());
    }

    public static enum RoleKind {
        Role,
        ClusterRole;

    }
}

