/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Generics;
import io.dekorate.utils.Metadata;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Optional;

public abstract class ApplicationContainerDecorator<T>
extends Decorator<VisitableBuilder> {
    private final String deploymentName;
    private final String containerName;
    private final DeploymentVisitor deploymentVisitor = new DeploymentVisitor();
    private final ContainerVisitor containerVisitor = new ContainerVisitor();

    public ApplicationContainerDecorator() {
        this(ANY, ANY);
    }

    public ApplicationContainerDecorator(String containerName) {
        this(ANY, containerName);
    }

    public ApplicationContainerDecorator(String deploymentName, String containerName) {
        this.deploymentName = deploymentName;
        this.containerName = containerName;
    }

    protected String getDeploymentName() {
        return this.deploymentName;
    }

    protected String getContainerName() {
        return this.containerName;
    }

    public void visit(VisitableBuilder builder) {
        Optional objectMeta = Metadata.getMetadata((Builder)builder);
        if (Strings.isNotNullOrEmpty((String)this.deploymentName) && !objectMeta.isPresent()) {
            return;
        }
        if (Strings.isNullOrEmpty((String)this.deploymentName) || objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.deploymentName)).isPresent()) {
            builder.accept(new Visitor[]{this.deploymentVisitor});
        }
    }

    protected boolean isApplicable(ContainerFluent<?> container) {
        return Strings.isNullOrEmpty((String)this.containerName) || this.containerName.equals(container.getName());
    }

    public abstract void andThenVisit(T var1);

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class};
    }

    private class ContainerVisitor
    extends TypedVisitor<T> {
        private ContainerVisitor() {
        }

        public void visit(T item) {
            ApplicationContainerDecorator.this.andThenVisit(item);
        }

        public Class<T> getType() {
            return (Class)Generics.getTypeArguments(ApplicationContainerDecorator.class, ApplicationContainerDecorator.this.getClass()).get(0);
        }
    }

    private class DeploymentVisitor
    extends TypedVisitor<ContainerBuilder> {
        private DeploymentVisitor() {
        }

        public void visit(ContainerBuilder container) {
            if (!ApplicationContainerDecorator.this.isApplicable((ContainerFluent<?>)container)) {
                return;
            }
            container.accept(new Visitor[]{ApplicationContainerDecorator.this.containerVisitor});
        }
    }
}

