/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.partition.internal;

import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.Configurer;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.partition.BalancingPolicy;
import io.fabric8.partition.WorkItemRepository;
import io.fabric8.partition.WorkItemRepositoryFactory;
import io.fabric8.partition.Worker;
import io.fabric8.partition.internal.TaskContextImpl;
import io.fabric8.partition.internal.TaskCoordinator;
import io.fabric8.partition.internal.TaskHandler;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.osgi.service.cm.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.partition", label="Fabric8 Work Manager Factory", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
public final class PartitionManager
extends AbstractComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionManager.class);
    public static final String TASK_ID = "id";
    public static final String WORKITEM_PATH = "workItemPath";
    public static final String WORKITEM_REPO_TYPE = "workItemRepositoryFactory.target";
    public static final String WORK_BALANCING_POLICY = "balancingPolicy.target";
    public static final String WORKER_TYPE = "worker.target";
    @Reference
    private Configurer configurer;
    @Reference(name="balancingPolicy", referenceInterface=BalancingPolicy.class)
    private final ValidatingReference<BalancingPolicy> balancingPolicy = new ValidatingReference();
    @Reference(name="worker", referenceInterface=Worker.class)
    private final ValidatingReference<Worker> worker = new ValidatingReference();
    @Reference(name="workItemRepositoryFactory", referenceInterface=WorkItemRepositoryFactory.class)
    private final ValidatingReference<WorkItemRepositoryFactory> workItemRepositoryFactory = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Property(name="id", label="Task ID", description="A unique identifier for the task")
    private String id;
    @Property(name="workItemRepositoryFactory.target", label="Repository Factory Filter", description="Ldap filter for repository factory. Factory defines where and how the work items will be read")
    private String workItemRepositoryFactoryTarget;
    @Property(name="workItemPath", label="Work Item Path", description="The path where the work items are located")
    private String workItemPath;
    @Property(name="balancingPolicy.target", label="Policy Filter", description="Ldap filter for the balancing Policy. Balancing Policy defines how the work items will be distributed")
    private String balancingPolicyTarget;
    @Property(name="worker.target", label="Worker Filter", description="Ldap filter for the Worker to use. Worker defines how each item will be processed")
    private String workerTarget;
    @Property(name="name", label="Container Name", description="The name of the container", value={"${karaf.name}"}, propertyPrivate=true)
    private String name;
    private Map<String, ?> taskConfiguration;
    @GuardedBy(value="this")
    private WorkItemRepository repository;
    @GuardedBy(value="this")
    private TaskCoordinator coordinator;
    @GuardedBy(value="this")
    private TaskHandler taskHandler;

    @Activate
    void activate(Map<String, ?> configuration) throws Exception {
        this.activateInternal(configuration);
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
        this.deactivateInternal();
    }

    private synchronized void activateInternal(Map<String, ?> configuration) throws Exception {
        this.validate(configuration);
        this.taskConfiguration = configuration;
        this.configurer.configure(this.taskConfiguration, (Object)this);
        this.startCoordinator();
        this.startWorkHandler();
    }

    private synchronized void deactivateInternal() {
        this.stopCoordinator();
        this.stopWorkHandler();
        this.stopRepository();
    }

    private synchronized void startCoordinator() {
        if (this.coordinator == null) {
            this.coordinator = new TaskCoordinator(new TaskContextImpl(this.id, this.taskConfiguration), ((WorkItemRepositoryFactory)this.workItemRepositoryFactory.get()).build(this.workItemPath), (BalancingPolicy)this.balancingPolicy.get(), (CuratorFramework)this.curator.get());
            this.coordinator.start();
        }
    }

    private synchronized void stopCoordinator() {
        if (this.coordinator != null) {
            this.coordinator.stop();
            this.coordinator = null;
        }
    }

    private synchronized void startWorkHandler() {
        if (this.taskHandler == null) {
            LOGGER.info("Starting Task Handler type {} for task {}.", (Object)this.workerTarget, (Object)this.id);
            this.taskHandler = new TaskHandler(this.name, new TaskContextImpl(this.id, this.taskConfiguration), (CuratorFramework)this.curator.get(), (Worker)this.worker.get(), ((WorkItemRepositoryFactory)this.workItemRepositoryFactory.get()).build(this.workItemPath));
            this.taskHandler.start();
        }
    }

    private synchronized void stopWorkHandler() {
        if (this.taskHandler != null) {
            this.taskHandler.stop();
            this.taskHandler = null;
        }
    }

    private synchronized void stopRepository() {
        if (this.repository != null) {
            this.repository.close();
            this.repository = null;
        }
    }

    private void validate(Map<String, ?> properties) throws ConfigurationException {
        if (properties == null) {
            throw new IllegalArgumentException("Configuration is null");
        }
        if (properties.get(TASK_ID) == null) {
            throw new ConfigurationException(TASK_ID, "Property is required.");
        }
        if (properties.get(WORKITEM_PATH) == null) {
            throw new ConfigurationException(WORKITEM_PATH, "Property is required.");
        }
        if (properties.get(WORK_BALANCING_POLICY) == null) {
            throw new ConfigurationException(WORK_BALANCING_POLICY, "Property is required.");
        }
        if (properties.get(WORKER_TYPE) == null) {
            throw new ConfigurationException(WORKER_TYPE, "Property is required.");
        }
    }

    void bindBalancingPolicy(BalancingPolicy service) {
        this.balancingPolicy.bind((Object)service);
    }

    void unbindBalancingPolicy(BalancingPolicy service) {
        this.balancingPolicy.unbind((Object)service);
    }

    void bindWorker(Worker service) {
        this.worker.bind((Object)service);
    }

    void unbindWorker(Worker service) {
        this.worker.unbind((Object)service);
    }

    void bindWorkItemRepositoryFactory(WorkItemRepositoryFactory service) {
        this.workItemRepositoryFactory.bind((Object)service);
    }

    void unbindWorkItemRepositoryFactory(WorkItemRepositoryFactory service) {
        this.workItemRepositoryFactory.unbind((Object)service);
    }

    void bindCurator(CuratorFramework service) {
        this.curator.bind((Object)service);
    }

    void unbindCurator(CuratorFramework service) {
        this.curator.unbind((Object)service);
    }

    protected void bindConfigurer(Configurer configurer) {
        this.configurer = configurer;
    }

    protected void unbindConfigurer(Configurer configurer) {
        if (this.configurer == configurer) {
            this.configurer = null;
        }
    }
}

