/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.api.handlers.http;

import io.fabric8.gateway.api.handlers.http.HttpGateway;
import io.fabric8.gateway.api.handlers.http.HttpMapping;
import io.fabric8.gateway.api.handlers.http.IMappedServices;
import io.fabric8.gateway.api.handlers.http.ProxyMappingDetails;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.http.HttpClient;
import org.vertx.java.core.http.HttpClientRequest;
import org.vertx.java.core.http.HttpClientResponse;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.HttpServerResponse;

public class HttpGatewayServiceClient {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpGatewayServiceClient.class);
    private final Vertx vertx;
    private final HttpGateway httpGateway;

    public HttpGatewayServiceClient(Vertx vertx, HttpGateway httpGateway) {
        this.vertx = vertx;
        this.httpGateway = httpGateway;
    }

    public HttpClientRequest execute(HttpServerRequest request, Object apiManagerResponseHandler) {
        try {
            IMappedServices mappedServices = HttpMapping.getMapping(request, this.httpGateway.getMappedServices());
            ProxyMappingDetails proxyMappingDetails = mappedServices.getProxyMappingDetails();
            HttpClient client = null;
            if (proxyMappingDetails != null && proxyMappingDetails.getProxyServiceUrl() != null) {
                client = this.createClient(new URL(proxyMappingDetails.getProxyServiceUrl()));
            }
            if (client != null) {
                LOG.info("Proxying request " + request.uri() + " to service path: " + proxyMappingDetails.getServicePath() + " on service: " + proxyMappingDetails.getProxyServiceUrl() + " reverseServiceUrl: " + proxyMappingDetails.getReverseServiceUrl());
                HttpClient finalClient = client;
                Handler<HttpClientResponse> serviceResponseHandler = null;
                serviceResponseHandler = this.httpGateway.getApiManager().isApiManagerEnabled() ? this.httpGateway.getApiManager().getService().createServiceResponseHandler(finalClient, apiManagerResponseHandler) : new Handler<HttpClientResponse>(finalClient, request);
                if (mappedServices != null) {
                    serviceResponseHandler = mappedServices.wrapResponseHandlerInPolicies(request, serviceResponseHandler, proxyMappingDetails);
                }
                HttpClientRequest serviceRequest = client.request(request.method(), proxyMappingDetails.getServicePath(), serviceResponseHandler);
                serviceRequest.headers().set(request.headers());
                serviceRequest.setChunked(true);
                return serviceRequest;
            }
            LOG.info("Could not find matching proxy path for " + request.uri() + " from paths: " + this.httpGateway.getMappedServices().keySet());
            HttpServerResponse httpServerResponse = request.response();
            httpServerResponse.setStatusCode(404);
            httpServerResponse.setStatusMessage("Could not find matching proxy path for " + request.uri() + " from paths: " + this.httpGateway.getMappedServices().keySet());
            httpServerResponse.end();
        }
        catch (Throwable e) {
            LOG.error("Caught: " + e, e);
            request.response().setStatusCode(404);
            StringWriter buffer = new StringWriter();
            e.printStackTrace(new PrintWriter(buffer));
            request.response().setStatusMessage("Error: " + e + "\nStack Trace: " + buffer);
            request.response().close();
        }
        return null;
    }

    protected boolean isApimanagerRestRequest(HttpServerRequest request) {
        if (this.httpGateway == null || !this.httpGateway.isEnableIndex()) {
            return false;
        }
        String uri = request.uri();
        return uri == null || uri.length() == 0 || request.path().startsWith("/rest/apimanager/");
    }

    protected HttpClient createClient(URL url) throws MalformedURLException {
        HttpClient client = this.vertx.createHttpClient();
        client.setHost(url.getHost());
        client.setPort(url.getPort());
        return client;
    }
}

