/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.gateway.fabric.support.http;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.api.jcip.GuardedBy;
import io.fabric8.api.scr.InvalidComponentException;
import io.fabric8.common.util.Closeables;
import io.fabric8.gateway.ServiceDTO;
import io.fabric8.gateway.ServiceDetails;
import io.fabric8.gateway.handlers.http.HttpMappingRule;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMappingZooKeeperTreeCache {
    private static final transient Logger LOG = LoggerFactory.getLogger(HttpMappingZooKeeperTreeCache.class);
    private final CuratorFramework curator;
    private final HttpMappingRule mappingRuleConfiguration;
    private final String zooKeeperPath;
    private final ExecutorService treeCacheExecutor = Executors.newSingleThreadExecutor();
    private final AtomicBoolean active = new AtomicBoolean(false);
    private final ObjectMapper mapper = new ObjectMapper();
    private final PathChildrenCacheListener treeListener = new PathChildrenCacheListener(){

        public void childEvent(CuratorFramework curatorFramework, PathChildrenCacheEvent event) throws Exception {
            HttpMappingZooKeeperTreeCache.this.treeCacheEvent(event);
        }
    };
    @GuardedBy(value="active")
    private volatile TreeCache treeCache;

    public HttpMappingZooKeeperTreeCache(CuratorFramework curator, HttpMappingRule mappingRuleConfiguration, String zooKeeperPath) {
        this.curator = curator;
        this.mappingRuleConfiguration = mappingRuleConfiguration;
        this.zooKeeperPath = zooKeeperPath;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public String toString() {
        return "HttpMappingZooKeeperTreeCache(config: " + this.mappingRuleConfiguration + ")";
    }

    protected TreeCache getTreeCache() {
        if (!this.active.get()) {
            throw new InvalidComponentException();
        }
        return this.treeCache;
    }

    public void init() throws Exception {
        if (this.active.compareAndSet(false, true)) {
            this.treeCache = new TreeCache(this.curator, this.zooKeeperPath, true, false, true, this.treeCacheExecutor);
            this.treeCache.start(TreeCache.StartMode.NORMAL);
            this.treeCache.getListenable().addListener((Object)this.treeListener);
            LOG.info("Started listening to ZK path " + this.zooKeeperPath);
        }
    }

    public void destroy() {
        if (this.active.compareAndSet(true, false)) {
            this.treeCache.getListenable().removeListener((Object)this.treeListener);
            Closeables.closeQuitely((Closeable)this.treeCache);
            this.treeCache = null;
            this.treeCacheExecutor.shutdownNow();
        }
    }

    protected void treeCacheEvent(PathChildrenCacheEvent event) {
        String zkPath = this.zooKeeperPath;
        ChildData childData = event.getData();
        if (childData == null) {
            return;
        }
        String path = childData.getPath();
        PathChildrenCacheEvent.Type type = event.getType();
        byte[] data = childData.getData();
        if (data == null || data.length == 0 || path == null) {
            return;
        }
        if (path.startsWith(zkPath)) {
            path = path.substring(zkPath.length());
        }
        boolean remove = false;
        switch (type) {
            case CHILD_ADDED: 
            case CHILD_UPDATED: {
                break;
            }
            case CHILD_REMOVED: {
                remove = true;
                break;
            }
            default: {
                return;
            }
        }
        ServiceDTO dto = null;
        try {
            dto = (ServiceDTO)this.mapper.readValue(data, ServiceDTO.class);
            this.expandPropertyResolvers(dto);
            List services = dto.getServices();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("id", HttpMappingZooKeeperTreeCache.paramValue(dto.getId()));
            params.put("container", HttpMappingZooKeeperTreeCache.paramValue(dto.getContainer()));
            params.put("version", HttpMappingZooKeeperTreeCache.paramValue(dto.getVersion()));
            params.put("bundleName", HttpMappingZooKeeperTreeCache.paramValue(dto.getBundleName()));
            params.put("bundleVersion", HttpMappingZooKeeperTreeCache.paramValue(dto.getBundleVersion()));
            this.mappingRuleConfiguration.updateMappingRules(remove, path, services, params, (ServiceDetails)dto);
        }
        catch (IOException e) {
            LOG.warn("Failed to parse the JSON: " + new String(data) + ". Reason: " + e, (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.warn("Failed to update URI for dto: " + dto + ", .Reason: " + e, (Throwable)e);
        }
    }

    protected static String paramValue(String paramValue) {
        return paramValue != null ? paramValue : "";
    }

    protected void expandPropertyResolvers(ServiceDTO dto) throws URISyntaxException {
        List services = dto.getServices();
        ArrayList<String> newList = new ArrayList<String>(services.size());
        for (String service : services) {
            String expanded = ZooKeeperUtils.getSubstitutedData((CuratorFramework)this.curator, (String)service);
            newList.add(expanded);
        }
        dto.setServices(newList);
    }
}

