/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.repo.git;

import io.fabric8.repo.git.CreateRepositoryDTO;
import io.fabric8.repo.git.CreateWebhookDTO;
import io.fabric8.repo.git.OrganisationDTO;
import io.fabric8.repo.git.RepositoryDTO;
import io.fabric8.repo.git.WebHookDTO;
import java.io.InputStream;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface GitApi {
    @GET
    @Path(value="user/repos")
    public List<RepositoryDTO> listRepositories();

    @GET
    @Path(value="user/orgs")
    public List<OrganisationDTO> listUserOrganisations();

    @GET
    @Path(value="orgs/{org}/repos")
    public List<RepositoryDTO> listOrganisationRepositories(@PathParam(value="org") String var1);

    @GET
    @Path(value="orgs/{org}/repos/{repo}")
    public RepositoryDTO getOrganisationRepository(@PathParam(value="org") String var1, @PathParam(value="repo") String var2);

    @POST
    @Path(value="user/repos")
    public RepositoryDTO createRepository(CreateRepositoryDTO var1);

    @GET
    @Path(value="repos/{owner}/{repo}")
    public RepositoryDTO getRepository(@PathParam(value="owner") String var1, @PathParam(value="repo") String var2);

    @GET
    @Path(value="repos/{username}/{repo}/raw/{branch}/{path:.*}")
    public InputStream getRawFile(@PathParam(value="username") String var1, @PathParam(value="repo") String var2, @PathParam(value="branch") String var3, @PathParam(value="path") String var4);

    @GET
    @Path(value="repos/{owner}/{repo}/hooks")
    public List<WebHookDTO> getWebhooks(@PathParam(value="owner") String var1, @PathParam(value="repo") String var2);

    @POST
    @Path(value="repos/{owner}/{repo}/hooks")
    public WebHookDTO createWebhook(@PathParam(value="owner") String var1, @PathParam(value="repo") String var2, CreateWebhookDTO var3);
}

