/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.ContainerProvider;
import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.CreateChildContainerOptions;
import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ChildContainerBuilder;
import io.fabric8.itests.paxexam.support.ContainerCallback;
import io.fabric8.itests.paxexam.support.ContainerProxy;
import io.fabric8.itests.paxexam.support.CreateContainerTask;
import io.fabric8.itests.paxexam.support.JcloudsContainerBuilder;
import io.fabric8.itests.paxexam.support.Provision;
import io.fabric8.itests.paxexam.support.SshContainerBuilder;
import io.fabric8.service.jclouds.CreateJCloudsContainerOptions;
import io.fabric8.service.ssh.CreateSshContainerOptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class ContainerBuilder<T extends ContainerBuilder, B extends CreateContainerBasicOptions.Builder> {
    public static final Long CREATE_TIMEOUT = 600000L;
    public static final Long PROVISION_TIMEOUT = 300000L;
    public static final String CONTAINER_TYPE_PROPERTY = "FABRIC_ITEST_CONTAINER_TYPE";
    public static final String CONTAINER_NUMBER_PROPERTY = "FABRIC_ITEST_CONTAINER_NUMBER";
    private final B optionsBuilder;
    private final Set<String> profileNames = new HashSet<String>();
    private final ServiceProxy<FabricService> fabricServiceServiceProxy;
    private boolean waitForProvisioning;
    private boolean assertProvisioningResult;
    private long provisionTimeOut = PROVISION_TIMEOUT;
    private ExecutorService executorService = Executors.newCachedThreadPool();

    protected ContainerBuilder(ServiceProxy<FabricService> proxy, B optionsBuilder) {
        this.optionsBuilder = optionsBuilder;
        this.fabricServiceServiceProxy = proxy;
    }

    public static ContainerBuilder create(ServiceProxy<FabricService> proxy) {
        return ContainerBuilder.create(proxy, 1);
    }

    public static ContainerBuilder create(ServiceProxy<FabricService> proxy, int minimumNumber) {
        return ContainerBuilder.create(proxy, minimumNumber, 0);
    }

    public static ContainerBuilder create(ServiceProxy<FabricService> proxy, int minimumNumber, int maximumNumber) {
        String containerType = System.getProperty(CONTAINER_TYPE_PROPERTY, "child");
        int numberOfContainers = Math.max(minimumNumber, Integer.parseInt(System.getProperty(CONTAINER_NUMBER_PROPERTY, "1")));
        if (maximumNumber < numberOfContainers && maximumNumber != 0) {
            numberOfContainers = minimumNumber;
        }
        if ("child".equals(containerType)) {
            return ContainerBuilder.child(proxy, numberOfContainers);
        }
        if ("jclouds".equals(containerType)) {
            return ContainerBuilder.jclouds(proxy, numberOfContainers);
        }
        if ("ssh".equals(containerType)) {
            return ContainerBuilder.ssh(proxy, numberOfContainers);
        }
        return ContainerBuilder.child(proxy, 1);
    }

    public static ChildContainerBuilder child(ServiceProxy<FabricService> proxy) {
        return ContainerBuilder.child(proxy, 1);
    }

    public static ChildContainerBuilder child(ServiceProxy<FabricService> proxy, int numberOfContainers) {
        return new ChildContainerBuilder(proxy, (CreateChildContainerOptions.Builder)CreateChildContainerOptions.builder().number(numberOfContainers));
    }

    public static JcloudsContainerBuilder jclouds(ServiceProxy<FabricService> proxy) {
        return new JcloudsContainerBuilder(proxy, CreateJCloudsContainerOptions.builder());
    }

    public static JcloudsContainerBuilder jclouds(ServiceProxy<FabricService> proxy, int numberOfContainers) {
        return new JcloudsContainerBuilder(proxy, (CreateJCloudsContainerOptions.Builder)CreateJCloudsContainerOptions.builder().number(numberOfContainers));
    }

    public static SshContainerBuilder ssh(ServiceProxy<FabricService> proxy) {
        return new SshContainerBuilder(proxy, CreateSshContainerOptions.builder());
    }

    public static SshContainerBuilder ssh(ServiceProxy<FabricService> proxy, int numberOfContainers) {
        return new SshContainerBuilder(proxy, (CreateSshContainerOptions.Builder)CreateSshContainerOptions.builder().number(1));
    }

    public ContainerBuilder<T, B> withName(String name) {
        this.getOptionsBuilder().name(name);
        return this;
    }

    public ContainerBuilder<T, B> withJvmOpts(String jvmOpts) {
        this.getOptionsBuilder().jvmOpts(jvmOpts);
        return this;
    }

    public ContainerBuilder<T, B> withResolver(String resolver) {
        this.getOptionsBuilder().resolver(resolver);
        return this;
    }

    public ContainerBuilder<T, B> withProfiles(String profile) {
        this.profileNames.add(profile);
        return this;
    }

    public ContainerBuilder<T, B> waitForProvisioning() {
        this.waitForProvisioning = true;
        return this;
    }

    public ContainerBuilder<T, B> assertProvisioningResult() {
        this.assertProvisioningResult = true;
        return this;
    }

    public B getOptionsBuilder() {
        return this.optionsBuilder;
    }

    public Set<ContainerProxy> build(Collection<B> buildersList) {
        return this.buildInternal(buildersList);
    }

    public Set<ContainerProxy> build() {
        ServiceLocator.awaitService((BundleContext)ContainerBuilder.getBundleContext(), ContainerRegistration.class);
        return this.buildInternal(Arrays.asList(this.getOptionsBuilder()));
    }

    private Set<ContainerProxy> buildInternal(Collection<B> buildersList) {
        HashSet containers = new HashSet();
        BundleContext bundleContext = ContainerBuilder.getBundleContext();
        FabricService fabricService = (FabricService)this.fabricServiceServiceProxy.getService();
        ExecutorCompletionService<Set<ContainerProxy>> completionService = new ExecutorCompletionService<Set<ContainerProxy>>(this.executorService);
        int tasks = 0;
        for (CreateContainerBasicOptions.Builder builder : buildersList) {
            builder.profiles(this.profileNames);
            if (builder.isEnsembleServer()) continue;
            builder.zookeeperUrl(fabricService.getZookeeperUrl());
            CreateContainerBasicOptions options = builder.build();
            ServiceLocator.awaitService((BundleContext)bundleContext, ContainerProvider.class, (String)("(fabric.container.protocol=" + options.getProviderType() + ")"), (long)CREATE_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS);
            completionService.submit(new CreateContainerTask(this.fabricServiceServiceProxy, options));
            ++tasks;
        }
        try {
            for (int i = 0; i < tasks; ++i) {
                Future futureContainerSet = completionService.poll(CREATE_TIMEOUT, TimeUnit.MILLISECONDS);
                Set containerSet = (Set)futureContainerSet.get();
                containers.addAll(containerSet);
            }
            try {
                if (this.waitForProvisioning) {
                    Provision.containerStatus(containers, this.provisionTimeOut);
                }
                if (this.assertProvisioningResult) {
                    Provision.provisioningSuccess(containers, this.provisionTimeOut, ContainerCallback.DISPLAY_ALL);
                }
            }
            catch (Exception e) {
                throw FabricException.launderThrowable((Throwable)e);
            }
        }
        catch (Exception e) {
            throw FabricException.launderThrowable((Throwable)e);
        }
        return Collections.unmodifiableSet(containers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(Set<? extends Container> containers) {
        try (ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)ContainerBuilder.getBundleContext(), FabricService.class);){
            FabricService fabricService = (FabricService)fabricProxy.getService();
            for (Container container : containers) {
                try {
                    Container container2 = fabricService.getContainer(container.getId());
                    container2.destroy(true);
                }
                catch (Exception ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(Set<? extends Container> containers) {
        try (ServiceProxy fabricProxy = ServiceProxy.createServiceProxy((BundleContext)ContainerBuilder.getBundleContext(), FabricService.class);){
            FabricService fabricService = (FabricService)fabricProxy.getService();
            for (Container container : containers) {
                try {
                    Container updated = fabricService.getContainer(container.getId());
                    updated.stop(true);
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    static BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(ContainerBuilder.class).getBundleContext();
    }
}

