/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.itests.paxexam.support.Callback;
import io.fabric8.itests.paxexam.support.ContainerCallback;
import io.fabric8.itests.paxexam.support.ContainerCondition;
import io.fabric8.itests.paxexam.support.ProvisionException;
import io.fabric8.itests.paxexam.support.WaitForAliveTask;
import io.fabric8.itests.paxexam.support.WaitForConditionTask;
import io.fabric8.itests.paxexam.support.WaitForContainerCreationTask;
import io.fabric8.itests.paxexam.support.WaitForInstanceStartedTask;
import io.fabric8.itests.paxexam.support.WaitForProvisionTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.osgi.framework.BundleContext;

public class Provision {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();

    /*
     * WARNING - void declaration
     */
    public static boolean containersStatus(Collection<? extends Container> containers, String status, Long timeout) {
        void var6_9;
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(EXECUTOR);
        LinkedList<Future<Boolean>> waitForProvisionTasks = new LinkedList<Future<Boolean>>();
        for (Container container : containers) {
            waitForProvisionTasks.add(completionService.submit(new WaitForProvisionTask(container, status, timeout)));
        }
        boolean failure = false;
        boolean bl = false;
        while (var6_9 < containers.size()) {
            try {
                Future future = completionService.poll(timeout, TimeUnit.MILLISECONDS);
                if (future == null) {
                    System.out.println("Timed out waiting for containers");
                    failure = true;
                } else if (!((Boolean)future.get()).booleanValue()) {
                    failure = true;
                }
            }
            catch (Exception e) {
                failure = true;
            }
            ++var6_9;
        }
        return !failure;
    }

    public static boolean containerStatus(Collection<? extends Container> containers, Long timeout) {
        return Provision.containersStatus(containers, "success", timeout);
    }

    public static void containersAlive(Collection<? extends Container> containers, boolean alive, Long timeout) throws Exception {
        if (containers.isEmpty()) {
            return;
        }
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(EXECUTOR);
        LinkedList<Future<Boolean>> waitForProvisionTasks = new LinkedList<Future<Boolean>>();
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        for (Container container : containers) {
            waitForProvisionTasks.add(completionService.submit(new WaitForAliveTask(container, alive, timeout)));
            sb.append(container.getId()).append(" ");
        }
        System.out.println("Waiting for containers: [" + sb.toString() + "] to reach Alive:" + alive);
        for (Container container : containers) {
            Future f = completionService.poll(timeout, TimeUnit.MILLISECONDS);
            if (f != null && ((Boolean)f.get()).booleanValue()) continue;
            throw new Exception("Container " + container.getId() + " failed to reach Alive:" + alive);
        }
    }

    public static boolean waitForCondition(Callable<Boolean> condition, Long timeout) throws Exception {
        Future<Boolean> result = EXECUTOR.submit(condition);
        return result.get(timeout, TimeUnit.MILLISECONDS);
    }

    public static boolean waitForCondition(WaitForConditionTask task) throws Exception {
        Future<Boolean> result = EXECUTOR.submit(task);
        return result.get();
    }

    public static boolean waitForCondition(Collection<? extends Container> containers, final ContainerCondition condition, Long timeout) throws Exception {
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(EXECUTOR);
        for (final Container container : containers) {
            completionService.submit(new WaitForConditionTask(new Callable(){

                public Object call() throws Exception {
                    return condition.checkConditionOnContainer(container);
                }
            }, timeout));
        }
        for (Container container : containers) {
            Future f = completionService.poll(timeout, TimeUnit.MILLISECONDS);
            if (f != null && ((Boolean)f.get()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void containersExist(BundleContext bundleContext, Collection<String> containers, Long timeout) throws Exception {
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(EXECUTOR);
        LinkedList<Future<Boolean>> waitForProvisionTasks = new LinkedList<Future<Boolean>>();
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        for (String container : containers) {
            waitForProvisionTasks.add(completionService.submit(new WaitForContainerCreationTask(bundleContext, container, timeout)));
            sb.append(container).append(" ");
        }
        System.out.println("Waiting for containers: [" + sb.toString() + "] to become created.");
        for (String container : containers) {
            Future f = completionService.poll(timeout, TimeUnit.MILLISECONDS);
            if (f != null && ((Boolean)f.get()).booleanValue()) continue;
            throw new Exception("Container " + container + " failed to become created.");
        }
    }

    public static void instanceStarted(BundleContext bundleContext, Collection<String> instances, Long timeout) throws Exception {
        ExecutorCompletionService<Boolean> completionService = new ExecutorCompletionService<Boolean>(EXECUTOR);
        LinkedList<Future<Boolean>> waitForstarted = new LinkedList<Future<Boolean>>();
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        for (String instance : instances) {
            waitForstarted.add(completionService.submit(new WaitForInstanceStartedTask(bundleContext, instance, timeout)));
            sb.append(instance).append(" ");
        }
        System.out.println("Waiting for child instances: [" + sb.toString() + "] to get started.");
        for (String instance : instances) {
            Future f = completionService.poll(timeout, TimeUnit.MILLISECONDS);
            if (f != null && ((Boolean)f.get()).booleanValue()) continue;
            throw new Exception("Instance " + instance + " failed to start.");
        }
    }

    public static void containerAlive(Collection<Container> containers, Long timeout) throws Exception {
        Provision.containersAlive(containers, true, timeout);
    }

    public static void provisioningSuccess(Collection<? extends Container> containers, Long timeout) throws Exception {
        Provision.provisioningSuccess(containers, timeout, ContainerCallback.DISPLAY_ALL);
    }

    public static void provisioningSuccess(Collection<? extends Container> containers, Long timeout, Callback<Container> onFailed) throws ProvisionException, InterruptedException {
        if (containers.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        for (Container container : containers) {
            sb.append(container.getId()).append(" ");
        }
        System.out.println("Waiting for containers: [" + sb.toString() + "] to successfully provision");
        for (int i = 0; i < 3; ++i) {
            if (!Provision.containerStatus(containers, timeout)) {
                StringBuilder stringBuilder = new StringBuilder();
                for (Container container : containers) {
                    if (container.isAliveAndOK()) continue;
                    onFailed.call(container);
                    stringBuilder.append("Container " + container.getId() + " failed to provision. Status:" + container.getProvisionStatus() + " Exception:" + container.getProvisionException()).append("\n");
                }
                throw new ProvisionException(stringBuilder.toString());
            }
            Thread.sleep(1000L);
        }
    }

    public static Boolean profileAvailable(BundleContext bundleContext, String profile, String version, Long timeout) throws Exception {
        FabricService service = (FabricService)ServiceLocator.awaitService((BundleContext)bundleContext, FabricService.class);
        for (long t = 0L; !service.getDataStore().hasProfile(version, profile) && t < timeout; t += 2000L) {
            Thread.sleep(2000L);
        }
        return service.getDataStore().hasProfile(version, profile);
    }

    public static Object getMBean(final Container container, final ObjectName mbeanName, final Class clazz, final long timeout) throws Exception {
        ExecutorCompletionService<Object> completionService = new ExecutorCompletionService<Object>(EXECUTOR);
        completionService.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (long time = 0L; time <= timeout; time += 2000L) {
                    try {
                        JMXServiceURL url = new JMXServiceURL(container.getJmxUrl());
                        HashMap<String, String[]> env = new HashMap<String, String[]>();
                        String[] creds = new String[]{"admin", "admin"};
                        env.put("jmx.remote.credentials", creds);
                        JMXConnector jmxc = JMXConnectorFactory.connect(url, env);
                        MBeanServerConnection mbsc = jmxc.getMBeanServerConnection();
                        mbsc.getObjectInstance(mbeanName);
                        return JMX.newMBeanProxy(mbsc, mbeanName, clazz, true);
                    }
                    catch (Exception e) {
                        Thread.sleep(2000L);
                        continue;
                    }
                }
                return null;
            }
        });
        Future future = completionService.poll(timeout, TimeUnit.MILLISECONDS);
        if (future != null) {
            return future.get();
        }
        return null;
    }
}

