/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.CreateContainerBasicOptions;
import io.fabric8.api.FabricException;
import io.fabric8.api.FabricService;
import io.fabric8.api.ServiceLocator;
import io.fabric8.api.ServiceProxy;
import io.fabric8.itests.paxexam.support.ContainerBuilder;
import io.fabric8.itests.paxexam.support.ContainerProxy;
import io.fabric8.service.ssh.CreateSshContainerOptions;
import java.util.ArrayList;
import java.util.Set;
import org.osgi.framework.BundleContext;

public class SshContainerBuilder
extends ContainerBuilder<SshContainerBuilder, CreateSshContainerOptions.Builder> {
    public static final String SSH_HOSTS_PROPERTY = "FABRIC_ITEST_SSH_HOSTS";
    public static final String SSH_USERS_PROPERTY = "FABRIC_ITEST_SSH_USERS";
    public static final String SSH_PASSWORD_PROPERTY = "FABRIC_ITEST_SSH_PASSWORDS";
    public static final String SSH_RESOLVER_PROPERTY = "FABRIC_ITEST_SSH_RESOLVER";

    protected SshContainerBuilder(ServiceProxy<FabricService> proxy, CreateSshContainerOptions.Builder builder) {
        super(proxy, (CreateContainerBasicOptions.Builder)builder.zookeeperPassword("admin"));
    }

    public static CreateSshContainerOptions defaultOptions() {
        CreateSshContainerOptions options = CreateSshContainerOptions.builder().build();
        return options;
    }

    @Override
    public Set<ContainerProxy> build() {
        BundleContext bundleContext = ContainerBuilder.getBundleContext();
        if (((CreateSshContainerOptions.Builder)this.getOptionsBuilder()).getHost() == null || ((CreateSshContainerOptions.Builder)this.getOptionsBuilder()).getHost().isEmpty()) {
            FabricService fabricService = (FabricService)ServiceLocator.awaitService((BundleContext)bundleContext, FabricService.class);
            ((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)this.getOptionsBuilder()).zookeeperUrl(fabricService.getZookeeperUrl())).zookeeperPassword("admin")).proxyUri(fabricService.getMavenRepoURI());
            String hostProperty = System.getProperty(SSH_HOSTS_PROPERTY);
            String userProperty = System.getProperty(SSH_USERS_PROPERTY);
            String passwordProperty = System.getProperty(SSH_PASSWORD_PROPERTY);
            String resolverProperty = System.getProperty(SSH_RESOLVER_PROPERTY, "localhostname");
            if (resolverProperty.isEmpty()) {
                resolverProperty = "localhostname";
            }
            String numberOfContainersProperty = System.getProperty("FABRIC_ITEST_CONTAINER_NUMBER", "1");
            int numberOfContainers = Integer.parseInt(numberOfContainersProperty);
            String[] hosts = null;
            String[] usernames = null;
            String[] passwords = null;
            if (hostProperty != null && !hostProperty.isEmpty()) {
                hosts = hostProperty.replaceAll(" ", "").split(",");
            }
            if (userProperty != null && !userProperty.isEmpty()) {
                usernames = userProperty.replaceAll(" ", "").split(",");
            }
            if (passwordProperty != null && !passwordProperty.isEmpty()) {
                passwords = passwordProperty.replaceAll(" ", "").split(",");
            }
            int numberOfHosts = hosts.length;
            int containersPerHost = numberOfContainers > 1 ? numberOfContainers / numberOfHosts : 1;
            ArrayList<CreateSshContainerOptions.Builder> optionsList = new ArrayList<CreateSshContainerOptions.Builder>();
            for (int i = 0; i < hosts.length; ++i) {
                try {
                    CreateSshContainerOptions.Builder hostOpts = (CreateSshContainerOptions.Builder)((CreateSshContainerOptions.Builder)this.getOptionsBuilder()).clone();
                    ((CreateSshContainerOptions.Builder)hostOpts.number(containersPerHost)).host(hosts[i]);
                    if (hostOpts.getNumber() > 1) {
                        hostOpts.name(hostOpts.getName() + "-" + i + "-");
                    } else {
                        hostOpts.name(hostOpts.getName() + i);
                    }
                    hostOpts.resolver(resolverProperty);
                    if (usernames.length > i) {
                        hostOpts.setUsername(usernames[i]);
                    }
                    if (passwords.length > i) {
                        hostOpts.setPassword(passwords[i]);
                    }
                    optionsList.add(hostOpts);
                    continue;
                }
                catch (CloneNotSupportedException e) {
                    throw FabricException.launderThrowable((Throwable)e);
                }
            }
            return super.build(optionsList);
        }
        return super.build();
    }
}

