/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import io.fabric8.api.DynamicReferenceException;
import io.fabric8.api.FabricException;
import io.fabric8.api.scr.InvalidComponentException;
import java.util.concurrent.Callable;

public class WaitForAliveTask
implements Callable<Boolean> {
    private final Long provisionTimeOut;
    private final Container container;
    private final boolean alive;

    public WaitForAliveTask(Container container, boolean alive, Long provisionTimeOut) {
        this.provisionTimeOut = provisionTimeOut;
        this.container = container;
        this.alive = alive;
    }

    @Override
    public Boolean call() throws Exception {
        boolean isAlive = this.isAlive(this.container);
        for (long t = 0L; isAlive != this.alive && t < this.provisionTimeOut; t += 2000L) {
            try {
                System.out.println("Container:" + this.container.getId() + " Alive:" + this.container.isAlive());
                isAlive = this.isAlive(this.container);
                if (isAlive == this.alive) continue;
                Thread.sleep(2000L);
                continue;
            }
            catch (DynamicReferenceException e) {
                return false;
            }
            catch (FabricException e) {
                continue;
            }
            catch (InvalidComponentException e) {
                // empty catch block
            }
        }
        return isAlive == this.alive;
    }

    private boolean isAlive(Container c) {
        try {
            return c.isAlive();
        }
        catch (Throwable t) {
            return false;
        }
    }
}

