/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.itests.paxexam.support;

import io.fabric8.api.Container;
import java.util.concurrent.Callable;

public class WaitForProvisionTask
implements Callable<Boolean> {
    private final Long provisionTimeOut;
    private final Container container;
    private final String status;

    public WaitForProvisionTask(Container container, String status, Long provisionTimeOut) {
        this.provisionTimeOut = provisionTimeOut;
        this.container = container;
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < this.provisionTimeOut) {
            StringBuilder sb = new StringBuilder();
            try {
                sb.append("Container: ").append(this.container.getId()).append(" ");
                sb.append("Alive:").append(this.container.isAlive()).append(" ");
                if (this.container.getProvisionException() != null) {
                    sb.append("Exception:").append(this.container.getProvisionException()).append(" ");
                    Boolean bl = false;
                    return bl;
                }
                sb.append("Status:").append(this.container.getProvisionStatus()).append(" ");
                sb.append("SSH URL:").append(this.container.getSshUrl()).append(" ");
                if (this.isSuccessful(this.container, this.status)) {
                    Boolean bl = true;
                    return bl;
                }
                if (!this.isFailed(this.container, this.status)) continue;
                Boolean bl = false;
                return bl;
            }
            catch (Throwable tr) {}
            continue;
            finally {
                System.out.println(sb.toString());
                Thread.sleep(1000L);
            }
        }
        System.out.println("Container:" + this.container.getId() + " Alive:" + this.container.isAlive() + " Status:" + this.container.getProvisionStatus() + " SSH URL:" + this.container.getSshUrl() + " - Timed Out");
        return false;
    }

    private boolean isSuccessful(Container container, String status) {
        try {
            return container.isAlive() && container.getProvisionException() == null && (container.getProvisionStatus().equals(status) || !container.isManaged()) && container.getSshUrl() != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private boolean isFailed(Container container, String status) {
        try {
            return container.getProvisionException() != null || "failed".equals(container.getProvisionStatus()) || container.getProvisionStatus() != null && container.getProvisionStatus().contains("error");
        }
        catch (Throwable t) {
            return false;
        }
    }
}

