/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend;
import io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendFluent;
import java.util.Objects;

public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>>
extends BaseFluent<A>
implements IngressBackendFluent<A> {
    private TypedLocalObjectReference resource;
    private String serviceName;
    private IntOrStringBuilder servicePort;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(IngressBackend instance) {
        this.withResource(instance.getResource());
        this.withServiceName(instance.getServiceName());
        this.withServicePort(instance.getServicePort());
    }

    @Override
    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    @Override
    public A withResource(TypedLocalObjectReference resource) {
        this.resource = resource;
        return (A)this;
    }

    @Override
    public Boolean hasResource() {
        return this.resource != null;
    }

    @Override
    public A withNewResource(String apiGroup, String kind, String name) {
        return this.withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public A withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    @Override
    public A withNewServiceName(String arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuilder arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    public A withNewServiceName(StringBuffer arg1) {
        return this.withServiceName(new String(arg1));
    }

    @Override
    @Deprecated
    public IntOrString getServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    @Override
    public IntOrString buildServicePort() {
        return this.servicePort != null ? this.servicePort.build() : null;
    }

    @Override
    public A withServicePort(IntOrString servicePort) {
        this._visitables.get((Object)"servicePort").remove(this.servicePort);
        if (servicePort != null) {
            this.servicePort = new IntOrStringBuilder(servicePort);
            this._visitables.get((Object)"servicePort").add(this.servicePort);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServicePort() {
        return this.servicePort != null;
    }

    @Override
    public A withNewServicePort(String strVal) {
        return this.withServicePort(new IntOrString(strVal));
    }

    @Override
    public A withNewServicePort(Integer intVal) {
        return this.withServicePort(new IntOrString(intVal));
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePort() {
        return new ServicePortNestedImpl();
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item) {
        return new ServicePortNestedImpl(item);
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editServicePort() {
        return this.withNewServicePortLike(this.getServicePort());
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePort() {
        return this.withNewServicePortLike(this.getServicePort() != null ? this.getServicePort() : new IntOrStringBuilder().build());
    }

    @Override
    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
        return this.withNewServicePortLike(this.getServicePort() != null ? this.getServicePort() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngressBackendFluentImpl that = (IngressBackendFluentImpl)o;
        if (this.resource != null ? !this.resource.equals((Object)that.resource) : that.resource != null) {
            return false;
        }
        if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) {
            return false;
        }
        return !(this.servicePort != null ? !this.servicePort.equals((Object)that.servicePort) : that.servicePort != null);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.serviceName, this.servicePort, super.hashCode());
    }

    public class ServicePortNestedImpl<N>
    extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>>
    implements IngressBackendFluent.ServicePortNested<N>,
    Nested<N> {
        private final IntOrStringBuilder builder;

        ServicePortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this, item);
        }

        ServicePortNestedImpl() {
            this.builder = new IntOrStringBuilder((IntOrStringFluent)this);
        }

        @Override
        public N and() {
            return (N)IngressBackendFluentImpl.this.withServicePort(this.builder.build());
        }

        @Override
        public N endServicePort() {
            return this.and();
        }
    }
}

