/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.server.mock.crud;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.server.mock.crud.KubernetesCrudDispatcherException;
import io.fabric8.kubernetes.client.server.mock.crud.KubernetesCrudDispatcherHandler;
import io.fabric8.kubernetes.client.server.mock.crud.KubernetesCrudPersistence;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.mockwebserver.crud.AttributeSet;
import io.fabric8.zjsonpatch.JsonPatch;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.mockwebserver.MockResponse;

public class PatchHandler
implements KubernetesCrudDispatcherHandler {
    private static final String PATH = "path";
    private final KubernetesCrudPersistence persistence;

    public PatchHandler(KubernetesCrudPersistence persistence) {
        this.persistence = persistence;
    }

    @Override
    public MockResponse handle(String path, String contentType, String requestBody) throws KubernetesCrudDispatcherException {
        JsonNode updatedResource;
        AttributeSet query = this.persistence.getKey(path);
        Map.Entry<AttributeSet, String> currentResourceEntry = this.persistence.findResource(query);
        if (currentResourceEntry == null) {
            return new MockResponse().setResponseCode(404);
        }
        JsonNode currentResource = this.persistence.asNode(currentResourceEntry);
        JsonNode patch = this.persistence.asNode(requestBody);
        JsonNode fullPatch = this.getMergeType(contentType) == PatchType.JSON ? JsonPatch.apply((JsonNode)patch, (JsonNode)this.initPaths(currentResource.deepCopy(), patch)) : this.persistence.merge(currentResource, requestBody);
        this.validatePath(query, fullPatch);
        this.validateResourceVersion(currentResource, fullPatch);
        if (KubernetesCrudDispatcherHandler.isStatusPath(path)) {
            updatedResource = currentResource.deepCopy();
            KubernetesCrudDispatcherHandler.setStatus(updatedResource, fullPatch.get("status"));
        } else {
            updatedResource = fullPatch;
            if (this.persistence.isStatusSubresourceEnabledForResource(path)) {
                KubernetesCrudDispatcherHandler.setStatus(updatedResource, currentResource.path("status"));
            }
        }
        this.persistence.preserveMetadata(currentResource, updatedResource);
        if (!KubernetesCrudDispatcherHandler.isStatusPath(path)) {
            this.persistence.touchGeneration(currentResource, updatedResource);
        }
        this.persistence.touchResourceVersion(currentResource, updatedResource);
        String updatedAsString = Serialization.asJson((Object)updatedResource);
        GenericKubernetesResource deserializedResource = this.validateRequestBody(updatedAsString);
        if (deserializedResource.isMarkedForDeletion() && deserializedResource.getFinalizers().isEmpty()) {
            updatedAsString = null;
            deserializedResource = null;
        }
        this.persistence.processEvent(path, query, currentResourceEntry.getKey(), deserializedResource, updatedAsString);
        return new MockResponse().setResponseCode(202).setBody((String)Utils.getNonNullOrElse((Object)updatedAsString, (Object)""));
    }

    private PatchType getMergeType(String contentType) throws KubernetesCrudDispatcherException {
        PatchType mergeType;
        if (contentType == null) {
            mergeType = PatchType.JSON;
        } else {
            String subtype = Objects.requireNonNull(MediaType.parse((String)contentType)).subtype();
            if (subtype.equals(MediaType.get((String)PatchType.JSON.getContentType()).subtype())) {
                mergeType = PatchType.JSON;
            } else if (subtype.equals(MediaType.get((String)PatchType.JSON_MERGE.getContentType()).subtype())) {
                mergeType = PatchType.JSON_MERGE;
            } else {
                throw new KubernetesCrudDispatcherException("Unsupported Media Type", 415);
            }
        }
        return mergeType;
    }

    private JsonNode initPaths(JsonNode resource, JsonNode patch) {
        Iterator it = patch.elements();
        while (it.hasNext()) {
            String fullPath = ((JsonNode)it.next()).get(PATH).asText();
            String[] paths = fullPath.replaceAll("^/", "").split("/");
            JsonNode node = resource;
            for (int p = 0; p < paths.length - 1; ++p) {
                String path = paths[p];
                if (node.get(path) == null && node.isObject()) {
                    ((ObjectNode)node).set(path, (JsonNode)((ObjectNode)node).objectNode());
                }
                node = node.path(path);
            }
        }
        return resource;
    }
}

