/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetReference;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetReferenceBuilder;
import io.fabric8.openshift.api.model.hive.v1.ClusterImageSetReferenceFluentImpl;
import io.fabric8.openshift.api.model.hive.v1.Provisioning;
import io.fabric8.openshift.api.model.hive.v1.ProvisioningFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProvisioningFluentImpl<A extends ProvisioningFluent<A>>
extends BaseFluent<A>
implements ProvisioningFluent<A> {
    private ClusterImageSetReferenceBuilder imageSetRef;
    private LocalObjectReferenceBuilder installConfigSecretRef;
    private List<EnvVar> installerEnv = new ArrayList<EnvVar>();
    private String installerImageOverride;
    private LocalObjectReferenceBuilder manifestsConfigMapRef;
    private String releaseImage;
    private List<String> sshKnownHosts = new ArrayList<String>();
    private LocalObjectReferenceBuilder sshPrivateKeySecretRef;
    private Map<String, Object> additionalProperties;

    public ProvisioningFluentImpl() {
    }

    public ProvisioningFluentImpl(Provisioning instance) {
        if (instance != null) {
            this.withImageSetRef(instance.getImageSetRef());
            this.withInstallConfigSecretRef(instance.getInstallConfigSecretRef());
            this.withInstallerEnv(instance.getInstallerEnv());
            this.withInstallerImageOverride(instance.getInstallerImageOverride());
            this.withManifestsConfigMapRef(instance.getManifestsConfigMapRef());
            this.withReleaseImage(instance.getReleaseImage());
            this.withSshKnownHosts(instance.getSshKnownHosts());
            this.withSshPrivateKeySecretRef(instance.getSshPrivateKeySecretRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public ClusterImageSetReference getImageSetRef() {
        return this.imageSetRef != null ? this.imageSetRef.build() : null;
    }

    @Override
    public ClusterImageSetReference buildImageSetRef() {
        return this.imageSetRef != null ? this.imageSetRef.build() : null;
    }

    @Override
    public A withImageSetRef(ClusterImageSetReference imageSetRef) {
        this._visitables.get((Object)"imageSetRef").remove(this.imageSetRef);
        if (imageSetRef != null) {
            this.imageSetRef = new ClusterImageSetReferenceBuilder(imageSetRef);
            this._visitables.get((Object)"imageSetRef").add(this.imageSetRef);
        } else {
            this.imageSetRef = null;
            this._visitables.get((Object)"imageSetRef").remove(this.imageSetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageSetRef() {
        return this.imageSetRef != null;
    }

    @Override
    public A withNewImageSetRef(String name) {
        return this.withImageSetRef(new ClusterImageSetReference(name));
    }

    @Override
    public ProvisioningFluent.ImageSetRefNested<A> withNewImageSetRef() {
        return new ImageSetRefNestedImpl();
    }

    @Override
    public ProvisioningFluent.ImageSetRefNested<A> withNewImageSetRefLike(ClusterImageSetReference item) {
        return new ImageSetRefNestedImpl(item);
    }

    @Override
    public ProvisioningFluent.ImageSetRefNested<A> editImageSetRef() {
        return this.withNewImageSetRefLike(this.getImageSetRef());
    }

    @Override
    public ProvisioningFluent.ImageSetRefNested<A> editOrNewImageSetRef() {
        return this.withNewImageSetRefLike(this.getImageSetRef() != null ? this.getImageSetRef() : new ClusterImageSetReferenceBuilder().build());
    }

    @Override
    public ProvisioningFluent.ImageSetRefNested<A> editOrNewImageSetRefLike(ClusterImageSetReference item) {
        return this.withNewImageSetRefLike(this.getImageSetRef() != null ? this.getImageSetRef() : item);
    }

    @Override
    @Deprecated
    public LocalObjectReference getInstallConfigSecretRef() {
        return this.installConfigSecretRef != null ? this.installConfigSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildInstallConfigSecretRef() {
        return this.installConfigSecretRef != null ? this.installConfigSecretRef.build() : null;
    }

    @Override
    public A withInstallConfigSecretRef(LocalObjectReference installConfigSecretRef) {
        this._visitables.get((Object)"installConfigSecretRef").remove(this.installConfigSecretRef);
        if (installConfigSecretRef != null) {
            this.installConfigSecretRef = new LocalObjectReferenceBuilder(installConfigSecretRef);
            this._visitables.get((Object)"installConfigSecretRef").add(this.installConfigSecretRef);
        } else {
            this.installConfigSecretRef = null;
            this._visitables.get((Object)"installConfigSecretRef").remove(this.installConfigSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInstallConfigSecretRef() {
        return this.installConfigSecretRef != null;
    }

    @Override
    public A withNewInstallConfigSecretRef(String name) {
        return this.withInstallConfigSecretRef(new LocalObjectReference(name));
    }

    @Override
    public ProvisioningFluent.InstallConfigSecretRefNested<A> withNewInstallConfigSecretRef() {
        return new InstallConfigSecretRefNestedImpl();
    }

    @Override
    public ProvisioningFluent.InstallConfigSecretRefNested<A> withNewInstallConfigSecretRefLike(LocalObjectReference item) {
        return new InstallConfigSecretRefNestedImpl(item);
    }

    @Override
    public ProvisioningFluent.InstallConfigSecretRefNested<A> editInstallConfigSecretRef() {
        return this.withNewInstallConfigSecretRefLike(this.getInstallConfigSecretRef());
    }

    @Override
    public ProvisioningFluent.InstallConfigSecretRefNested<A> editOrNewInstallConfigSecretRef() {
        return this.withNewInstallConfigSecretRefLike(this.getInstallConfigSecretRef() != null ? this.getInstallConfigSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ProvisioningFluent.InstallConfigSecretRefNested<A> editOrNewInstallConfigSecretRefLike(LocalObjectReference item) {
        return this.withNewInstallConfigSecretRefLike(this.getInstallConfigSecretRef() != null ? this.getInstallConfigSecretRef() : item);
    }

    @Override
    public A addToInstallerEnv(int index, EnvVar item) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        this.installerEnv.add(index, item);
        return (A)this;
    }

    @Override
    public A setToInstallerEnv(int index, EnvVar item) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        this.installerEnv.set(index, item);
        return (A)this;
    }

    @Override
    public A addToInstallerEnv(EnvVar ... items) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.installerEnv.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToInstallerEnv(Collection<EnvVar> items) {
        if (this.installerEnv == null) {
            this.installerEnv = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.installerEnv.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromInstallerEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.installerEnv == null) continue;
            this.installerEnv.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInstallerEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.installerEnv == null) continue;
            this.installerEnv.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getInstallerEnv() {
        return this.installerEnv;
    }

    @Override
    public EnvVar getInstallerEnv(int index) {
        return this.installerEnv.get(index);
    }

    @Override
    public EnvVar getFirstInstallerEnv() {
        return this.installerEnv.get(0);
    }

    @Override
    public EnvVar getLastInstallerEnv() {
        return this.installerEnv.get(this.installerEnv.size() - 1);
    }

    @Override
    public EnvVar getMatchingInstallerEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.installerEnv) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInstallerEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.installerEnv) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInstallerEnv(List<EnvVar> installerEnv) {
        if (installerEnv != null) {
            this.installerEnv = new ArrayList<EnvVar>();
            for (EnvVar item : installerEnv) {
                this.addToInstallerEnv(item);
            }
        } else {
            this.installerEnv = null;
        }
        return (A)this;
    }

    @Override
    public A withInstallerEnv(EnvVar ... installerEnv) {
        if (this.installerEnv != null) {
            this.installerEnv.clear();
            this._visitables.remove((Object)"installerEnv");
        }
        if (installerEnv != null) {
            for (EnvVar item : installerEnv) {
                this.addToInstallerEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInstallerEnv() {
        return this.installerEnv != null && !this.installerEnv.isEmpty();
    }

    @Override
    public String getInstallerImageOverride() {
        return this.installerImageOverride;
    }

    @Override
    public A withInstallerImageOverride(String installerImageOverride) {
        this.installerImageOverride = installerImageOverride;
        return (A)this;
    }

    @Override
    public Boolean hasInstallerImageOverride() {
        return this.installerImageOverride != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getManifestsConfigMapRef() {
        return this.manifestsConfigMapRef != null ? this.manifestsConfigMapRef.build() : null;
    }

    @Override
    public LocalObjectReference buildManifestsConfigMapRef() {
        return this.manifestsConfigMapRef != null ? this.manifestsConfigMapRef.build() : null;
    }

    @Override
    public A withManifestsConfigMapRef(LocalObjectReference manifestsConfigMapRef) {
        this._visitables.get((Object)"manifestsConfigMapRef").remove(this.manifestsConfigMapRef);
        if (manifestsConfigMapRef != null) {
            this.manifestsConfigMapRef = new LocalObjectReferenceBuilder(manifestsConfigMapRef);
            this._visitables.get((Object)"manifestsConfigMapRef").add(this.manifestsConfigMapRef);
        } else {
            this.manifestsConfigMapRef = null;
            this._visitables.get((Object)"manifestsConfigMapRef").remove(this.manifestsConfigMapRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasManifestsConfigMapRef() {
        return this.manifestsConfigMapRef != null;
    }

    @Override
    public A withNewManifestsConfigMapRef(String name) {
        return this.withManifestsConfigMapRef(new LocalObjectReference(name));
    }

    @Override
    public ProvisioningFluent.ManifestsConfigMapRefNested<A> withNewManifestsConfigMapRef() {
        return new ManifestsConfigMapRefNestedImpl();
    }

    @Override
    public ProvisioningFluent.ManifestsConfigMapRefNested<A> withNewManifestsConfigMapRefLike(LocalObjectReference item) {
        return new ManifestsConfigMapRefNestedImpl(item);
    }

    @Override
    public ProvisioningFluent.ManifestsConfigMapRefNested<A> editManifestsConfigMapRef() {
        return this.withNewManifestsConfigMapRefLike(this.getManifestsConfigMapRef());
    }

    @Override
    public ProvisioningFluent.ManifestsConfigMapRefNested<A> editOrNewManifestsConfigMapRef() {
        return this.withNewManifestsConfigMapRefLike(this.getManifestsConfigMapRef() != null ? this.getManifestsConfigMapRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ProvisioningFluent.ManifestsConfigMapRefNested<A> editOrNewManifestsConfigMapRefLike(LocalObjectReference item) {
        return this.withNewManifestsConfigMapRefLike(this.getManifestsConfigMapRef() != null ? this.getManifestsConfigMapRef() : item);
    }

    @Override
    public String getReleaseImage() {
        return this.releaseImage;
    }

    @Override
    public A withReleaseImage(String releaseImage) {
        this.releaseImage = releaseImage;
        return (A)this;
    }

    @Override
    public Boolean hasReleaseImage() {
        return this.releaseImage != null;
    }

    @Override
    public A addToSshKnownHosts(int index, String item) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        this.sshKnownHosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSshKnownHosts(int index, String item) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        this.sshKnownHosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSshKnownHosts(String ... items) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.sshKnownHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSshKnownHosts(Collection<String> items) {
        if (this.sshKnownHosts == null) {
            this.sshKnownHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.sshKnownHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSshKnownHosts(String ... items) {
        for (String item : items) {
            if (this.sshKnownHosts == null) continue;
            this.sshKnownHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSshKnownHosts(Collection<String> items) {
        for (String item : items) {
            if (this.sshKnownHosts == null) continue;
            this.sshKnownHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getSshKnownHosts() {
        return this.sshKnownHosts;
    }

    @Override
    public String getSshKnownHost(int index) {
        return this.sshKnownHosts.get(index);
    }

    @Override
    public String getFirstSshKnownHost() {
        return this.sshKnownHosts.get(0);
    }

    @Override
    public String getLastSshKnownHost() {
        return this.sshKnownHosts.get(this.sshKnownHosts.size() - 1);
    }

    @Override
    public String getMatchingSshKnownHost(Predicate<String> predicate) {
        for (String item : this.sshKnownHosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSshKnownHost(Predicate<String> predicate) {
        for (String item : this.sshKnownHosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSshKnownHosts(List<String> sshKnownHosts) {
        if (sshKnownHosts != null) {
            this.sshKnownHosts = new ArrayList<String>();
            for (String item : sshKnownHosts) {
                this.addToSshKnownHosts(item);
            }
        } else {
            this.sshKnownHosts = null;
        }
        return (A)this;
    }

    @Override
    public A withSshKnownHosts(String ... sshKnownHosts) {
        if (this.sshKnownHosts != null) {
            this.sshKnownHosts.clear();
            this._visitables.remove((Object)"sshKnownHosts");
        }
        if (sshKnownHosts != null) {
            for (String item : sshKnownHosts) {
                this.addToSshKnownHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSshKnownHosts() {
        return this.sshKnownHosts != null && !this.sshKnownHosts.isEmpty();
    }

    @Override
    @Deprecated
    public LocalObjectReference getSshPrivateKeySecretRef() {
        return this.sshPrivateKeySecretRef != null ? this.sshPrivateKeySecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildSshPrivateKeySecretRef() {
        return this.sshPrivateKeySecretRef != null ? this.sshPrivateKeySecretRef.build() : null;
    }

    @Override
    public A withSshPrivateKeySecretRef(LocalObjectReference sshPrivateKeySecretRef) {
        this._visitables.get((Object)"sshPrivateKeySecretRef").remove(this.sshPrivateKeySecretRef);
        if (sshPrivateKeySecretRef != null) {
            this.sshPrivateKeySecretRef = new LocalObjectReferenceBuilder(sshPrivateKeySecretRef);
            this._visitables.get((Object)"sshPrivateKeySecretRef").add(this.sshPrivateKeySecretRef);
        } else {
            this.sshPrivateKeySecretRef = null;
            this._visitables.get((Object)"sshPrivateKeySecretRef").remove(this.sshPrivateKeySecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSshPrivateKeySecretRef() {
        return this.sshPrivateKeySecretRef != null;
    }

    @Override
    public A withNewSshPrivateKeySecretRef(String name) {
        return this.withSshPrivateKeySecretRef(new LocalObjectReference(name));
    }

    @Override
    public ProvisioningFluent.SshPrivateKeySecretRefNested<A> withNewSshPrivateKeySecretRef() {
        return new SshPrivateKeySecretRefNestedImpl();
    }

    @Override
    public ProvisioningFluent.SshPrivateKeySecretRefNested<A> withNewSshPrivateKeySecretRefLike(LocalObjectReference item) {
        return new SshPrivateKeySecretRefNestedImpl(item);
    }

    @Override
    public ProvisioningFluent.SshPrivateKeySecretRefNested<A> editSshPrivateKeySecretRef() {
        return this.withNewSshPrivateKeySecretRefLike(this.getSshPrivateKeySecretRef());
    }

    @Override
    public ProvisioningFluent.SshPrivateKeySecretRefNested<A> editOrNewSshPrivateKeySecretRef() {
        return this.withNewSshPrivateKeySecretRefLike(this.getSshPrivateKeySecretRef() != null ? this.getSshPrivateKeySecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public ProvisioningFluent.SshPrivateKeySecretRefNested<A> editOrNewSshPrivateKeySecretRefLike(LocalObjectReference item) {
        return this.withNewSshPrivateKeySecretRefLike(this.getSshPrivateKeySecretRef() != null ? this.getSshPrivateKeySecretRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProvisioningFluentImpl that = (ProvisioningFluentImpl)o;
        if (!Objects.equals(this.imageSetRef, that.imageSetRef)) {
            return false;
        }
        if (!Objects.equals(this.installConfigSecretRef, that.installConfigSecretRef)) {
            return false;
        }
        if (!Objects.equals(this.installerEnv, that.installerEnv)) {
            return false;
        }
        if (!Objects.equals(this.installerImageOverride, that.installerImageOverride)) {
            return false;
        }
        if (!Objects.equals(this.manifestsConfigMapRef, that.manifestsConfigMapRef)) {
            return false;
        }
        if (!Objects.equals(this.releaseImage, that.releaseImage)) {
            return false;
        }
        if (!Objects.equals(this.sshKnownHosts, that.sshKnownHosts)) {
            return false;
        }
        if (!Objects.equals(this.sshPrivateKeySecretRef, that.sshPrivateKeySecretRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.imageSetRef, this.installConfigSecretRef, this.installerEnv, this.installerImageOverride, this.manifestsConfigMapRef, this.releaseImage, this.sshKnownHosts, this.sshPrivateKeySecretRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageSetRef != null) {
            sb.append("imageSetRef:");
            sb.append(this.imageSetRef + ",");
        }
        if (this.installConfigSecretRef != null) {
            sb.append("installConfigSecretRef:");
            sb.append(this.installConfigSecretRef + ",");
        }
        if (this.installerEnv != null && !this.installerEnv.isEmpty()) {
            sb.append("installerEnv:");
            sb.append(this.installerEnv + ",");
        }
        if (this.installerImageOverride != null) {
            sb.append("installerImageOverride:");
            sb.append(this.installerImageOverride + ",");
        }
        if (this.manifestsConfigMapRef != null) {
            sb.append("manifestsConfigMapRef:");
            sb.append(this.manifestsConfigMapRef + ",");
        }
        if (this.releaseImage != null) {
            sb.append("releaseImage:");
            sb.append(this.releaseImage + ",");
        }
        if (this.sshKnownHosts != null && !this.sshKnownHosts.isEmpty()) {
            sb.append("sshKnownHosts:");
            sb.append(this.sshKnownHosts + ",");
        }
        if (this.sshPrivateKeySecretRef != null) {
            sb.append("sshPrivateKeySecretRef:");
            sb.append(this.sshPrivateKeySecretRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SshPrivateKeySecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ProvisioningFluent.SshPrivateKeySecretRefNested<N>>
    implements ProvisioningFluent.SshPrivateKeySecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        SshPrivateKeySecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        SshPrivateKeySecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluentImpl.this.withSshPrivateKeySecretRef(this.builder.build());
        }

        @Override
        public N endSshPrivateKeySecretRef() {
            return this.and();
        }
    }

    class ManifestsConfigMapRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ProvisioningFluent.ManifestsConfigMapRefNested<N>>
    implements ProvisioningFluent.ManifestsConfigMapRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        ManifestsConfigMapRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        ManifestsConfigMapRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluentImpl.this.withManifestsConfigMapRef(this.builder.build());
        }

        @Override
        public N endManifestsConfigMapRef() {
            return this.and();
        }
    }

    class InstallConfigSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<ProvisioningFluent.InstallConfigSecretRefNested<N>>
    implements ProvisioningFluent.InstallConfigSecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        InstallConfigSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this, item);
        }

        InstallConfigSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder((LocalObjectReferenceFluent)this);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluentImpl.this.withInstallConfigSecretRef(this.builder.build());
        }

        @Override
        public N endInstallConfigSecretRef() {
            return this.and();
        }
    }

    class ImageSetRefNestedImpl<N>
    extends ClusterImageSetReferenceFluentImpl<ProvisioningFluent.ImageSetRefNested<N>>
    implements ProvisioningFluent.ImageSetRefNested<N>,
    Nested<N> {
        ClusterImageSetReferenceBuilder builder;

        ImageSetRefNestedImpl(ClusterImageSetReference item) {
            this.builder = new ClusterImageSetReferenceBuilder(this, item);
        }

        ImageSetRefNestedImpl() {
            this.builder = new ClusterImageSetReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProvisioningFluentImpl.this.withImageSetRef(this.builder.build());
        }

        @Override
        public N endImageSetRef() {
            return this.and();
        }
    }
}

