/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.MainWithArgsInFile;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;

class Fork {
    private static final String ARG_FILE_PREFIX = "gatling-maven-plugin-";
    private static final String ARG_FILE_SUFFIX = ".args";
    private final String javaExecutable;
    private final String mainClassName;
    private final List<String> classpath;
    private final boolean propagateSystemProperties;
    private final Log log;
    private final List<String> jvmArgs = new ArrayList<String>();
    private final List<String> args = new ArrayList<String>();

    Fork(String mainClassName, List<String> classpath, List<String> jvmArgs, List<String> args, Toolchain toolchain, boolean propagateSystemProperties, Log log) {
        this.mainClassName = mainClassName;
        this.classpath = classpath;
        this.jvmArgs.addAll(jvmArgs);
        this.args.addAll(args);
        this.javaExecutable = this.safe(this.toWindowsShortName(this.findJavaExecutable(toolchain)));
        this.propagateSystemProperties = propagateSystemProperties;
        this.log = log;
    }

    private String toWindowsShortName(String value) {
        int programFilesIndex;
        if (MojoUtils.IS_WINDOWS && (programFilesIndex = value.indexOf("Program Files")) >= 0) {
            int firstSeparatorAfterProgramFiles = value.indexOf(File.separator, programFilesIndex + "Program Files".length());
            File longNameDir = firstSeparatorAfterProgramFiles < 0 ? new File(value) : new File(value.substring(0, firstSeparatorAfterProgramFiles));
            for (int i = 0; i < 10; ++i) {
                File shortNameDir = new File(longNameDir.getParent(), "Progra~" + i);
                if (!shortNameDir.equals(longNameDir)) continue;
                return shortNameDir.toString();
            }
        }
        return value;
    }

    private String safe(String value) {
        return value.contains(" ") ? '\"' + value + '\"' : value;
    }

    void run() throws Exception {
        int exitValue;
        if (this.propagateSystemProperties) {
            for (Map.Entry<Object, Object> systemProp : System.getProperties().entrySet()) {
                String name = systemProp.getKey().toString();
                String value = this.toWindowsShortName(systemProp.getValue().toString());
                if (!this.isPropagatableProperty(name)) continue;
                if (name.contains(" ")) {
                    this.log.warn((CharSequence)("System property name '" + name + "' contains a whitespace and can't be propagated"));
                    continue;
                }
                if (MojoUtils.IS_WINDOWS && value.contains(" ")) {
                    this.log.warn((CharSequence)("System property value '" + (String)value + "' contains a whitespace and can't be propagated on Windows"));
                    continue;
                }
                this.jvmArgs.add("-D" + name + "=" + this.safe(StringUtils.escape((String)value)));
            }
        }
        this.jvmArgs.add("-jar");
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)StringUtils.join(this.classpath.iterator(), (String)",\n"));
        }
        this.jvmArgs.add(MojoUtils.createBooterJar(this.classpath, MainWithArgsInFile.class.getName()).getCanonicalPath());
        List<String> command = this.buildCommand();
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in));
        exec.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        CommandLine cl = new CommandLine(this.javaExecutable);
        for (String arg : command) {
            cl.addArgument(arg, false);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)cl.toString());
        }
        if ((exitValue = exec.execute(cl)) != 0) {
            throw new MojoFailureException("command line returned non-zero value:" + exitValue);
        }
    }

    private List<String> buildCommand() throws IOException {
        ArrayList<String> command = new ArrayList<String>(this.jvmArgs.size() + 2);
        command.addAll(this.jvmArgs);
        command.add(this.mainClassName);
        command.add(this.createArgFile(this.args).getCanonicalPath());
        return command;
    }

    private boolean isPropagatableProperty(String name) {
        return !name.startsWith("java.") && !name.startsWith("sun.") && !name.startsWith("maven.") && !name.startsWith("file.") && !name.startsWith("awt.") && !name.startsWith("os.") && !name.startsWith("user.") && !name.startsWith("idea.") && !name.startsWith("guice.") && !name.startsWith("hudson.") && !name.equals("line.separator") && !name.equals("path.separator") && !name.equals("classworlds.conf") && !name.equals("org.slf4j.simpleLogger.defaultLogLevel");
    }

    private String findJavaExecutable(Toolchain toolchain) {
        String fromToolchain;
        String string = fromToolchain = toolchain != null ? toolchain.findTool("java") : null;
        if (fromToolchain != null) {
            return fromToolchain;
        }
        String javaHome = System.getProperty("java.home");
        if (javaHome == null && (javaHome = System.getenv("JAVA_HOME")) == null) {
            throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
        }
        return javaHome + File.separator + "bin" + File.separator + "java";
    }

    private File createArgFile(List<String> args) throws IOException {
        File argFile = File.createTempFile(ARG_FILE_PREFIX, ARG_FILE_SUFFIX);
        argFile.deleteOnExit();
        try (PrintWriter out = new PrintWriter(argFile);){
            for (String arg : args) {
                out.println(arg);
            }
            File file = argFile;
            return file;
        }
    }
}

