/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.recorder.ui.headless;

import io.gatling.recorder.config.RecorderConfiguration;
import io.gatling.recorder.config.RecorderMode;
import io.gatling.recorder.config.RecorderMode$Proxy$;
import io.gatling.recorder.controller.RecorderController;
import io.gatling.recorder.ui.FrontEndEvent;
import io.gatling.recorder.ui.RecorderFrontEnd;
import io.gatling.recorder.ui.headless.HeadlessFrontEnd$;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0005\u0005}rAB\r\u001b\u0011\u0003QBE\u0002\u0004'5!\u0005!d\n\u0005\u0006]\u0005!\t\u0001\r\u0005\bc\u0005\u0011\r\u0011\"\u00033\u0011\u0019Q\u0014\u0001)A\u0005g\u0019)aE\u0007\u0001\u001dw!A\u0001)\u0002B\u0001B\u0003%\u0011\t\u0003\u0005G\u000b\t\u0005\t\u0015!\u0003H\u0011\u0015qS\u0001\"\u0001N\u0011\u001d\tV\u00011A\u0005\nICqAV\u0003A\u0002\u0013%q\u000b\u0003\u0004^\u000b\u0001\u0006Ka\u0015\u0005\u0006=\u0016!\te\u0018\u0005\u0006G\u0016!\t\u0005\u001a\u0005\u0006U\u0016!\te\u001b\u0005\u0006Y\u0016!\t%\u001c\u0005\u0006w\u0016!\t\u0005 \u0005\u0007\u0003\u0017)A\u0011I6\t\r\u00055Q\u0001\"\u0011l\u0011\u001d\ty!\u0002C!\u0003#Aa!!\u000b\u0006\t\u0003\u0012\u0006BBA\u0016\u000b\u0011\u00053\u000eC\u0004\u0002.\u0015!\t%a\f\t\r\u0005UR\u0001\"\u0003l\u0011\u001d\t9$\u0002C\u0005\u0003s\t\u0001\u0003S3bI2,7o\u001d$s_:$XI\u001c3\u000b\u0005ma\u0012\u0001\u00035fC\u0012dWm]:\u000b\u0005uq\u0012AA;j\u0015\ty\u0002%\u0001\u0005sK\u000e|'\u000fZ3s\u0015\t\t#%A\u0004hCRd\u0017N\\4\u000b\u0003\r\n!![8\u0011\u0005\u0015\nQ\"\u0001\u000e\u0003!!+\u0017\r\u001a7fgN4%o\u001c8u\u000b:$7CA\u0001)!\tIC&D\u0001+\u0015\u0005Y\u0013!B:dC2\f\u0017BA\u0017+\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001%\u0003=\u0011VmY8sI\u0016\u0014\b+\u001b3GS2,W#A\u001a\u0011\u0005QBT\"A\u001b\u000b\u0005\r2$\"A\u001c\u0002\t)\fg/Y\u0005\u0003sU\u0012AAR5mK\u0006\u0001\"+Z2pe\u0012,'\u000fU5e\r&dW\rI\n\u0003\u000bq\u0002\"!\u0010 \u000e\u0003qI!a\u0010\u000f\u0003!I+7m\u001c:eKJ4%o\u001c8u\u000b:$\u0017AC2p]R\u0014x\u000e\u001c7feB\u0011!\tR\u0007\u0002\u0007*\u0011\u0001IH\u0005\u0003\u000b\u000e\u0013!CU3d_J$WM]\"p]R\u0014x\u000e\u001c7fe\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"\u0001S&\u000e\u0003%S!A\u0013\u0010\u0002\r\r|gNZ5h\u0013\ta\u0015JA\u000bSK\u000e|'\u000fZ3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u00079{\u0005\u000b\u0005\u0002&\u000b!)\u0001\t\u0003a\u0001\u0003\")a\t\u0003a\u0001\u000f\u00061\u0001.Y:Sk:,\u0012a\u0015\t\u0003SQK!!\u0016\u0016\u0003\u000f\t{w\u000e\\3b]\u0006Q\u0001.Y:Sk:|F%Z9\u0015\u0005a[\u0006CA\u0015Z\u0013\tQ&F\u0001\u0003V]&$\bb\u0002/\u000b\u0003\u0003\u0005\raU\u0001\u0004q\u0012\n\u0014a\u00025bgJ+h\u000eI\u0001\u0015g\u0016dWm\u0019;fIJ+7m\u001c:eKJlu\u000eZ3\u0016\u0003\u0001\u0004\"\u0001S1\n\u0005\tL%\u0001\u0004*fG>\u0014H-\u001a:N_\u0012,\u0017\u0001\u0004:fG\u0016Lg/Z#wK:$HC\u0001-f\u0011\u00151W\u00021\u0001h\u0003\u0015)g/\u001a8u!\ti\u0004.\u0003\u0002j9\tiaI]8oi\u0016sG-\u0012<f]R\fA!\u001b8jiR\t\u0001,\u0001\fiC:$G.\u001a%be\u0016C\bo\u001c:u\r\u0006LG.\u001e:f)\tAf\u000eC\u0003p\u001f\u0001\u0007\u0001/A\u0004nKN\u001c\u0018mZ3\u0011\u0005EDhB\u0001:w!\t\u0019(&D\u0001u\u0015\t)x&\u0001\u0004=e>|GOP\u0005\u0003o*\na\u0001\u0015:fI\u00164\u0017BA={\u0005\u0019\u0019FO]5oO*\u0011qOK\u0001\fQ\u0006\u0014h)\u001b7f!\u0006$\b.F\u0001~!\rq\u0018qA\u0007\u0002\u007f*!\u0011\u0011AA\u0002\u0003\u00111\u0017\u000e\\3\u000b\u0007\u0005\u0015a'A\u0002oS>L1!!\u0003\u0000\u0005\u0011\u0001\u0016\r\u001e5\u0002-!\fg\u000e\u001a7f\u0011\u0006\u0014X\t\u001f9peR\u001cVoY2fgN\f\u0001C]3d_J$\u0017N\\4Ti\u0006\u0014H/\u001a3\u0002=!\fg\u000e\u001a7f\r&dG/\u001a:WC2LG-\u0019;j_:4\u0015-\u001b7ve\u0016\u001cHc\u0001-\u0002\u0014!9\u0011QC\nA\u0002\u0005]\u0011\u0001\u00034bS2,(/Z:\u0011\u000b\u0005e\u00111\u00059\u000f\t\u0005m\u0011q\u0004\b\u0004g\u0006u\u0011\"A\u0016\n\u0007\u0005\u0005\"&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0012q\u0005\u0002\u0004'\u0016\f(bAA\u0011U\u00051\u0012m]6TS6,H.\u0019;j_:|e/\u001a:xe&$X-\u0001\tsK\u000e|'\u000fZ5oON#x\u000e\u001d9fI\u0006!\u0002.\u00198eY\u0016l\u0015n]:j]\u001eD\u0015M\u001d$jY\u0016$2\u0001WA\u0019\u0011\u0019\t\u0019D\u0006a\u0001{\u0006!\u0001/\u0019;i\u00039\u0019'/Z1uK2{7m\u001b$jY\u0016\f\u0001\u0002\u001d:j]R,%O\u001d\u000b\u00041\u0006m\u0002BBA\u001f1\u0001\u0007\u0001/A\u0002ng\u001e\u0004")
public class HeadlessFrontEnd
extends RecorderFrontEnd {
    private final RecorderConfiguration configuration;
    private boolean hasRun;

    private boolean hasRun() {
        return this.hasRun;
    }

    private void hasRun_$eq(boolean x$1) {
        this.hasRun = x$1;
    }

    @Override
    public RecorderMode selectedRecorderMode() {
        return this.configuration.core().mode();
    }

    @Override
    public void receiveEvent(FrontEndEvent event) {
        Predef$.MODULE$.println((Object)("[Event] " + event));
    }

    @Override
    public void init() {
        if (!this.hasRun()) {
            this.hasRun_$eq(true);
            Predef$.MODULE$.println((Object)"Starting Recorder in headless mode");
            RecorderMode recorderMode = this.selectedRecorderMode();
            RecorderMode$Proxy$ recorderMode$Proxy$ = RecorderMode$Proxy$.MODULE$;
            if (!(recorderMode != null ? !recorderMode.equals(recorderMode$Proxy$) : recorderMode$Proxy$ != null) && HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile().exists()) {
                this.printErr("Recorder lock file found at " + HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile() + ".");
                this.printErr("Make sure that there is no other recording in progress.");
                System.out.flush();
                throw package$.MODULE$.exit(1);
            }
            this.startRecording();
            return;
        }
        package$.MODULE$.runtime().halt(0);
    }

    @Override
    public void handleHarExportFailure(String message) {
        this.printErr("Could not convert HAR file: " + message);
    }

    @Override
    public Path harFilePath() {
        return (Path)this.configuration.core().harFilePath().getOrElse((Function0 & Serializable)() -> Path.of("", new String[0]));
    }

    @Override
    public void handleHarExportSuccess() {
        Predef$.MODULE$.println((Object)"HAR file successfully converted.");
    }

    @Override
    public void recordingStarted() {
        this.createLockFile();
        Predef$.MODULE$.println((Object)("Recording started, proxy port is " + this.configuration.proxy().port()));
        Predef$.MODULE$.println((Object)"To stop the Recorder and generate the Simulation, kill the Recorder process with: ");
        Predef$.MODULE$.println((Object)"- CTRL-C");
        Predef$.MODULE$.println((Object)("- Use the Recorder's PID, written to " + HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()));
        package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> this.stopRecording(true));
    }

    @Override
    public void handleFilterValidationFailures(Seq<String> failures) {
    }

    @Override
    public boolean askSimulationOverwrite() {
        this.printErr("Another simulation with the same name exists.");
        return false;
    }

    @Override
    public void recordingStopped() {
        HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile().delete();
        Predef$.MODULE$.println((Object)"New Gatling simulation created.");
    }

    @Override
    public void handleMissingHarFile(Path path) {
        Object errorMessage = ((Object)path).toString().isEmpty() ? "The HAR file to convert was not specified, either through recorder.conf or through CLI options." : "Could not find the HAR file (path: " + path + ")";
        this.printErr((String)errorMessage);
    }

    private void createLockFile() {
        String pid = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ManagementFactory.getRuntimeMXBean().getName().split("@")));
        Using$.MODULE$.resource((Object)new PrintStream(HeadlessFrontEnd$.MODULE$.io$gatling$recorder$ui$headless$HeadlessFrontEnd$$RecorderPidFile()), (Function1 & Serializable)x$1 -> {
            x$1.println(pid);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private void printErr(String msg) {
        Console$.MODULE$.err().println(msg);
    }

    public HeadlessFrontEnd(RecorderController controller, RecorderConfiguration configuration) {
        this.configuration = configuration;
        super(controller);
        this.hasRun = false;
    }
}

