/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class PhantomJsDriverManager
extends BrowserManager {
    private static PhantomJsDriverManager instance;

    protected PhantomJsDriverManager() {
    }

    public static synchronized PhantomJsDriverManager getInstance() {
        if (instance == null) {
            instance = new PhantomJsDriverManager();
        }
        return instance;
    }

    @Override
    public List<URL> getDrivers() throws Exception {
        String phantomjsDriverUrl = WdmConfig.getString("wdm.phantomjsDriverUrl");
        log.debug("Reading {} to find out the latest version of PhantomJS driver", (Object)phantomjsDriverUrl);
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
        Logger.getLogger("com.gargoylesoftware.htmlunit").setLevel(Level.OFF);
        Logger.getLogger("org.apache.commons.httpclient").setLevel(Level.OFF);
        HtmlUnitDriver driver = new HtmlUnitDriver();
        driver.manage().timeouts().implicitlyWait((long)WdmConfig.getInt("wdm.timeout"), TimeUnit.SECONDS);
        driver.get(phantomjsDriverUrl);
        WebElement downloadsTable = driver.findElement(By.id((String)"available-downloads"));
        List links = downloadsTable.findElements(By.xpath((String)"//table[@id='uploaded-files']/tbody/tr[@class='iterable-item']/td[@class='name']/a"));
        ArrayList<URL> urlList = new ArrayList<URL>(links.size());
        for (WebElement element : links) {
            String href = element.getAttribute("href");
            urlList.add(new URL(href));
        }
        return urlList;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.phantomjsDriverExport");
    }

    @Override
    protected String getDriverVersion() {
        return WdmConfig.getString("wdm.phantomjsDriverVersion");
    }

    @Override
    protected URL getDriverUrl() throws MalformedURLException {
        return WdmConfig.getUrl("wdm.phantomjsDriverUrl");
    }

    @Override
    protected String getDriverName() {
        return "phantomjs";
    }
}

