/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdmHttpClient
implements Closeable {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CloseableHttpClient httpClient;

    private WdmHttpClient(String proxyUrl, String proxyUser, String proxyPass) {
        HttpHost proxyHost = this.createProxyHttpHost(proxyUrl);
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManagerShared(true);
        if (proxyHost != null) {
            builder.setProxy(proxyHost);
            BasicCredentialsProvider credentialsProvider = this.createBasicCredentialsProvider(proxyUrl, proxyUser, proxyPass, proxyHost);
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        try {
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, allHostsValid);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            builder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        this.httpClient = builder.useSystemProperties().build();
    }

    public Proxy createProxy(String proxyUrl) {
        URL url = this.determineProxyUrl(proxyUrl);
        if (url == null) {
            return null;
        }
        String proxyHost = url.getHost();
        int proxyPort = url.getPort() == -1 ? 80 : url.getPort();
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }

    public Response execute(Method method) throws IOException {
        CloseableHttpResponse response = this.httpClient.execute(method.toHttpUriRequest());
        if (response.getStatusLine().getStatusCode() >= 400) {
            String errorMessage = "A response error is detected: " + response.getStatusLine();
            this.log.error(errorMessage);
            throw new WebDriverManagerException(errorMessage);
        }
        return new Response((HttpResponse)response);
    }

    public boolean isValid(URL url) throws IOException {
        CloseableHttpResponse response = this.httpClient.execute(new Options(url).toHttpUriRequest());
        if (response.getStatusLine().getStatusCode() > 401) {
            this.log.debug("A response error is detected. {}", (Object)response.getStatusLine());
            return false;
        }
        return true;
    }

    private URL determineProxyUrl(String proxy) {
        String proxyInput;
        String string = proxyInput = WdmConfig.isNullOrEmpty(proxy) ? System.getenv("HTTPS_PROXY") : proxy;
        if (WdmConfig.isNullOrEmpty(proxyInput)) {
            return null;
        }
        try {
            return new URL(proxyInput.matches("^http[s]?://.*$") ? proxyInput : "http://" + proxyInput);
        }
        catch (MalformedURLException e) {
            this.log.error("Invalid proxy url {}", (Object)proxyInput, (Object)e);
            return null;
        }
    }

    private final HttpHost createProxyHttpHost(String proxyUrl) {
        Proxy proxy = this.createProxy(proxyUrl);
        if (proxy == null || proxy.address() == null) {
            return null;
        }
        if (!(proxy.address() instanceof InetSocketAddress)) {
            String errorMessage = "Detect an unsupported subclass of SocketAddress. Please use the InetSocketAddress or subclass. Actual:" + proxy.address().getClass();
            this.log.error(errorMessage);
            throw new WebDriverManagerException(errorMessage);
        }
        InetSocketAddress proxyAddress = (InetSocketAddress)proxy.address();
        return new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort());
    }

    private final BasicCredentialsProvider createBasicCredentialsProvider(String proxy, String proxyUser, String proxyPass, HttpHost proxyHost) {
        URL proxyUrl = this.determineProxyUrl(proxy);
        if (proxyUrl == null) {
            return null;
        }
        try {
            String username = null;
            String password = null;
            String userInfo = proxyUrl.getUserInfo();
            if (userInfo != null) {
                StringTokenizer st = new StringTokenizer(userInfo, ":");
                username = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
                password = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
            }
            String envProxyUser = System.getenv("HTTPS_PROXY_USER");
            String envProxyPass = System.getenv("HTTPS_PROXY_PASS");
            username = envProxyUser != null ? envProxyUser : username;
            password = envProxyPass != null ? envProxyPass : password;
            username = proxyUser != null ? proxyUser : username;
            String string = password = proxyPass != null ? proxyPass : password;
            if (username == null) {
                return null;
            }
            String ntlmUsername = username;
            String ntlmDomain = null;
            int index = username.indexOf(92);
            if (index > 0) {
                ntlmDomain = username.substring(0, index);
                ntlmUsername = username.substring(index + 1);
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            AuthScope authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort(), AuthScope.ANY_REALM, "NTLM");
            NTCredentials creds = new NTCredentials(ntlmUsername, password, this.getWorkstation(), ntlmDomain);
            credentialsProvider.setCredentials(authScope, (Credentials)creds);
            authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort());
            creds = new UsernamePasswordCredentials(username, password);
            credentialsProvider.setCredentials(authScope, (Credentials)creds);
            return credentialsProvider;
        }
        catch (UnsupportedEncodingException e) {
            throw new WebDriverManagerException(e);
        }
    }

    private String getWorkstation() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public static final class Response {
        private final HttpResponse httpResponse;

        public Response(HttpResponse response) {
            this.httpResponse = response;
        }

        public InputStream getContent() throws IOException {
            return this.httpResponse.getEntity().getContent();
        }
    }

    public static final class Options
    implements Method {
        private final HttpOptions httpOptions;

        public Options(URL url) {
            this.httpOptions = new HttpOptions(url.toString());
        }

        @Override
        public HttpUriRequest toHttpUriRequest() {
            return this.httpOptions;
        }
    }

    public static final class Get
    implements Method {
        private final HttpGet httpGet;
        private final RequestConfig requestConfig;

        public Get(URL url) {
            this.httpGet = new HttpGet(url.toString());
            this.requestConfig = null;
        }

        public Get(String url, int socketTimeout) {
            this.httpGet = new HttpGet(url);
            this.requestConfig = RequestConfig.custom().setSocketTimeout(socketTimeout).build();
        }

        public Get addHeader(String name, String value) {
            this.httpGet.addHeader(name, value);
            return this;
        }

        @Override
        public HttpUriRequest toHttpUriRequest() {
            if (this.requestConfig != null) {
                this.httpGet.setConfig(this.requestConfig);
            }
            return this.httpGet;
        }
    }

    private static interface Method {
        public HttpUriRequest toHttpUriRequest();
    }

    public static class Builder {
        private String proxy;
        private String proxyUser;
        private String proxyPass;

        public Builder proxy(String proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder proxyUser(String proxyUser) {
            this.proxyUser = proxyUser;
            return this;
        }

        public Builder proxyPass(String proxyPass) {
            this.proxyPass = proxyPass;
            return this;
        }

        public WdmHttpClient build() {
            return new WdmHttpClient(this.proxy, this.proxyUser, this.proxyPass);
        }
    }
}

