/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.online;

import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.online.HttpClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.rauschig.jarchivelib.ArchiveFormat;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import org.rauschig.jarchivelib.CompressionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Downloader {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    HttpClient httpClient;
    Config config;
    UnaryOperator<File> postDownloadFunction;

    public Downloader(HttpClient httpClient, Config config, UnaryOperator<File> postDownloadFunction) {
        this.httpClient = httpClient;
        this.config = config;
        this.postDownloadFunction = postDownloadFunction;
    }

    public synchronized String download(URL url, String driverVersion, String driverName, DriverManagerType driverManagerType) throws IOException {
        File targetFile = this.getTarget(driverVersion, driverName, driverManagerType, url);
        Optional<File> driver = this.checkDriver(driverName, targetFile);
        if (!driver.isPresent()) {
            driver = this.downloadAndExtract(url, targetFile);
        }
        return driver.get().toString();
    }

    public File getTarget(String driverVersion, String driverName, DriverManagerType driverManagerType, URL url) {
        String zip = url.getFile().substring(url.getFile().lastIndexOf(47));
        String cachePath = this.config.getCachePath();
        String os = this.config.getOs().toLowerCase(Locale.ROOT);
        String architecture = this.config.getArchitecture().toString();
        if (os.equals("win") && (driverManagerType == DriverManagerType.CHROME || driverManagerType == DriverManagerType.CHROMIUM)) {
            this.log.trace("{} in Windows is only available for 32 bits architecture", (Object)driverName);
            architecture = "32";
        }
        String target = this.config.isAvoidOutputTree() ? cachePath + zip : cachePath + File.separator + driverName + File.separator + os + architecture + File.separator + driverVersion + zip;
        this.log.trace("Target file for URL {} driver version {} = {}", new Object[]{url, driverVersion, target});
        return new File(target);
    }

    public String getCachePath() {
        return this.config.getCachePath();
    }

    private Optional<File> downloadAndExtract(URL url, File targetFile) throws IOException {
        this.log.info("Downloading {}", (Object)url);
        File targetFolder = targetFile.getParentFile();
        File tempDir = Files.createTempDirectory("", new FileAttribute[0]).toFile();
        File temporaryFile = new File(tempDir, targetFile.getName());
        this.log.trace("Target folder {} ... using temporal file {}", (Object)targetFolder, (Object)temporaryFile);
        FileUtils.copyInputStreamToFile((InputStream)this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(url)).getEntity().getContent(), (File)temporaryFile);
        File extractedFile = this.extract(temporaryFile);
        File resultingDriver = new File(targetFolder, extractedFile.getName());
        boolean driverExists = resultingDriver.exists();
        if (!driverExists || this.config.isForceDownload()) {
            if (driverExists) {
                this.log.debug("Overriding former driver {}", (Object)resultingDriver);
                this.deleteFile(resultingDriver);
            }
            FileUtils.moveFileToDirectory((File)extractedFile, (File)targetFolder, (boolean)true);
        }
        if (!this.config.isExecutable(resultingDriver)) {
            this.setFileExecutable(resultingDriver);
        }
        this.deleteFolder(tempDir);
        this.log.trace("Driver after extraction {}", (Object)resultingDriver);
        return Optional.of(resultingDriver);
    }

    private Optional<File> checkDriver(String driverName, File targetFile) {
        File parentFolder = targetFile.getParentFile();
        if (parentFolder.exists() && !this.config.isForceDownload()) {
            Collection listFiles = FileUtils.listFiles((File)parentFolder, null, (boolean)true);
            for (File file : listFiles) {
                if (!file.getName().startsWith(driverName) || !this.config.isExecutable(file)) continue;
                this.log.trace("Using {} previously downloaded", (Object)driverName);
                return Optional.of(file);
            }
            this.log.trace("{} does not exist in cache", (Object)driverName);
        }
        return Optional.empty();
    }

    private File extract(File compressedFile) throws IOException {
        boolean extractFile;
        String fileName = compressedFile.getName().toLowerCase(Locale.ROOT);
        boolean bl = extractFile = !fileName.endsWith("exe") && !fileName.endsWith("jar");
        if (extractFile) {
            this.log.info("Extracting driver from compressed file {}", (Object)fileName);
        }
        if (fileName.endsWith("tar.bz2")) {
            this.unBZip2(compressedFile);
        } else if (fileName.endsWith("tar.gz")) {
            this.unTarGz(compressedFile);
        } else if (fileName.endsWith("gz")) {
            this.unGzip(compressedFile);
        } else if (fileName.endsWith("zip")) {
            this.unZip(compressedFile);
        }
        if (extractFile) {
            this.deleteFile(compressedFile);
        }
        File result = ((File)this.postDownloadFunction.apply(compressedFile)).getAbsoluteFile();
        this.log.trace("Resulting driver {}", (Object)result);
        return result;
    }

    private void unZip(File compressedFile) throws IOException {
        File file = null;
        try (ZipFile zipFolder = new ZipFile(compressedFile);){
            Enumeration<? extends ZipEntry> enu = zipFolder.entries();
            while (enu.hasMoreElements()) {
                ZipEntry zipEntry = enu.nextElement();
                String name = zipEntry.getName();
                long size = zipEntry.getSize();
                long compressedSize = zipEntry.getCompressedSize();
                this.log.trace("Unzipping {} (size: {} KB, compressed size: {} KB)", new Object[]{name, size, compressedSize});
                file = new File(compressedFile.getParentFile(), name);
                if (!file.exists() || this.config.isForceDownload()) {
                    if (name.endsWith("/")) {
                        file.mkdirs();
                        continue;
                    }
                    File parent = file.getParentFile();
                    if (parent != null) {
                        parent.mkdirs();
                    }
                    try (InputStream is = zipFolder.getInputStream(zipEntry);){
                        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                    }
                    this.setFileExecutable(file);
                    continue;
                }
                this.log.debug("{} already exists", (Object)file);
            }
        }
    }

    private void unGzip(File archive) throws IOException {
        int iDot;
        this.log.trace("UnGzip {}", (Object)archive);
        String fileName = archive.getName();
        int iDash = fileName.indexOf(45);
        if (iDash != -1) {
            fileName = fileName.substring(0, iDash);
        }
        if ((iDot = fileName.indexOf(46)) != -1) {
            fileName = fileName.substring(0, iDot);
        }
        File target = new File(archive.getParentFile(), fileName);
        try (GZIPInputStream in = new GZIPInputStream(new FileInputStream(archive));
             FileOutputStream out = new FileOutputStream(target);){
            int c = in.read();
            while (c != -1) {
                out.write(c);
                c = in.read();
            }
        }
        if (!target.getName().toLowerCase(Locale.ROOT).contains(".exe") && target.exists()) {
            this.setFileExecutable(target);
        }
    }

    private void unTarGz(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.GZIP);
        archiver.extract(archive, archive.getParentFile());
        this.log.trace("unTarGz {}", (Object)archive);
    }

    private void unBZip2(File archive) throws IOException {
        Archiver archiver = ArchiverFactory.createArchiver((ArchiveFormat)ArchiveFormat.TAR, (CompressionType)CompressionType.BZIP2);
        archiver.extract(archive, archive.getParentFile());
        this.log.trace("Unbzip2 {}", (Object)archive);
    }

    protected void setFileExecutable(File file) {
        if (!file.setExecutable(true)) {
            this.log.warn("Error setting file {} as executable", (Object)file);
        }
    }

    public void renameFile(File from, File to) {
        this.log.trace("Renaming file from {} to {}", (Object)from, (Object)to);
        if (to.exists()) {
            this.deleteFile(to);
        }
        if (!from.renameTo(to)) {
            this.log.warn("Error renaming file from {} to {}", (Object)from, (Object)to);
        }
    }

    protected void deleteFile(File file) {
        this.log.trace("Deleting file {}", (Object)file);
        try {
            Files.delete(file.toPath());
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    public void deleteFolder(File folder) {
        if (folder.isDirectory()) {
            this.log.trace("Deleting folder {}", (Object)folder);
            try {
                FileUtils.deleteDirectory((File)folder);
            }
            catch (IOException e) {
                throw new WebDriverManagerException(e);
            }
        } else {
            this.log.trace("{} cannot be deleted since it is not a directory", (Object)folder);
        }
    }
}

