/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.docker;

import io.github.bonigarcia.wdm.config.Config;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DockerHost {
    private static final String DEFAULT_UNIX_ENDPOINT = "unix:///var/run/docker.sock";
    private static final String DEFAULT_WINDOWS_ENDPOINT = "npipe:////./pipe/docker_engine";
    private static final String DEFAULT_ADDRESS = "localhost";
    private static final int DEFAULT_PORT = 2375;
    private String host;
    private URI uri;
    private URI bindUri;
    private String address;
    private int port;
    private String certPath;
    private String endpoint;

    private DockerHost(String endpoint, String certPath) {
        if (endpoint.startsWith("unix://")) {
            this.port = 0;
            this.address = DEFAULT_ADDRESS;
            this.host = endpoint;
            this.uri = URI.create(endpoint);
            this.bindUri = URI.create(endpoint);
        } else {
            String stripped = endpoint.replaceAll(".*://", "");
            Pattern hostPattern = Pattern.compile("^\\s*(.*?):(\\d+)\\s*$");
            Matcher hostMatcher = hostPattern.matcher(stripped);
            String scheme = Config.isNullOrEmpty(certPath) ? "http" : "https";
            this.address = hostMatcher.matches() ? hostMatcher.group(1) : DEFAULT_ADDRESS;
            this.port = hostMatcher.matches() ? Integer.parseInt(hostMatcher.group(2)) : DockerHost.defaultPort();
            this.host = this.address + ":" + this.port;
            this.uri = URI.create(scheme + "://" + this.address + ":" + this.port);
            this.bindUri = URI.create("tcp://" + this.address + ":" + this.port);
        }
        this.endpoint = endpoint;
        this.certPath = certPath;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public String host() {
        return this.host;
    }

    public URI uri() {
        return this.uri;
    }

    public URI bindUri() {
        return this.bindUri;
    }

    public int port() {
        return this.port;
    }

    public String address() {
        return this.address;
    }

    public String dockerCertPath() {
        return this.certPath;
    }

    public static DockerHost fromEnv() {
        String host = DockerHost.endpointFromEnv();
        String certPath = DockerHost.certPathFromEnv();
        return new DockerHost(host, certPath);
    }

    public static DockerHost from(String endpoint, String certPath) {
        return new DockerHost(endpoint, certPath);
    }

    public static String defaultDockerEndpoint() {
        String osName = System.getProperty("os.name");
        String os = osName.toLowerCase(Locale.ROOT);
        if (os.equalsIgnoreCase("linux") || os.contains("mac")) {
            return DockerHost.defaultUnixEndpoint();
        }
        if (os.contains("windows")) {
            return DockerHost.defaultWindowsEndpoint();
        }
        return "http://" + DockerHost.defaultAddress() + ":" + DockerHost.defaultPort();
    }

    public static String endpointFromEnv() {
        String dockerHost = System.getenv("DOCKER_HOST");
        if (dockerHost == null) {
            dockerHost = DockerHost.defaultDockerEndpoint();
        }
        return dockerHost;
    }

    public static String defaultUnixEndpoint() {
        return DEFAULT_UNIX_ENDPOINT;
    }

    public static String defaultWindowsEndpoint() {
        return DEFAULT_WINDOWS_ENDPOINT;
    }

    public static String defaultAddress() {
        return DEFAULT_ADDRESS;
    }

    public static int defaultPort() {
        return 2375;
    }

    public static int portFromEnv() {
        String port = System.getenv("DOCKER_PORT");
        if (port == null) {
            return DockerHost.defaultPort();
        }
        try {
            return Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            return DockerHost.defaultPort();
        }
    }

    public static String defaultCertPath() {
        String userHome = System.getProperty("user.home");
        return Paths.get(userHome, ".docker").toString();
    }

    public static String certPathFromEnv() {
        return System.getenv("DOCKER_CERT_PATH");
    }

    public static String configPathFromEnv() {
        return System.getenv("DOCKER_CONFIG");
    }
}

