/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.managers;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.online.LastGoodVersions;
import io.github.bonigarcia.wdm.online.Parser;
import io.github.bonigarcia.wdm.versions.VersionDetector;
import io.github.bonigarcia.wdm.webdriver.OptionsWithArguments;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromeDriverManager
extends WebDriverManager {
    public static final int MIN_CHROMEDRIVER_IN_CFT = 115;

    @Override
    public DriverManagerType getDriverManagerType() {
        return DriverManagerType.CHROME;
    }

    @Override
    protected String getDriverName() {
        return "chromedriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getChromeDriverVersion();
    }

    @Override
    protected String getBrowserVersion() {
        return this.config().getChromeVersion();
    }

    @Override
    protected void setDriverVersion(String driverVersion) {
        this.config().setChromeDriverVersion(driverVersion);
    }

    @Override
    protected void setBrowserVersion(String browserVersion) {
        this.config().setChromeVersion(browserVersion);
    }

    @Override
    protected URL getDriverUrl() {
        return this.getDriverUrlCkeckingMirror(this.config().getChromeDriverUrl());
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.of(this.config().getChromeDriverMirrorUrl());
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getChromeDriverExport());
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setChromeDriverUrl(url);
    }

    @Override
    protected List<URL> getDriverUrls(String driverVersion) throws IOException {
        if (this.isUseMirror()) {
            return this.getDriversFromMirror(this.getMirrorUrl().get(), driverVersion);
        }
        if (!Config.isNullOrEmpty(driverVersion) && Integer.parseInt(VersionDetector.getMajorVersion(driverVersion)) >= 115) {
            String cftUrl = this.config.getChromeLastGoodVersionsUrl();
            LastGoodVersions versions = Parser.parseJson(this.httpClient, cftUrl, LastGoodVersions.class);
            return versions.channels.stable.downloads.chromedriver.stream().map(platformUrl -> {
                try {
                    return new URL(platformUrl.url);
                }
                catch (MalformedURLException e) {
                    throw new WebDriverException("Incorrect CfT URL " + platformUrl.url);
                }
            }).collect(Collectors.toList());
        }
        return this.getDriversFromXml(this.getDriverUrl(), "//s3:Contents/s3:Key", this.getS3NamespaceContext());
    }

    @Override
    protected Optional<String> getLatestDriverVersionFromRepository() {
        if (this.config().isUseBetaVersions() || this.config().isAvoidReadReleaseFromRepository()) {
            return Optional.empty();
        }
        return this.getDriverVersionFromRepository(Optional.empty());
    }

    @Override
    protected Charset getVersionCharset() {
        return StandardCharsets.UTF_8;
    }

    @Override
    protected NamespaceContext getNamespaceContext() {
        return S3_NAMESPACE_CONTEXT;
    }

    @Override
    protected Optional<URL> buildUrl(String driverVersion) {
        return this.buildUrl(driverVersion, this.config());
    }

    Optional<URL> buildUrl(String driverVersion, Config config) {
        Optional<URL> optionalUrl = Optional.empty();
        if (!config.isUseMirror()) {
            String archLabel;
            String downloadUrlPattern = config.getChromeDownloadUrlPattern();
            OperatingSystem os = config.getOperatingSystem();
            Architecture arch = config.getArchitecture();
            String string = archLabel = os.isLinux() ? "64" : arch.toString().toLowerCase(Locale.ROOT);
            if (os.isWin() && !Architecture.X32.equals((Object)arch)) {
                archLabel = "64";
            }
            if (os.isMac() && !Architecture.ARM64.equals((Object)arch)) {
                archLabel = "x64";
            }
            String separator = os.isMac() ? "-" : "";
            String label = os.getName() + separator + archLabel;
            String builtUrl = String.format(downloadUrlPattern, driverVersion, label, label);
            log.debug("Using URL built from repository pattern: {}", (Object)builtUrl);
            try {
                optionalUrl = Optional.of(new URL(builtUrl));
            }
            catch (MalformedURLException e) {
                log.warn("Error building URL from pattern {} {}", (Object)builtUrl, (Object)e.getMessage());
            }
        }
        return optionalUrl;
    }

    @Override
    protected Capabilities getCapabilities() {
        Object options = new ChromeOptions();
        try {
            this.addDefaultArgumentsForDocker((Capabilities)options);
        }
        catch (Exception e) {
            log.error("Exception adding default arguments for Docker, retyring with custom class");
            options = new OptionsWithArguments("chrome", "goog:chromeOptions");
            try {
                this.addDefaultArgumentsForDocker((Capabilities)options);
            }
            catch (Exception e1) {
                log.error("Exception getting default capabilities", (Throwable)e);
            }
        }
        return options;
    }

    @Override
    public WebDriverManager browserInDockerAndroid() {
        this.dockerEnabled = true;
        this.androidEnabled = true;
        return this;
    }

    @Override
    public WebDriverManager exportParameter(String exportParameter) {
        this.config().setChromeDriverExport(exportParameter);
        return this;
    }
}

