/*
 * Decompiled with CFR 0.152.
 */
package io.github.endreman0.javajson.nodes;

import io.github.endreman0.javajson.nodes.ArrayNode;
import io.github.endreman0.javajson.nodes.BooleanNode;
import io.github.endreman0.javajson.nodes.Field;
import io.github.endreman0.javajson.nodes.Node;
import io.github.endreman0.javajson.nodes.NumberNode;
import io.github.endreman0.javajson.nodes.ParentNode;
import io.github.endreman0.javajson.nodes.StringNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectNode
extends ParentNode
implements Iterable<Field>,
Map<String, Node> {
    private List<Field> fields = new LinkedList<Field>();

    public ObjectNode() {
    }

    public ObjectNode(Iterable<Field> fields) {
        this();
        this.putAll(fields);
    }

    public ObjectNode(Field ... fields) {
        this();
        this.putAll(fields);
    }

    @Override
    public ObjectNode put(String key, Node value) {
        boolean isSet = false;
        for (Field field : this.fields) {
            if (!field.getKey().equals(key)) continue;
            field.setValue(value);
            isSet = true;
            break;
        }
        if (!isSet) {
            this.fields.add(new Field(key, value));
        }
        value.parent = this;
        return this;
    }

    public ObjectNode put(Field field) {
        return this.put(field.getKey(), field.getValue());
    }

    public ObjectNode putAll(Field[] fields) {
        for (Field field : fields) {
            this.put(field.getKey(), field.getValue());
        }
        return this;
    }

    public ObjectNode putAll(Iterable<Field> fields) {
        for (Field field : fields) {
            this.put(field.getKey(), field.getValue());
        }
        return this;
    }

    public Node get(String key) {
        for (Field field : this.fields) {
            if (!field.getKey().equals(key)) continue;
            return field.getValue();
        }
        return null;
    }

    public ArrayNode getArray(String key) {
        Node node = this.get(key);
        if (node instanceof ArrayNode) {
            return (ArrayNode)node;
        }
        return null;
    }

    public BooleanNode getBoolean(String key) {
        Node node = this.get(key);
        if (node instanceof BooleanNode) {
            return (BooleanNode)node;
        }
        return null;
    }

    public NumberNode getNumber(String key) {
        Node node = this.get(key);
        if (node instanceof NumberNode) {
            return (NumberNode)node;
        }
        return null;
    }

    public ObjectNode getObject(String key) {
        Node node = this.get(key);
        if (node instanceof ObjectNode) {
            return (ObjectNode)node;
        }
        return null;
    }

    public StringNode getString(String key) {
        Node node = this.get(key);
        if (node instanceof StringNode) {
            return (StringNode)node;
        }
        return null;
    }

    public String keyOf(Node value) {
        for (Field field : this.fields) {
            if (!field.getValue().equals(value)) continue;
            return field.getKey();
        }
        return null;
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    public boolean contains(String key) {
        return this.get(key) != null;
    }

    @Override
    public boolean contains(Node value) {
        return this.keyOf(value) != null;
    }

    public Node remove(String key) {
        for (Field field : this.fields) {
            if (!field.getKey().equals(key)) continue;
            this.fields.remove(field);
            return field.getValue();
        }
        return null;
    }

    @Override
    public boolean remove(Node value) {
        for (Field field : this.fields) {
            if (!field.getValue().equals(value)) continue;
            this.fields.remove(field);
            return true;
        }
        return false;
    }

    @Override
    public void removeAll() {
        for (Field field : this.fields) {
            field.getValue().parent = null;
        }
        this.fields.clear();
    }

    @Override
    public Iterator<Field> iterator() {
        return this.fields.iterator();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectNode)) {
            return false;
        }
        ObjectNode node = (ObjectNode)obj;
        if (this.size() != node.size()) {
            return false;
        }
        Iterator<Field> i1 = this.iterator();
        Iterator<Field> i2 = node.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            if (i1.next().equals(i2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        boolean add = true;
        for (Map.Entry entry : this) {
            if (add = !add) {
                hashCode += entry.hashCode();
                continue;
            }
            hashCode -= entry.hashCode();
        }
        return hashCode;
    }

    @Override
    public String json() {
        return "{\r\n " + this.innerJSON().replace("\n", "\n ") + "\r\n}";
    }

    @Override
    public String innerJSON() {
        StringBuilder sb = new StringBuilder();
        Iterator<Field> i = this.iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(",\r\n");
        }
        return sb.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return value instanceof Node ? this.keyOf((Node)value) != null : false;
    }

    @Override
    public Node get(Object key) {
        return key instanceof String ? this.get((String)key) : null;
    }

    @Override
    public Node remove(Object key) {
        return key instanceof String ? this.remove((String)key) : null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Node> m) {
        for (Map.Entry<? extends String, ? extends Node> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> set = new HashSet<String>();
        for (Field field : this.fields) {
            set.add(field.getKey());
        }
        return set;
    }

    @Override
    public Collection<Node> values() {
        HashSet<Node> c = new HashSet<Node>();
        for (Field field : this.fields) {
            c.add(field.getValue());
        }
        return c;
    }

    @Override
    public Set<Map.Entry<String, Node>> entrySet() {
        HashSet<Map.Entry<String, Node>> set = new HashSet<Map.Entry<String, Node>>();
        for (Field field : this.fields) {
            set.add(field);
        }
        return set;
    }
}

