/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.unsafeaccessor;

import io.github.karlatemp.unsafeaccessor.ProtectedObject;
import java.lang.reflect.AccessibleObject;
import java.security.Permission;

public final class SecurityCheck
extends ProtectedObject {
    static final SecurityCheck INSTANCE = new SecurityCheck();
    static AccessLimiter LIMITER = AccessLimiter.NOOP;

    SecurityCheck() {
        this.trusted = true;
    }

    public static SecurityCheck getInstance() {
        return INSTANCE;
    }

    public AccessLimiter getLimiter() {
        this.checkTrusted();
        AccessLimiter LM = LIMITER;
        if (LM == AccessLimiter.NOOP) {
            return null;
        }
        return LM;
    }

    public void setLimiter(AccessLimiter value) {
        if (value == null) {
            value = AccessLimiter.NOOP;
        }
        LIMITER = value;
    }

    @Deprecated
    public Permission getPermission() {
        this.checkTrusted();
        if (LIMITER instanceof AccessLimiterSM) {
            return ((AccessLimiterSM)SecurityCheck.LIMITER).getUsf;
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Permission getPermissionOpenAccess() {
        this.checkTrusted();
        if (LIMITER instanceof AccessLimiterSM) {
            return ((AccessLimiterSM)SecurityCheck.LIMITER).open;
        }
        throw new UnsupportedOperationException();
    }

    private static AccessLimiterSM sm() {
        if (LIMITER == null) {
            LIMITER = new AccessLimiterSM();
            return LIMITER;
        }
        AccessLimiter AL = LIMITER;
        if (AL instanceof AccessLimiterSM) {
            return (AccessLimiterSM)AL;
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setPermissionOpenAccess(Permission permissionOpenAccess) {
        this.checkTrusted();
        SecurityCheck.sm().open = permissionOpenAccess;
    }

    @Deprecated
    public void setPermission(Permission permission) {
        this.checkTrusted();
        SecurityCheck.sm().getUsf = permission;
    }

    @Deprecated
    public void enableSecurityCheck() {
        this.checkTrusted();
        if (LIMITER == null) {
            AccessLimiterSM sm = new AccessLimiterSM();
            sm.getUsf = sm.open = new RuntimePermission("unsafe.getInstance");
            LIMITER = sm;
        }
    }

    public static abstract class AccessLimiter {
        static final AccessLimiter NOOP = new AccessLimiter(){

            @Override
            public void preGetUnsafe() {
            }

            @Override
            public void preGetSecurityCheck() {
            }

            @Override
            public void preGetTrustedLookup(Class<?> target) {
            }

            @Override
            public void preGetUnsafeAccess() {
            }

            @Override
            public void preOpenAccessible(AccessibleObject object) {
            }
        };

        public abstract void preGetUnsafe();

        public void preGetSecurityCheck() {
            this.preGetUnsafe();
        }

        public void preGetUnsafeAccess() {
            this.preGetUnsafe();
        }

        public void preGetTrustedLookup(Class<?> target) {
            this.preGetUnsafe();
        }

        public void preOpenAccessible(AccessibleObject object) {
            this.preGetUnsafe();
        }
    }

    private static class AccessLimiterSM
    extends AccessLimiter {
        Permission getUsf;
        Permission open;

        private AccessLimiterSM() {
        }

        @Override
        public void preGetUnsafe() {
            Permission getUsf = this.getUsf;
            SecurityManager sm = System.getSecurityManager();
            if (getUsf != null && sm != null) {
                sm.checkPermission(getUsf);
            }
        }

        @Override
        public void preOpenAccessible(AccessibleObject object) {
            Permission open = this.open;
            SecurityManager sm = System.getSecurityManager();
            if (open != null && sm != null) {
                sm.checkPermission(open);
            }
        }
    }
}

