/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.unsafeaccessor;

import io.github.karlatemp.unsafeaccessor.Root;
import io.github.karlatemp.unsafeaccessor.Unsafe;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

class MHLookup {
    private static final boolean isUsingObj = MHLookup.checkUsingObj();

    MHLookup() {
    }

    static MethodHandle lookupDirect(String name, MethodType type, boolean bind) throws NoSuchMethodException {
        MethodHandle rsp;
        Object anyx = Unsafe.getUnsafe0().getOriginalUnsafe();
        MethodHandles.Lookup lookup = Root.RootLookupHolder.trustedIn(anyx.getClass());
        try {
            rsp = lookup.findVirtual(anyx.getClass(), name, type);
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e);
        }
        return bind ? rsp.bindTo(anyx) : rsp;
    }

    private static boolean checkUsingObj() {
        Unsafe usf = Unsafe.getUnsafe0();
        if (!usf.isJava9()) {
            return true;
        }
        return usf.getClass().getName().endsWith("Obj");
    }

    static MethodHandle lookup(String name, MethodType type, Object[] bind) throws NoSuchMethodException {
        Unsafe usf = Unsafe.getUnsafe0();
        Object anyx = usf.getOriginalUnsafe();
        MethodHandles.Lookup lookup = Root.RootLookupHolder.trustedIn(anyx.getClass());
        String directName = isUsingObj ? name.replace("Reference", "Object") : name;
        Object bindx = null;
        MethodHandle rsp = null;
        try {
            try {
                rsp = lookup.findVirtual(anyx.getClass(), directName, type);
                bindx = anyx;
            }
            catch (NoSuchMethodException ignored) {
                if (!usf.isJava9()) {
                    try {
                        String nwm = directName.replace("Opaque", "Volatile").replace("Release", "Volatile").replace("Acquire", "Volatile");
                        rsp = lookup.findVirtual(anyx.getClass(), directName, type);
                        bindx = anyx;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (rsp == null) {
                    rsp = lookup.findVirtual(Unsafe.class, name, type);
                    bindx = Unsafe.getUnsafe0();
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new InternalError(e);
        }
        if (bind == null) {
            return rsp.bindTo(bindx);
        }
        bind[0] = bindx;
        return rsp;
    }
}

