/*
 * Decompiled with CFR 0.152.
 */
package io.github.karlatemp.unsafeaccessor;

import io.github.karlatemp.unsafeaccessor.Analysis;
import io.github.karlatemp.unsafeaccessor.Unsafe;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.ProtectionDomain;

class SunMiscUnsafe
extends Unsafe {
    protected final sun.misc.Unsafe theUnsafe = SunMiscUnsafe.initUnsafe();
    private static final boolean BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    SunMiscUnsafe() {
    }

    private static sun.misc.Unsafe initUnsafe() {
        try {
            Field field = sun.misc.Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (sun.misc.Unsafe)field.get(null);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    @Override
    public Object getOriginalUnsafe() {
        return this.theUnsafe;
    }

    @Override
    public long objectFieldOffset(Class<?> c, String name) {
        try {
            return this.theUnsafe.objectFieldOffset(c.getDeclaredField(name));
        }
        catch (NoSuchFieldException e) {
            throw new InternalError(e);
        }
    }

    @Override
    public Object getReference(Object o, long offset) {
        return this.theUnsafe.getObject(o, offset);
    }

    @Override
    public Object getReferenceAcquire(Object o, long offset) {
        return this.theUnsafe.getObjectVolatile(o, offset);
    }

    @Override
    public boolean getBooleanAcquire(Object o, long offset) {
        return this.theUnsafe.getBooleanVolatile(o, offset);
    }

    @Override
    public byte getByteAcquire(Object o, long offset) {
        return this.theUnsafe.getByteVolatile(o, offset);
    }

    @Override
    public short getShortAcquire(Object o, long offset) {
        return this.theUnsafe.getShortVolatile(o, offset);
    }

    @Override
    public char getCharAcquire(Object o, long offset) {
        return this.theUnsafe.getCharVolatile(o, offset);
    }

    @Override
    public int getIntAcquire(Object o, long offset) {
        return this.theUnsafe.getIntVolatile(o, offset);
    }

    @Override
    public float getFloatAcquire(Object o, long offset) {
        return this.theUnsafe.getFloatVolatile(o, offset);
    }

    @Override
    public long getLongAcquire(Object o, long offset) {
        return this.theUnsafe.getLongVolatile(o, offset);
    }

    @Override
    public double getDoubleAcquire(Object o, long offset) {
        return this.theUnsafe.getDoubleVolatile(o, offset);
    }

    @Override
    public Object getReferenceOpaque(Object o, long offset) {
        return this.theUnsafe.getObjectVolatile(o, offset);
    }

    @Override
    public boolean getBooleanOpaque(Object o, long offset) {
        return this.theUnsafe.getBooleanVolatile(o, offset);
    }

    @Override
    public byte getByteOpaque(Object o, long offset) {
        return this.theUnsafe.getByteVolatile(o, offset);
    }

    @Override
    public short getShortOpaque(Object o, long offset) {
        return this.theUnsafe.getShortVolatile(o, offset);
    }

    @Override
    public char getCharOpaque(Object o, long offset) {
        return this.theUnsafe.getCharVolatile(o, offset);
    }

    @Override
    public int getIntOpaque(Object o, long offset) {
        return this.theUnsafe.getIntVolatile(o, offset);
    }

    @Override
    public float getFloatOpaque(Object o, long offset) {
        return this.theUnsafe.getFloatVolatile(o, offset);
    }

    @Override
    public long getLongOpaque(Object o, long offset) {
        return this.theUnsafe.getLongVolatile(o, offset);
    }

    @Override
    public double getDoubleOpaque(Object o, long offset) {
        return this.theUnsafe.getDoubleVolatile(o, offset);
    }

    @Override
    public void putReference(Object o, long offset, Object x) {
        this.theUnsafe.putObject(o, offset, x);
    }

    @Override
    public void putReferenceOpaque(Object o, long offset, Object x) {
        this.theUnsafe.putObjectVolatile(o, offset, x);
    }

    @Override
    public void putBooleanOpaque(Object o, long offset, boolean x) {
        this.theUnsafe.putBooleanVolatile(o, offset, x);
    }

    @Override
    public void putByteOpaque(Object o, long offset, byte x) {
        this.theUnsafe.putByteVolatile(o, offset, x);
    }

    @Override
    public void putShortOpaque(Object o, long offset, short x) {
        this.theUnsafe.putShortVolatile(o, offset, x);
    }

    @Override
    public void putCharOpaque(Object o, long offset, char x) {
        this.theUnsafe.putCharVolatile(o, offset, x);
    }

    @Override
    public void putIntOpaque(Object o, long offset, int x) {
        this.theUnsafe.putIntVolatile(o, offset, x);
    }

    @Override
    public void putFloatOpaque(Object o, long offset, float x) {
        this.theUnsafe.putFloatVolatile(o, offset, x);
    }

    @Override
    public void putLongOpaque(Object o, long offset, long x) {
        this.theUnsafe.putLongVolatile(o, offset, x);
    }

    @Override
    public void putDoubleOpaque(Object o, long offset, double x) {
        this.theUnsafe.putDoubleVolatile(o, offset, x);
    }

    @Override
    public void putReferenceRelease(Object o, long offset, Object x) {
        this.theUnsafe.putObjectVolatile(o, offset, x);
    }

    @Override
    public void putBooleanRelease(Object o, long offset, boolean x) {
        this.theUnsafe.putBooleanVolatile(o, offset, x);
    }

    @Override
    public void putByteRelease(Object o, long offset, byte x) {
        this.theUnsafe.putByteVolatile(o, offset, x);
    }

    @Override
    public void putShortRelease(Object o, long offset, short x) {
        this.theUnsafe.putShortVolatile(o, offset, x);
    }

    @Override
    public void putCharRelease(Object o, long offset, char x) {
        this.theUnsafe.putCharVolatile(o, offset, x);
    }

    @Override
    public void putIntRelease(Object o, long offset, int x) {
        this.theUnsafe.putIntVolatile(o, offset, x);
    }

    @Override
    public void putFloatRelease(Object o, long offset, float x) {
        this.theUnsafe.putFloatVolatile(o, offset, x);
    }

    @Override
    public void putLongRelease(Object o, long offset, long x) {
        this.theUnsafe.putLongVolatile(o, offset, x);
    }

    @Override
    public void putDoubleRelease(Object o, long offset, double x) {
        this.theUnsafe.putDoubleVolatile(o, offset, x);
    }

    @Override
    public void putReferenceVolatile(Object o, long offset, Object x) {
        this.theUnsafe.putObjectVolatile(o, offset, x);
    }

    @Override
    public int getInt(Object o, long offset) {
        return this.theUnsafe.getInt(o, offset);
    }

    @Override
    public void putInt(Object o, long offset, int x) {
        this.theUnsafe.putInt(o, offset, x);
    }

    @Override
    public Object getObject(Object o, long offset) {
        return this.theUnsafe.getObject(o, offset);
    }

    @Override
    public void putObject(Object o, long offset, Object x) {
        this.theUnsafe.putObject(o, offset, x);
    }

    @Override
    public boolean getBoolean(Object o, long offset) {
        return this.theUnsafe.getBoolean(o, offset);
    }

    @Override
    public void putBoolean(Object o, long offset, boolean x) {
        this.theUnsafe.putBoolean(o, offset, x);
    }

    @Override
    public byte getByte(Object o, long offset) {
        return this.theUnsafe.getByte(o, offset);
    }

    @Override
    public void putByte(Object o, long offset, byte x) {
        this.theUnsafe.putByte(o, offset, x);
    }

    @Override
    public short getShort(Object o, long offset) {
        return this.theUnsafe.getShort(o, offset);
    }

    @Override
    public void putShort(Object o, long offset, short x) {
        this.theUnsafe.putShort(o, offset, x);
    }

    @Override
    public char getChar(Object o, long offset) {
        return this.theUnsafe.getChar(o, offset);
    }

    @Override
    public void putChar(Object o, long offset, char x) {
        this.theUnsafe.putChar(o, offset, x);
    }

    @Override
    public long getLong(Object o, long offset) {
        return this.theUnsafe.getLong(o, offset);
    }

    @Override
    public void putLong(Object o, long offset, long x) {
        this.theUnsafe.putLong(o, offset, x);
    }

    @Override
    public float getFloat(Object o, long offset) {
        return this.theUnsafe.getFloat(o, offset);
    }

    @Override
    public void putFloat(Object o, long offset, float x) {
        this.theUnsafe.putFloat(o, offset, x);
    }

    @Override
    public double getDouble(Object o, long offset) {
        return this.theUnsafe.getDouble(o, offset);
    }

    @Override
    public void putDouble(Object o, long offset, double x) {
        this.theUnsafe.putDouble(o, offset, x);
    }

    @Override
    public Object getUncompressedObject(long address) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(long address) {
        return this.theUnsafe.getByte(address);
    }

    @Override
    public void putByte(long address, byte x) {
        this.theUnsafe.putByte(address, x);
    }

    @Override
    public short getShort(long address) {
        return this.theUnsafe.getShort(address);
    }

    @Override
    public void putShort(long address, short x) {
        this.theUnsafe.putShort(address, x);
    }

    @Override
    public char getChar(long address) {
        return this.theUnsafe.getChar(address);
    }

    @Override
    public void putChar(long address, char x) {
        this.theUnsafe.putChar(address, x);
    }

    @Override
    public int getInt(long address) {
        return this.theUnsafe.getInt(address);
    }

    @Override
    public void putInt(long address, int x) {
        this.theUnsafe.putInt(address, x);
    }

    @Override
    public long getLong(long address) {
        return this.theUnsafe.getLong(address);
    }

    @Override
    public void putLong(long address, long x) {
        this.theUnsafe.putLong(address, x);
    }

    @Override
    public float getFloat(long address) {
        return this.theUnsafe.getFloat(address);
    }

    @Override
    public void putFloat(long address, float x) {
        this.theUnsafe.putFloat(address, x);
    }

    @Override
    public double getDouble(long address) {
        return this.theUnsafe.getDouble(address);
    }

    @Override
    public void putDouble(long address, double x) {
        this.theUnsafe.putDouble(address, x);
    }

    @Override
    public long getAddress(long address) {
        return this.theUnsafe.getAddress(address);
    }

    @Override
    public void putAddress(long address, long x) {
        this.theUnsafe.putAddress(address, x);
    }

    @Override
    public long allocateMemory(long bytes) {
        return this.theUnsafe.allocateMemory(bytes);
    }

    @Override
    public long reallocateMemory(long address, long bytes) {
        return this.theUnsafe.reallocateMemory(address, bytes);
    }

    @Override
    public void setMemory(Object o, long offset, long bytes, byte value) {
        this.theUnsafe.setMemory(o, offset, bytes, value);
    }

    @Override
    public void setMemory(long address, long bytes, byte value) {
        this.theUnsafe.setMemory(address, bytes, value);
    }

    @Override
    public void copyMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes) {
        this.theUnsafe.copyMemory(srcBase, srcOffset, destBase, destOffset, bytes);
    }

    @Override
    public void copyMemory(long srcAddress, long destAddress, long bytes) {
        this.theUnsafe.copyMemory(srcAddress, destAddress, bytes);
    }

    @Override
    public void copySwapMemory(Object srcBase, long srcOffset, Object destBase, long destOffset, long bytes, long elemSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copySwapMemory(long srcAddress, long destAddress, long bytes, long elemSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void freeMemory(long address) {
        this.theUnsafe.freeMemory(address);
    }

    @Override
    public long objectFieldOffset(Field f) {
        return this.theUnsafe.objectFieldOffset(f);
    }

    @Override
    public long staticFieldOffset(Field f) {
        return this.theUnsafe.staticFieldOffset(f);
    }

    @Override
    public Object staticFieldBase(Field f) {
        return this.theUnsafe.staticFieldBase(f);
    }

    @Override
    public boolean shouldBeInitialized(Class<?> c) {
        return this.theUnsafe.shouldBeInitialized(c);
    }

    @Override
    public void ensureClassInitialized(Class<?> c) {
        this.theUnsafe.ensureClassInitialized(c);
    }

    @Override
    public int arrayBaseOffset(Class<?> arrayClass) {
        return this.theUnsafe.arrayBaseOffset(arrayClass);
    }

    @Override
    public int arrayIndexScale(Class<?> arrayClass) {
        return this.theUnsafe.arrayIndexScale(arrayClass);
    }

    @Override
    public int addressSize() {
        return this.theUnsafe.addressSize();
    }

    @Override
    public int pageSize() {
        return this.theUnsafe.pageSize();
    }

    @Override
    public Class<?> defineClass(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) {
        throw new AbstractMethodError();
    }

    @Override
    public Class<?> defineClass0(String name, byte[] b, int off, int len, ClassLoader loader, ProtectionDomain protectionDomain) {
        throw new AbstractMethodError();
    }

    @Override
    public Class<?> defineAnonymousClass(Class<?> hostClass, byte[] data, Object[] cpPatches) {
        return this.theUnsafe.defineAnonymousClass(hostClass, data, cpPatches);
    }

    @Override
    public Object allocateInstance(Class<?> cls) throws InstantiationException {
        return this.theUnsafe.allocateInstance(cls);
    }

    @Override
    public Object allocateUninitializedArray(Class<?> componentType, int length) {
        if (componentType == null) {
            throw new IllegalArgumentException("Component type is null");
        }
        if (!componentType.isPrimitive()) {
            throw new IllegalArgumentException("Component type is not primitive");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Negative length");
        }
        if (componentType == Byte.TYPE) {
            return new byte[length];
        }
        if (componentType == Boolean.TYPE) {
            return new boolean[length];
        }
        if (componentType == Short.TYPE) {
            return new short[length];
        }
        if (componentType == Character.TYPE) {
            return new char[length];
        }
        if (componentType == Integer.TYPE) {
            return new int[length];
        }
        if (componentType == Float.TYPE) {
            return new float[length];
        }
        if (componentType == Long.TYPE) {
            return new long[length];
        }
        if (componentType == Double.TYPE) {
            return new double[length];
        }
        return null;
    }

    @Override
    public void throwException(Throwable ee) {
        this.theUnsafe.throwException(ee);
    }

    @Override
    public boolean compareAndSetReference(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public Object compareAndExchangeReference(Object o, long offset, Object expected, Object x) {
        Object witness;
        do {
            if ((witness = this.theUnsafe.getObjectVolatile(o, offset)) == expected) continue;
            return witness;
        } while (!this.theUnsafe.compareAndSwapObject(o, offset, witness, x));
        return witness;
    }

    @Override
    public Object compareAndExchangeReferenceAcquire(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeReference(o, offset, expected, x);
    }

    @Override
    public Object compareAndExchangeReferenceRelease(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeReference(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetReferencePlain(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetReferenceAcquire(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetReferenceRelease(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetReference(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public boolean compareAndSetInt(Object o, long offset, int expected, int x) {
        return this.theUnsafe.compareAndSwapInt(o, offset, expected, x);
    }

    @Override
    public int compareAndExchangeInt(Object o, long offset, int expected, int x) {
        int witness;
        do {
            if ((witness = this.theUnsafe.getIntVolatile(o, offset)) == expected) continue;
            return witness;
        } while (!this.theUnsafe.compareAndSwapInt(o, offset, witness, x));
        return witness;
    }

    @Override
    public int compareAndExchangeIntAcquire(Object o, long offset, int expected, int x) {
        return this.compareAndExchangeInt(o, offset, expected, x);
    }

    @Override
    public int compareAndExchangeIntRelease(Object o, long offset, int expected, int x) {
        return this.compareAndExchangeInt(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetIntPlain(Object o, long offset, int expected, int x) {
        return this.compareAndSetInt(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetIntAcquire(Object o, long offset, int expected, int x) {
        return this.compareAndSetInt(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetIntRelease(Object o, long offset, int expected, int x) {
        return this.theUnsafe.compareAndSwapInt(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetInt(Object o, long offset, int expected, int x) {
        return this.theUnsafe.compareAndSwapInt(o, offset, expected, x);
    }

    @Override
    public byte compareAndExchangeByte(Object o, long offset, byte expected, byte x) {
        int fullWord;
        long wordOffset = offset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(offset & 3L) << 3;
        if (BIG_ENDIAN) {
            shift = 24 - shift;
        }
        int mask = 255 << shift;
        int maskedExpected = (expected & 0xFF) << shift;
        int maskedX = (x & 0xFF) << shift;
        do {
            if (((fullWord = this.getIntVolatile(o, wordOffset)) & mask) == maskedExpected) continue;
            return (byte)((fullWord & mask) >> shift);
        } while (!this.weakCompareAndSetInt(o, wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    @Override
    public boolean compareAndSetByte(Object o, long offset, byte expected, byte x) {
        return this.compareAndExchangeByte(o, offset, expected, x) == expected;
    }

    @Override
    public boolean weakCompareAndSetByte(Object o, long offset, byte expected, byte x) {
        return this.compareAndSetByte(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetByteAcquire(Object o, long offset, byte expected, byte x) {
        return this.compareAndSetByte(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetByteRelease(Object o, long offset, byte expected, byte x) {
        return this.compareAndSetByte(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetBytePlain(Object o, long offset, byte expected, byte x) {
        return this.compareAndSetByte(o, offset, expected, x);
    }

    @Override
    public byte compareAndExchangeByteAcquire(Object o, long offset, byte expected, byte x) {
        return this.compareAndExchangeByte(o, offset, expected, x);
    }

    @Override
    public byte compareAndExchangeByteRelease(Object o, long offset, byte expected, byte x) {
        return this.compareAndExchangeByte(o, offset, expected, x);
    }

    @Override
    public short compareAndExchangeShort(Object o, long offset, short expected, short x) {
        int fullWord;
        if ((offset & 3L) == 3L) {
            throw new IllegalArgumentException("Update spans the word, not supported");
        }
        long wordOffset = offset & 0xFFFFFFFFFFFFFFFCL;
        int shift = (int)(offset & 3L) << 3;
        if (BIG_ENDIAN) {
            shift = 16 - shift;
        }
        int mask = 65535 << shift;
        int maskedExpected = (expected & 0xFFFF) << shift;
        int maskedX = (x & 0xFFFF) << shift;
        do {
            if (((fullWord = this.getIntVolatile(o, wordOffset)) & mask) == maskedExpected) continue;
            return (short)((fullWord & mask) >> shift);
        } while (!this.weakCompareAndSetInt(o, wordOffset, fullWord, fullWord & ~mask | maskedX));
        return expected;
    }

    @Override
    public boolean compareAndSetShort(Object o, long offset, short expected, short x) {
        return this.compareAndExchangeShort(o, offset, expected, x) == expected;
    }

    @Override
    public boolean weakCompareAndSetShort(Object o, long offset, short expected, short x) {
        return this.compareAndSetShort(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetShortAcquire(Object o, long offset, short expected, short x) {
        return this.compareAndSetShort(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetShortRelease(Object o, long offset, short expected, short x) {
        return this.compareAndSetShort(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetShortPlain(Object o, long offset, short expected, short x) {
        return this.compareAndSetShort(o, offset, expected, x);
    }

    @Override
    public short compareAndExchangeShortAcquire(Object o, long offset, short expected, short x) {
        return this.compareAndExchangeShort(o, offset, expected, x);
    }

    @Override
    public short compareAndExchangeShortRelease(Object o, long offset, short expected, short x) {
        return this.compareAndExchangeShort(o, offset, expected, x);
    }

    @Override
    public boolean compareAndSetChar(Object o, long offset, char expected, char x) {
        return this.compareAndSetShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public char compareAndExchangeChar(Object o, long offset, char expected, char x) {
        return (char)this.compareAndExchangeShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public char compareAndExchangeCharAcquire(Object o, long offset, char expected, char x) {
        return (char)this.compareAndExchangeShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public char compareAndExchangeCharRelease(Object o, long offset, char expected, char x) {
        return (char)this.compareAndExchangeShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public boolean weakCompareAndSetChar(Object o, long offset, char expected, char x) {
        return this.compareAndSetShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public boolean weakCompareAndSetCharAcquire(Object o, long offset, char expected, char x) {
        return this.compareAndSetShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public boolean weakCompareAndSetCharRelease(Object o, long offset, char expected, char x) {
        return this.compareAndSetShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public boolean weakCompareAndSetCharPlain(Object o, long offset, char expected, char x) {
        return this.compareAndSetShort(o, offset, (short)expected, (short)x);
    }

    @Override
    public boolean compareAndSetBoolean(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndSetByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0);
    }

    @Override
    public boolean compareAndExchangeBoolean(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndExchangeByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean compareAndExchangeBooleanAcquire(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndExchangeByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean compareAndExchangeBooleanRelease(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndExchangeByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean weakCompareAndSetBoolean(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndSetByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0);
    }

    @Override
    public boolean weakCompareAndSetBooleanAcquire(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndSetByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0);
    }

    @Override
    public boolean weakCompareAndSetBooleanRelease(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndSetByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0);
    }

    @Override
    public boolean weakCompareAndSetBooleanPlain(Object o, long offset, boolean expected, boolean x) {
        return this.compareAndSetByte(o, offset, expected ? (byte)1 : 0, x ? (byte)1 : 0);
    }

    @Override
    public boolean compareAndSetFloat(Object o, long offset, float expected, float x) {
        return this.compareAndSetInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @Override
    public float compareAndExchangeFloat(Object o, long offset, float expected, float x) {
        return Float.intBitsToFloat(this.compareAndExchangeInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x)));
    }

    @Override
    public float compareAndExchangeFloatAcquire(Object o, long offset, float expected, float x) {
        return Float.intBitsToFloat(this.compareAndExchangeInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x)));
    }

    @Override
    public float compareAndExchangeFloatRelease(Object o, long offset, float expected, float x) {
        return Float.intBitsToFloat(this.compareAndExchangeInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x)));
    }

    @Override
    public boolean weakCompareAndSetFloatPlain(Object o, long offset, float expected, float x) {
        return this.compareAndSetInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @Override
    public boolean weakCompareAndSetFloatAcquire(Object o, long offset, float expected, float x) {
        return this.compareAndSetInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @Override
    public boolean weakCompareAndSetFloatRelease(Object o, long offset, float expected, float x) {
        return this.compareAndSetInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @Override
    public boolean weakCompareAndSetFloat(Object o, long offset, float expected, float x) {
        return this.compareAndSetInt(o, offset, Float.floatToRawIntBits(expected), Float.floatToRawIntBits(x));
    }

    @Override
    public boolean compareAndSetDouble(Object o, long offset, double expected, double x) {
        return this.compareAndSetLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @Override
    public double compareAndExchangeDouble(Object o, long offset, double expected, double x) {
        return Double.longBitsToDouble(this.compareAndExchangeLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x)));
    }

    @Override
    public double compareAndExchangeDoubleAcquire(Object o, long offset, double expected, double x) {
        return Double.longBitsToDouble(this.compareAndExchangeLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x)));
    }

    @Override
    public double compareAndExchangeDoubleRelease(Object o, long offset, double expected, double x) {
        return Double.longBitsToDouble(this.compareAndExchangeLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x)));
    }

    @Override
    public boolean weakCompareAndSetDoublePlain(Object o, long offset, double expected, double x) {
        return this.compareAndSetLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @Override
    public boolean weakCompareAndSetDoubleAcquire(Object o, long offset, double expected, double x) {
        return this.compareAndSetLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @Override
    public boolean weakCompareAndSetDoubleRelease(Object o, long offset, double expected, double x) {
        return this.compareAndSetLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @Override
    public boolean weakCompareAndSetDouble(Object o, long offset, double expected, double x) {
        return this.compareAndSetLong(o, offset, Double.doubleToRawLongBits(expected), Double.doubleToRawLongBits(x));
    }

    @Override
    public boolean compareAndSetLong(Object o, long offset, long expected, long x) {
        return this.theUnsafe.compareAndSwapLong(o, offset, expected, x);
    }

    @Override
    public long compareAndExchangeLong(Object o, long offset, long expected, long x) {
        long witness;
        do {
            if ((witness = this.theUnsafe.getLongVolatile(o, offset)) == expected) continue;
            return witness;
        } while (!this.theUnsafe.compareAndSwapLong(o, offset, witness, x));
        return witness;
    }

    @Override
    public long compareAndExchangeLongAcquire(Object o, long offset, long expected, long x) {
        return this.compareAndExchangeLong(o, offset, expected, x);
    }

    @Override
    public long compareAndExchangeLongRelease(Object o, long offset, long expected, long x) {
        return this.compareAndExchangeLong(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetLongPlain(Object o, long offset, long expected, long x) {
        return this.theUnsafe.compareAndSwapLong(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetLongAcquire(Object o, long offset, long expected, long x) {
        return this.theUnsafe.compareAndSwapLong(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetLongRelease(Object o, long offset, long expected, long x) {
        return this.theUnsafe.compareAndSwapLong(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetLong(Object o, long offset, long expected, long x) {
        return this.theUnsafe.compareAndSwapLong(o, offset, expected, x);
    }

    @Override
    public Object getReferenceVolatile(Object o, long offset) {
        return this.theUnsafe.getObjectVolatile(o, offset);
    }

    public boolean compareAndSwapObject(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    public boolean compareAndSwapInt(Object o, long offset, int expected, int x) {
        return this.theUnsafe.compareAndSwapInt(o, offset, expected, x);
    }

    public boolean compareAndSwapLong(Object o, long offset, long expected, long x) {
        return this.theUnsafe.compareAndSwapLong(o, offset, expected, x);
    }

    @Override
    public Object getObjectVolatile(Object o, long offset) {
        return this.theUnsafe.getObjectVolatile(o, offset);
    }

    @Override
    public Object getObjectAcquire(Object o, long offset) {
        return this.theUnsafe.getObjectVolatile(o, offset);
    }

    @Override
    public Object getObjectOpaque(Object o, long offset) {
        return this.theUnsafe.getObjectVolatile(o, offset);
    }

    @Override
    public void putObjectVolatile(Object o, long offset, Object x) {
        this.theUnsafe.putObjectVolatile(o, offset, x);
    }

    @Override
    public void putObjectOpaque(Object o, long offset, Object x) {
        this.theUnsafe.putObjectVolatile(o, offset, x);
    }

    @Override
    public void putObjectRelease(Object o, long offset, Object x) {
        this.theUnsafe.putObjectVolatile(o, offset, x);
    }

    @Override
    public Object getAndSetObject(Object o, long offset, Object newValue) {
        return this.theUnsafe.getAndSetObject(o, offset, newValue);
    }

    @Override
    public Object getAndSetObjectAcquire(Object o, long offset, Object newValue) {
        return this.theUnsafe.getAndSetObject(o, offset, newValue);
    }

    @Override
    public Object getAndSetObjectRelease(Object o, long offset, Object newValue) {
        return this.theUnsafe.getAndSetObject(o, offset, newValue);
    }

    @Override
    public boolean compareAndSetObject(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public Object compareAndExchangeObject(Object o, long offset, Object expected, Object x) {
        Object witness;
        do {
            if ((witness = this.theUnsafe.getObjectVolatile(o, offset)) == expected) continue;
            return witness;
        } while (!this.theUnsafe.compareAndSwapObject(o, offset, witness, x));
        return witness;
    }

    @Override
    public Object compareAndExchangeObjectAcquire(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeObject(o, offset, expected, x);
    }

    @Override
    public Object compareAndExchangeObjectRelease(Object o, long offset, Object expected, Object x) {
        return this.compareAndExchangeObject(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetObject(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetObjectAcquire(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetObjectPlain(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public boolean weakCompareAndSetObjectRelease(Object o, long offset, Object expected, Object x) {
        return this.theUnsafe.compareAndSwapObject(o, offset, expected, x);
    }

    @Override
    public int getIntVolatile(Object o, long offset) {
        return this.theUnsafe.getIntVolatile(o, offset);
    }

    @Override
    public void putIntVolatile(Object o, long offset, int x) {
        this.theUnsafe.putIntVolatile(o, offset, x);
    }

    @Override
    public boolean getBooleanVolatile(Object o, long offset) {
        return this.theUnsafe.getBooleanVolatile(o, offset);
    }

    @Override
    public void putBooleanVolatile(Object o, long offset, boolean x) {
        this.theUnsafe.putBooleanVolatile(o, offset, x);
    }

    @Override
    public byte getByteVolatile(Object o, long offset) {
        return this.theUnsafe.getByteVolatile(o, offset);
    }

    @Override
    public void putByteVolatile(Object o, long offset, byte x) {
        this.theUnsafe.putByteVolatile(o, offset, x);
    }

    @Override
    public short getShortVolatile(Object o, long offset) {
        return this.theUnsafe.getShortVolatile(o, offset);
    }

    @Override
    public void putShortVolatile(Object o, long offset, short x) {
        this.theUnsafe.putShortVolatile(o, offset, x);
    }

    @Override
    public char getCharVolatile(Object o, long offset) {
        return this.theUnsafe.getCharVolatile(o, offset);
    }

    @Override
    public void putCharVolatile(Object o, long offset, char x) {
        this.theUnsafe.putCharVolatile(o, offset, x);
    }

    @Override
    public long getLongVolatile(Object o, long offset) {
        return this.theUnsafe.getLongVolatile(o, offset);
    }

    @Override
    public void putLongVolatile(Object o, long offset, long x) {
        this.theUnsafe.putLongVolatile(o, offset, x);
    }

    @Override
    public float getFloatVolatile(Object o, long offset) {
        return this.theUnsafe.getFloatVolatile(o, offset);
    }

    @Override
    public void putFloatVolatile(Object o, long offset, float x) {
        this.theUnsafe.putFloatVolatile(o, offset, x);
    }

    @Override
    public double getDoubleVolatile(Object o, long offset) {
        return this.theUnsafe.getDoubleVolatile(o, offset);
    }

    @Override
    public void putDoubleVolatile(Object o, long offset, double x) {
        this.theUnsafe.putDoubleVolatile(o, offset, x);
    }

    public void putOrderedObject(Object o, long offset, Object x) {
        this.theUnsafe.putOrderedObject(o, offset, x);
    }

    public void putOrderedInt(Object o, long offset, int x) {
        this.theUnsafe.putOrderedInt(o, offset, x);
    }

    public void putOrderedLong(Object o, long offset, long x) {
        this.theUnsafe.putOrderedLong(o, offset, x);
    }

    @Override
    public void unpark(Object thread) {
        this.theUnsafe.unpark(thread);
    }

    @Override
    public void park(boolean isAbsolute, long time) {
        this.theUnsafe.park(isAbsolute, time);
    }

    @Override
    public int getLoadAverage(double[] loadavg, int nelems) {
        return this.theUnsafe.getLoadAverage(loadavg, nelems);
    }

    @Override
    public int getAndAddInt(Object o, long offset, int delta) {
        return this.theUnsafe.getAndAddInt(o, offset, delta);
    }

    @Override
    public int getAndAddIntRelease(Object o, long offset, int delta) {
        return this.theUnsafe.getAndAddInt(o, offset, delta);
    }

    @Override
    public int getAndAddIntAcquire(Object o, long offset, int delta) {
        return this.theUnsafe.getAndAddInt(o, offset, delta);
    }

    @Override
    public long getAndAddLong(Object o, long offset, long delta) {
        return this.theUnsafe.getAndAddLong(o, offset, delta);
    }

    @Override
    public long getAndAddLongRelease(Object o, long offset, long delta) {
        return this.theUnsafe.getAndAddLong(o, offset, delta);
    }

    @Override
    public long getAndAddLongAcquire(Object o, long offset, long delta) {
        return this.theUnsafe.getAndAddLong(o, offset, delta);
    }

    @Override
    public byte getAndAddByte(Object o, long offset, byte delta) {
        byte v;
        while (!this.weakCompareAndSetByte(o, offset, v = this.getByteVolatile(o, offset), (byte)(v + delta))) {
        }
        return v;
    }

    @Override
    public byte getAndAddByteRelease(Object o, long offset, byte delta) {
        return this.getAndAddByte(o, offset, delta);
    }

    @Override
    public byte getAndAddByteAcquire(Object o, long offset, byte delta) {
        return this.getAndAddByte(o, offset, delta);
    }

    @Override
    public short getAndAddShort(Object o, long offset, short delta) {
        short v;
        while (!this.weakCompareAndSetShort(o, offset, v = this.getShortVolatile(o, offset), (short)(v + delta))) {
        }
        return v;
    }

    @Override
    public short getAndAddShortRelease(Object o, long offset, short delta) {
        return this.getAndAddShort(o, offset, delta);
    }

    @Override
    public short getAndAddShortAcquire(Object o, long offset, short delta) {
        return this.getAndAddShort(o, offset, delta);
    }

    @Override
    public char getAndAddChar(Object o, long offset, char delta) {
        return (char)this.getAndAddShort(o, offset, (short)delta);
    }

    @Override
    public char getAndAddCharRelease(Object o, long offset, char delta) {
        return (char)this.getAndAddShort(o, offset, (short)delta);
    }

    @Override
    public char getAndAddCharAcquire(Object o, long offset, char delta) {
        return (char)this.getAndAddShort(o, offset, (short)delta);
    }

    @Override
    public float getAndAddFloat(Object o, long offset, float delta) {
        float v;
        int expectedBits;
        while (!this.weakCompareAndSetInt(o, offset, expectedBits = this.getIntVolatile(o, offset), Float.floatToRawIntBits((v = Float.intBitsToFloat(expectedBits)) + delta))) {
        }
        return v;
    }

    @Override
    public float getAndAddFloatRelease(Object o, long offset, float delta) {
        return this.getAndAddFloat(o, offset, delta);
    }

    @Override
    public float getAndAddFloatAcquire(Object o, long offset, float delta) {
        return this.getAndAddFloat(o, offset, delta);
    }

    @Override
    public double getAndAddDouble(Object o, long offset, double delta) {
        double v;
        long expectedBits;
        while (!this.weakCompareAndSetLong(o, offset, expectedBits = this.getLongVolatile(o, offset), Double.doubleToRawLongBits((v = Double.longBitsToDouble(expectedBits)) + delta))) {
        }
        return v;
    }

    @Override
    public double getAndAddDoubleRelease(Object o, long offset, double delta) {
        return this.getAndAddDouble(o, offset, delta);
    }

    @Override
    public double getAndAddDoubleAcquire(Object o, long offset, double delta) {
        return this.getAndAddDouble(o, offset, delta);
    }

    @Override
    public int getAndSetInt(Object o, long offset, int newValue) {
        return this.theUnsafe.getAndSetInt(o, offset, newValue);
    }

    @Override
    public int getAndSetIntRelease(Object o, long offset, int newValue) {
        return this.theUnsafe.getAndSetInt(o, offset, newValue);
    }

    @Override
    public int getAndSetIntAcquire(Object o, long offset, int newValue) {
        return this.theUnsafe.getAndSetInt(o, offset, newValue);
    }

    @Override
    public long getAndSetLong(Object o, long offset, long newValue) {
        return this.theUnsafe.getAndSetLong(o, offset, newValue);
    }

    @Override
    public long getAndSetLongRelease(Object o, long offset, long newValue) {
        return this.theUnsafe.getAndSetLong(o, offset, newValue);
    }

    @Override
    public long getAndSetLongAcquire(Object o, long offset, long newValue) {
        return this.theUnsafe.getAndSetLong(o, offset, newValue);
    }

    @Override
    public Object getAndSetReference(Object o, long offset, Object newValue) {
        return this.theUnsafe.getAndSetObject(o, offset, newValue);
    }

    @Override
    public Object getAndSetReferenceRelease(Object o, long offset, Object newValue) {
        return this.theUnsafe.getAndSetObject(o, offset, newValue);
    }

    @Override
    public Object getAndSetReferenceAcquire(Object o, long offset, Object newValue) {
        return this.theUnsafe.getAndSetObject(o, offset, newValue);
    }

    @Override
    public byte getAndSetByte(Object o, long offset, byte newValue) {
        byte v;
        while (!this.weakCompareAndSetByte(o, offset, v = this.getByteVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @Override
    public byte getAndSetByteRelease(Object o, long offset, byte newValue) {
        return this.getAndSetByte(o, offset, newValue);
    }

    @Override
    public byte getAndSetByteAcquire(Object o, long offset, byte newValue) {
        return this.getAndSetByte(o, offset, newValue);
    }

    @Override
    public boolean getAndSetBoolean(Object o, long offset, boolean newValue) {
        return this.getAndSetByte(o, offset, newValue ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndSetBooleanRelease(Object o, long offset, boolean newValue) {
        return this.getAndSetByte(o, offset, newValue ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndSetBooleanAcquire(Object o, long offset, boolean newValue) {
        return this.getAndSetByte(o, offset, newValue ? (byte)1 : 0) != 0;
    }

    @Override
    public short getAndSetShort(Object o, long offset, short newValue) {
        short v;
        while (!this.weakCompareAndSetShort(o, offset, v = this.getShortVolatile(o, offset), newValue)) {
        }
        return v;
    }

    @Override
    public short getAndSetShortRelease(Object o, long offset, short newValue) {
        return this.getAndSetShort(o, offset, newValue);
    }

    @Override
    public short getAndSetShortAcquire(Object o, long offset, short newValue) {
        return this.getAndSetShort(o, offset, newValue);
    }

    @Override
    public char getAndSetChar(Object o, long offset, char newValue) {
        return (char)this.getAndSetShort(o, offset, (short)newValue);
    }

    @Override
    public char getAndSetCharRelease(Object o, long offset, char newValue) {
        return (char)this.getAndSetShort(o, offset, (short)newValue);
    }

    @Override
    public char getAndSetCharAcquire(Object o, long offset, char newValue) {
        return (char)this.getAndSetShort(o, offset, (short)newValue);
    }

    @Override
    public float getAndSetFloat(Object o, long offset, float newValue) {
        return Float.intBitsToFloat(this.getAndSetInt(o, offset, Float.floatToRawIntBits(newValue)));
    }

    @Override
    public float getAndSetFloatRelease(Object o, long offset, float newValue) {
        return Float.intBitsToFloat(this.getAndSetInt(o, offset, Float.floatToRawIntBits(newValue)));
    }

    @Override
    public float getAndSetFloatAcquire(Object o, long offset, float newValue) {
        return Float.intBitsToFloat(this.getAndSetInt(o, offset, Float.floatToRawIntBits(newValue)));
    }

    @Override
    public double getAndSetDouble(Object o, long offset, double newValue) {
        return Double.longBitsToDouble(this.getAndSetLong(o, offset, Double.doubleToRawLongBits(newValue)));
    }

    @Override
    public double getAndSetDoubleRelease(Object o, long offset, double newValue) {
        return Double.longBitsToDouble(this.getAndSetLong(o, offset, Double.doubleToRawLongBits(newValue)));
    }

    @Override
    public double getAndSetDoubleAcquire(Object o, long offset, double newValue) {
        return Double.longBitsToDouble(this.getAndSetLong(o, offset, Double.doubleToRawLongBits(newValue)));
    }

    @Override
    public boolean getAndBitwiseOrBoolean(Object o, long offset, boolean mask) {
        return this.getAndBitwiseOrByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseOrBooleanRelease(Object o, long offset, boolean mask) {
        return this.getAndBitwiseOrByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseOrBooleanAcquire(Object o, long offset, boolean mask) {
        return this.getAndBitwiseOrByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseAndBoolean(Object o, long offset, boolean mask) {
        return this.getAndBitwiseAndByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseAndBooleanRelease(Object o, long offset, boolean mask) {
        return this.getAndBitwiseAndByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseAndBooleanAcquire(Object o, long offset, boolean mask) {
        return this.getAndBitwiseAndByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseXorBoolean(Object o, long offset, boolean mask) {
        return this.getAndBitwiseXorByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseXorBooleanRelease(Object o, long offset, boolean mask) {
        return this.getAndBitwiseXorByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public boolean getAndBitwiseXorBooleanAcquire(Object o, long offset, boolean mask) {
        return this.getAndBitwiseXorByte(o, offset, mask ? (byte)1 : 0) != 0;
    }

    @Override
    public byte getAndBitwiseOrByte(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteRelease(o, offset, current = this.getByte(o, offset), (byte)(current | mask))) {
        }
        return current;
    }

    @Override
    public byte getAndBitwiseOrByteRelease(Object o, long offset, byte mask) {
        return this.getAndBitwiseOrByte(o, offset, mask);
    }

    @Override
    public byte getAndBitwiseOrByteAcquire(Object o, long offset, byte mask) {
        return this.getAndBitwiseOrByte(o, offset, mask);
    }

    @Override
    public byte getAndBitwiseAndByte(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByteRelease(o, offset, current = this.getByte(o, offset), (byte)(current & mask))) {
        }
        return current;
    }

    @Override
    public byte getAndBitwiseAndByteRelease(Object o, long offset, byte mask) {
        return this.getAndBitwiseAndByte(o, offset, mask);
    }

    @Override
    public byte getAndBitwiseAndByteAcquire(Object o, long offset, byte mask) {
        return this.getAndBitwiseAndByte(o, offset, mask);
    }

    @Override
    public byte getAndBitwiseXorByte(Object o, long offset, byte mask) {
        byte current;
        while (!this.weakCompareAndSetByte(o, offset, current = this.getByteVolatile(o, offset), (byte)(current ^ mask))) {
        }
        return current;
    }

    @Override
    public byte getAndBitwiseXorByteRelease(Object o, long offset, byte mask) {
        return this.getAndBitwiseXorByte(o, offset, mask);
    }

    @Override
    public byte getAndBitwiseXorByteAcquire(Object o, long offset, byte mask) {
        return this.getAndBitwiseXorByte(o, offset, mask);
    }

    @Override
    public char getAndBitwiseOrChar(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseOrShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseOrCharRelease(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseOrShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseOrCharAcquire(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseOrShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseAndChar(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseAndShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseAndCharRelease(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseAndShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseAndCharAcquire(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseAndShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseXorChar(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseXorShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseXorCharRelease(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseXorShort(o, offset, (short)mask);
    }

    @Override
    public char getAndBitwiseXorCharAcquire(Object o, long offset, char mask) {
        return (char)this.getAndBitwiseXorShort(o, offset, (short)mask);
    }

    @Override
    public short getAndBitwiseOrShort(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShort(o, offset, current = this.getShortVolatile(o, offset), (short)(current | mask))) {
        }
        return current;
    }

    @Override
    public short getAndBitwiseOrShortRelease(Object o, long offset, short mask) {
        return this.getAndBitwiseOrShort(o, offset, mask);
    }

    @Override
    public short getAndBitwiseOrShortAcquire(Object o, long offset, short mask) {
        return this.getAndBitwiseOrShort(o, offset, mask);
    }

    @Override
    public short getAndBitwiseAndShort(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShort(o, offset, current = this.getShortVolatile(o, offset), (short)(current & mask))) {
        }
        return current;
    }

    @Override
    public short getAndBitwiseAndShortRelease(Object o, long offset, short mask) {
        return this.getAndBitwiseAndShort(o, offset, mask);
    }

    @Override
    public short getAndBitwiseAndShortAcquire(Object o, long offset, short mask) {
        return this.getAndBitwiseAndShort(o, offset, mask);
    }

    @Override
    public short getAndBitwiseXorShort(Object o, long offset, short mask) {
        short current;
        while (!this.weakCompareAndSetShort(o, offset, current = this.getShortVolatile(o, offset), (short)(current ^ mask))) {
        }
        return current;
    }

    @Override
    public short getAndBitwiseXorShortRelease(Object o, long offset, short mask) {
        return this.getAndBitwiseXorShort(o, offset, mask);
    }

    @Override
    public short getAndBitwiseXorShortAcquire(Object o, long offset, short mask) {
        return this.getAndBitwiseXorShort(o, offset, mask);
    }

    @Override
    public int getAndBitwiseOrInt(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetInt(o, offset, current = this.getIntVolatile(o, offset), current | mask)) {
        }
        return current;
    }

    @Override
    public int getAndBitwiseOrIntRelease(Object o, long offset, int mask) {
        return this.getAndBitwiseOrInt(o, offset, mask);
    }

    @Override
    public int getAndBitwiseOrIntAcquire(Object o, long offset, int mask) {
        return this.getAndBitwiseOrInt(o, offset, mask);
    }

    @Override
    public int getAndBitwiseAndInt(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetInt(o, offset, current = this.getIntVolatile(o, offset), current & mask)) {
        }
        return current;
    }

    @Override
    public int getAndBitwiseAndIntRelease(Object o, long offset, int mask) {
        return this.getAndBitwiseAndInt(o, offset, mask);
    }

    @Override
    public int getAndBitwiseAndIntAcquire(Object o, long offset, int mask) {
        return this.getAndBitwiseAndInt(o, offset, mask);
    }

    @Override
    public int getAndBitwiseXorInt(Object o, long offset, int mask) {
        int current;
        while (!this.weakCompareAndSetInt(o, offset, current = this.getIntVolatile(o, offset), current ^ mask)) {
        }
        return current;
    }

    @Override
    public int getAndBitwiseXorIntRelease(Object o, long offset, int mask) {
        return this.getAndBitwiseXorInt(o, offset, mask);
    }

    @Override
    public int getAndBitwiseXorIntAcquire(Object o, long offset, int mask) {
        return this.getAndBitwiseXorInt(o, offset, mask);
    }

    @Override
    public long getAndBitwiseOrLong(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLong(o, offset, current = this.getLongVolatile(o, offset), current | mask)) {
        }
        return current;
    }

    @Override
    public long getAndBitwiseOrLongRelease(Object o, long offset, long mask) {
        return this.getAndBitwiseOrLong(o, offset, mask);
    }

    @Override
    public long getAndBitwiseOrLongAcquire(Object o, long offset, long mask) {
        return this.getAndBitwiseOrLong(o, offset, mask);
    }

    @Override
    public long getAndBitwiseAndLong(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLong(o, offset, current = this.getLongVolatile(o, offset), current & mask)) {
        }
        return current;
    }

    @Override
    public long getAndBitwiseAndLongRelease(Object o, long offset, long mask) {
        return this.getAndBitwiseAndLong(o, offset, mask);
    }

    @Override
    public long getAndBitwiseAndLongAcquire(Object o, long offset, long mask) {
        return this.getAndBitwiseAndLong(o, offset, mask);
    }

    @Override
    public long getAndBitwiseXorLong(Object o, long offset, long mask) {
        long current;
        while (!this.weakCompareAndSetLong(o, offset, current = this.getLongVolatile(o, offset), current ^ mask)) {
        }
        return current;
    }

    @Override
    public long getAndBitwiseXorLongRelease(Object o, long offset, long mask) {
        return this.getAndBitwiseXorLong(o, offset, mask);
    }

    @Override
    public long getAndBitwiseXorLongAcquire(Object o, long offset, long mask) {
        return this.getAndBitwiseXorLong(o, offset, mask);
    }

    @Override
    public void loadFence() {
        this.theUnsafe.loadFence();
    }

    @Override
    public void storeFence() {
        this.theUnsafe.storeFence();
    }

    @Override
    public void fullFence() {
        this.theUnsafe.fullFence();
    }

    @Override
    public void loadLoadFence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void storeStoreFence() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBigEndian() {
        return BIG_ENDIAN;
    }

    @Override
    public boolean unalignedAccess() {
        return false;
    }

    private static int pickPos(int top, int pos) {
        return BIG_ENDIAN ? top - pos : pos;
    }

    private static long makeLong(byte i0, byte i1, byte i2, byte i3, byte i4, byte i5, byte i6, byte i7) {
        return SunMiscUnsafe.toUnsignedLong(i0) << SunMiscUnsafe.pickPos(56, 0) | SunMiscUnsafe.toUnsignedLong(i1) << SunMiscUnsafe.pickPos(56, 8) | SunMiscUnsafe.toUnsignedLong(i2) << SunMiscUnsafe.pickPos(56, 16) | SunMiscUnsafe.toUnsignedLong(i3) << SunMiscUnsafe.pickPos(56, 24) | SunMiscUnsafe.toUnsignedLong(i4) << SunMiscUnsafe.pickPos(56, 32) | SunMiscUnsafe.toUnsignedLong(i5) << SunMiscUnsafe.pickPos(56, 40) | SunMiscUnsafe.toUnsignedLong(i6) << SunMiscUnsafe.pickPos(56, 48) | SunMiscUnsafe.toUnsignedLong(i7) << SunMiscUnsafe.pickPos(56, 56);
    }

    private static long makeLong(short i0, short i1, short i2, short i3) {
        return SunMiscUnsafe.toUnsignedLong(i0) << SunMiscUnsafe.pickPos(48, 0) | SunMiscUnsafe.toUnsignedLong(i1) << SunMiscUnsafe.pickPos(48, 16) | SunMiscUnsafe.toUnsignedLong(i2) << SunMiscUnsafe.pickPos(48, 32) | SunMiscUnsafe.toUnsignedLong(i3) << SunMiscUnsafe.pickPos(48, 48);
    }

    private static long makeLong(int i0, int i1) {
        return SunMiscUnsafe.toUnsignedLong(i0) << SunMiscUnsafe.pickPos(32, 0) | SunMiscUnsafe.toUnsignedLong(i1) << SunMiscUnsafe.pickPos(32, 32);
    }

    private static int makeInt(short i0, short i1) {
        return SunMiscUnsafe.toUnsignedInt(i0) << SunMiscUnsafe.pickPos(16, 0) | SunMiscUnsafe.toUnsignedInt(i1) << SunMiscUnsafe.pickPos(16, 16);
    }

    private static int makeInt(byte i0, byte i1, byte i2, byte i3) {
        return SunMiscUnsafe.toUnsignedInt(i0) << SunMiscUnsafe.pickPos(24, 0) | SunMiscUnsafe.toUnsignedInt(i1) << SunMiscUnsafe.pickPos(24, 8) | SunMiscUnsafe.toUnsignedInt(i2) << SunMiscUnsafe.pickPos(24, 16) | SunMiscUnsafe.toUnsignedInt(i3) << SunMiscUnsafe.pickPos(24, 24);
    }

    private static short makeShort(byte i0, byte i1) {
        return (short)(SunMiscUnsafe.toUnsignedInt(i0) << SunMiscUnsafe.pickPos(8, 0) | SunMiscUnsafe.toUnsignedInt(i1) << SunMiscUnsafe.pickPos(8, 8));
    }

    private static byte pick(byte le, byte be) {
        return BIG_ENDIAN ? be : le;
    }

    private static short pick(short le, short be) {
        return BIG_ENDIAN ? be : le;
    }

    private static int pick(int le, int be) {
        return BIG_ENDIAN ? be : le;
    }

    private void putLongParts(Object o, long offset, byte i0, byte i1, byte i2, byte i3, byte i4, byte i5, byte i6, byte i7) {
        this.putByte(o, offset + 0L, SunMiscUnsafe.pick(i0, i7));
        this.putByte(o, offset + 1L, SunMiscUnsafe.pick(i1, i6));
        this.putByte(o, offset + 2L, SunMiscUnsafe.pick(i2, i5));
        this.putByte(o, offset + 3L, SunMiscUnsafe.pick(i3, i4));
        this.putByte(o, offset + 4L, SunMiscUnsafe.pick(i4, i3));
        this.putByte(o, offset + 5L, SunMiscUnsafe.pick(i5, i2));
        this.putByte(o, offset + 6L, SunMiscUnsafe.pick(i6, i1));
        this.putByte(o, offset + 7L, SunMiscUnsafe.pick(i7, i0));
    }

    private void putLongParts(Object o, long offset, short i0, short i1, short i2, short i3) {
        this.putShort(o, offset + 0L, SunMiscUnsafe.pick(i0, i3));
        this.putShort(o, offset + 2L, SunMiscUnsafe.pick(i1, i2));
        this.putShort(o, offset + 4L, SunMiscUnsafe.pick(i2, i1));
        this.putShort(o, offset + 6L, SunMiscUnsafe.pick(i3, i0));
    }

    private void putLongParts(Object o, long offset, int i0, int i1) {
        this.putInt(o, offset + 0L, SunMiscUnsafe.pick(i0, i1));
        this.putInt(o, offset + 4L, SunMiscUnsafe.pick(i1, i0));
    }

    private void putIntParts(Object o, long offset, short i0, short i1) {
        this.putShort(o, offset + 0L, SunMiscUnsafe.pick(i0, i1));
        this.putShort(o, offset + 2L, SunMiscUnsafe.pick(i1, i0));
    }

    private void putIntParts(Object o, long offset, byte i0, byte i1, byte i2, byte i3) {
        this.putByte(o, offset + 0L, SunMiscUnsafe.pick(i0, i3));
        this.putByte(o, offset + 1L, SunMiscUnsafe.pick(i1, i2));
        this.putByte(o, offset + 2L, SunMiscUnsafe.pick(i2, i1));
        this.putByte(o, offset + 3L, SunMiscUnsafe.pick(i3, i0));
    }

    private void putShortParts(Object o, long offset, byte i0, byte i1) {
        this.putByte(o, offset + 0L, SunMiscUnsafe.pick(i0, i1));
        this.putByte(o, offset + 1L, SunMiscUnsafe.pick(i1, i0));
    }

    private static int toUnsignedInt(byte n) {
        return n & 0xFF;
    }

    private static int toUnsignedInt(short n) {
        return n & 0xFFFF;
    }

    private static long toUnsignedLong(byte n) {
        return (long)n & 0xFFL;
    }

    private static long toUnsignedLong(short n) {
        return (long)n & 0xFFFFL;
    }

    private static long toUnsignedLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    private static char convEndian(boolean big, char n) {
        return big == BIG_ENDIAN ? n : Character.reverseBytes(n);
    }

    private static short convEndian(boolean big, short n) {
        return big == BIG_ENDIAN ? n : Short.reverseBytes(n);
    }

    private static int convEndian(boolean big, int n) {
        return big == BIG_ENDIAN ? n : Integer.reverseBytes(n);
    }

    private static long convEndian(boolean big, long n) {
        return big == BIG_ENDIAN ? n : Long.reverseBytes(n);
    }

    @Override
    public final long getLongUnaligned(Object o, long offset) {
        if ((offset & 7L) == 0L) {
            return this.getLong(o, offset);
        }
        if ((offset & 3L) == 0L) {
            return SunMiscUnsafe.makeLong(this.getInt(o, offset), this.getInt(o, offset + 4L));
        }
        if ((offset & 1L) == 0L) {
            return SunMiscUnsafe.makeLong(this.getShort(o, offset), this.getShort(o, offset + 2L), this.getShort(o, offset + 4L), this.getShort(o, offset + 6L));
        }
        return SunMiscUnsafe.makeLong(this.getByte(o, offset), this.getByte(o, offset + 1L), this.getByte(o, offset + 2L), this.getByte(o, offset + 3L), this.getByte(o, offset + 4L), this.getByte(o, offset + 5L), this.getByte(o, offset + 6L), this.getByte(o, offset + 7L));
    }

    @Override
    public final long getLongUnaligned(Object o, long offset, boolean bigEndian) {
        return SunMiscUnsafe.convEndian(bigEndian, this.getLongUnaligned(o, offset));
    }

    @Override
    public final int getIntUnaligned(Object o, long offset) {
        if ((offset & 3L) == 0L) {
            return this.getInt(o, offset);
        }
        if ((offset & 1L) == 0L) {
            return SunMiscUnsafe.makeInt(this.getShort(o, offset), this.getShort(o, offset + 2L));
        }
        return SunMiscUnsafe.makeInt(this.getByte(o, offset), this.getByte(o, offset + 1L), this.getByte(o, offset + 2L), this.getByte(o, offset + 3L));
    }

    @Override
    public final int getIntUnaligned(Object o, long offset, boolean bigEndian) {
        return SunMiscUnsafe.convEndian(bigEndian, this.getIntUnaligned(o, offset));
    }

    @Override
    public final short getShortUnaligned(Object o, long offset) {
        if ((offset & 1L) == 0L) {
            return this.getShort(o, offset);
        }
        return SunMiscUnsafe.makeShort(this.getByte(o, offset), this.getByte(o, offset + 1L));
    }

    @Override
    public final short getShortUnaligned(Object o, long offset, boolean bigEndian) {
        return SunMiscUnsafe.convEndian(bigEndian, this.getShortUnaligned(o, offset));
    }

    @Override
    public final char getCharUnaligned(Object o, long offset) {
        if ((offset & 1L) == 0L) {
            return this.getChar(o, offset);
        }
        return (char)SunMiscUnsafe.makeShort(this.getByte(o, offset), this.getByte(o, offset + 1L));
    }

    @Override
    public final char getCharUnaligned(Object o, long offset, boolean bigEndian) {
        return SunMiscUnsafe.convEndian(bigEndian, this.getCharUnaligned(o, offset));
    }

    @Override
    public final void putLongUnaligned(Object o, long offset, long x) {
        if ((offset & 7L) == 0L) {
            this.putLong(o, offset, x);
        } else if ((offset & 3L) == 0L) {
            this.putLongParts(o, offset, (int)(x >> 0), (int)(x >>> 32));
        } else if ((offset & 1L) == 0L) {
            this.putLongParts(o, offset, (short)(x >>> 0), (short)(x >>> 16), (short)(x >>> 32), (short)(x >>> 48));
        } else {
            this.putLongParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24), (byte)(x >>> 32), (byte)(x >>> 40), (byte)(x >>> 48), (byte)(x >>> 56));
        }
    }

    @Override
    public final void putLongUnaligned(Object o, long offset, long x, boolean bigEndian) {
        this.putLongUnaligned(o, offset, SunMiscUnsafe.convEndian(bigEndian, x));
    }

    @Override
    public final void putIntUnaligned(Object o, long offset, int x) {
        if ((offset & 3L) == 0L) {
            this.putInt(o, offset, x);
        } else if ((offset & 1L) == 0L) {
            this.putIntParts(o, offset, (short)(x >> 0), (short)(x >>> 16));
        } else {
            this.putIntParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8), (byte)(x >>> 16), (byte)(x >>> 24));
        }
    }

    @Override
    public final void putIntUnaligned(Object o, long offset, int x, boolean bigEndian) {
        this.putIntUnaligned(o, offset, SunMiscUnsafe.convEndian(bigEndian, x));
    }

    @Override
    public final void putShortUnaligned(Object o, long offset, short x) {
        if ((offset & 1L) == 0L) {
            this.putShort(o, offset, x);
        } else {
            this.putShortParts(o, offset, (byte)(x >>> 0), (byte)(x >>> 8));
        }
    }

    @Override
    public final void putShortUnaligned(Object o, long offset, short x, boolean bigEndian) {
        this.putShortUnaligned(o, offset, SunMiscUnsafe.convEndian(bigEndian, x));
    }

    @Override
    public final void putCharUnaligned(Object o, long offset, char x) {
        this.putShortUnaligned(o, offset, (short)x);
    }

    @Override
    public final void putCharUnaligned(Object o, long offset, char x, boolean bigEndian) {
        this.putCharUnaligned(o, offset, SunMiscUnsafe.convEndian(bigEndian, x));
    }

    @Override
    @Analysis.SkipAnalysis
    public void invokeCleaner(ByteBuffer directBuffer) {
        this.theUnsafe.invokeCleaner(directBuffer);
    }
}

