/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.test;

import io.github.microcks.domain.Request;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.TestStepResult;

public class TestReturn {
    public static final int SUCCESS_CODE = 0;
    public static final int FAILURE_CODE = 1;
    private int code;
    private long elapsedTime;
    private String message;
    private Request request;
    private Response response;

    public TestReturn() {
    }

    public TestReturn(int code, long elapsedTime, Request request, Response response) {
        this.code = code;
        this.elapsedTime = elapsedTime;
        this.request = request;
        this.response = response;
    }

    public TestReturn(int code, long elapsedTime, String message, Request request, Response response) {
        this.code = code;
        this.elapsedTime = elapsedTime;
        this.message = message;
        this.request = request;
        this.response = response;
    }

    public int getCode() {
        return this.code;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getMessage() {
        return this.message;
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public TestStepResult buildTestStepResult() {
        TestStepResult result = new TestStepResult();
        result.setElapsedTime(this.elapsedTime);
        result.setRequestName(this.request.getName());
        result.setSuccess(this.code == 0);
        result.setMessage(this.message);
        return result;
    }
}

