/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.DailyStatistic;
import io.github.microcks.repository.CustomDailyStatisticRepository;
import io.github.microcks.repository.DailyStatisticRepository;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class InvocationController {
    private static Logger log = LoggerFactory.getLogger(InvocationController.class);
    @Autowired
    private DailyStatisticRepository repository;

    @RequestMapping(value={"/invocations/global"}, method={RequestMethod.GET})
    public DailyStatistic getInvocationStatGlobal(@RequestParam(value="day", required=false) String day) {
        log.debug("Getting invocations stats for day {}", (Object)day);
        if (day == null) {
            day = this.getTodaysDate();
        }
        return this.repository.aggregateDailyStatistics(day);
    }

    @RequestMapping(value={"/invocations/top"}, method={RequestMethod.GET})
    public List<DailyStatistic> getInvocationTopStats(@RequestParam(value="day", required=false) String day, @RequestParam(value="limit", required=false, defaultValue="20") Integer limit) {
        log.debug("Getting top {} invocations stats for day {}", (Object)limit, (Object)day);
        if (day == null) {
            day = this.getTodaysDate();
        }
        return this.repository.findTopStatistics(day, limit);
    }

    @RequestMapping(value={"/invocations/{service}/{version}"}, method={RequestMethod.GET})
    public DailyStatistic getInvocationStatForService(@PathVariable(value="service") String serviceName, @PathVariable(value="version") String serviceVersion, @RequestParam(value="day", required=false) String day) {
        log.debug("Getting invocations stats for service [{}, {}] and day {}", new Object[]{serviceName, serviceVersion, day});
        if (day == null) {
            day = this.getTodaysDate();
        }
        return this.repository.findByDayAndServiceNameAndServiceVersion(day, serviceName, serviceVersion);
    }

    @RequestMapping(value={"/invocations/global/last"}, method={RequestMethod.GET})
    public Map<String, Long> getLastInvocationStatGlobal(@RequestParam(value="limit", required=false, defaultValue="20") Integer limit) {
        log.debug("Getting invocations stats for last {} days", (Object)limit);
        String day = this.getTodaysDate();
        String dayBefore = this.getPastDate(limit);
        TreeMap<String, Long> invocations = new TreeMap<String, Long>();
        List results = this.repository.aggregateDailyStatistics(dayBefore, day);
        for (CustomDailyStatisticRepository.InvocationCount count : results) {
            invocations.put(count.getDay(), count.getNumber());
        }
        return invocations;
    }

    private String getTodaysDate() {
        Calendar calendar = Calendar.getInstance();
        int month = calendar.get(2) + 1;
        String monthStr = (month < 10 ? "0" : "") + String.valueOf(month);
        int dayOfMonth = calendar.get(5);
        String dayOfMonthStr = (dayOfMonth < 10 ? "0" : "") + String.valueOf(dayOfMonth);
        return String.valueOf(calendar.get(1)) + monthStr + dayOfMonthStr;
    }

    private String getPastDate(Integer daysback) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -daysback.intValue());
        int month = calendar.get(2) + 1;
        String monthStr = (month < 10 ? "0" : "") + String.valueOf(month);
        int dayOfMonth = calendar.get(5);
        String dayOfMonthStr = (dayOfMonth < 10 ? "0" : "") + String.valueOf(dayOfMonth);
        return String.valueOf(calendar.get(1)) + monthStr + dayOfMonthStr;
    }
}

