/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.ServiceRef;
import io.github.microcks.repository.ImportJobRepository;
import io.github.microcks.repository.SecretRepository;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.MockRepositoryImportException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JobService {
    private static Logger log = LoggerFactory.getLogger(JobService.class);
    @Autowired
    private ImportJobRepository jobRepository;
    @Autowired
    private SecretRepository secretRepository;
    @Autowired
    private ServiceService serviceService;

    public void doImportJob(ImportJob job) {
        log.info("Starting import for job '{}'", (Object)job.getName());
        Secret jobSecret = null;
        if (job.getSecretRef() != null) {
            log.debug("Retrieving secret {} for job {}", (Object)job.getSecretRef().getName(), (Object)job.getName());
            jobSecret = this.secretRepository.findById(job.getSecretRef().getSecretId()).orElse(null);
        }
        job.setServiceRefs(null);
        job.setLastImportError(null);
        List<io.github.microcks.domain.Service> services = null;
        try {
            services = this.serviceService.importServiceDefinition(job.getRepositoryUrl(), jobSecret, job.isRepositoryDisableSSLValidation());
        }
        catch (MockRepositoryImportException mrie) {
            log.warn("MockRepositoryImportException while importing job '{}' : {}", (Object)job.getName(), (Object)mrie.getMessage());
            job.setLastImportError(mrie.getMessage());
        }
        if (services != null) {
            for (io.github.microcks.domain.Service service : services) {
                job.addServiceRef(new ServiceRef(service.getId(), service.getName(), service.getVersion()));
            }
        }
        job.setLastImportDate(new Date());
        this.jobRepository.save(job);
        log.info("Import of job '{}' done", (Object)job.getName());
    }
}

