/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.config;

import com.mongodb.WriteConcern;
import io.github.microcks.domain.ServiceState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.WriteConcernResolver;
import org.springframework.data.mongodb.core.index.IndexOperations;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexResolver;

@Configuration
public class MongoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MongoConfiguration.class);
    MongoTemplate mongoTemplate;

    MongoConfiguration(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void initIndicesAfterStartup() {
        log.info("Ensuring TTL index for ServiceState");
        MappingContext mappingContext = this.mongoTemplate.getConverter().getMappingContext();
        MongoPersistentEntityIndexResolver resolver = new MongoPersistentEntityIndexResolver(mappingContext);
        IndexOperations indexOps = this.mongoTemplate.indexOps(ServiceState.class);
        resolver.resolveIndexFor(ServiceState.class).forEach(arg_0 -> ((IndexOperations)indexOps).ensureIndex(arg_0));
    }

    @Bean
    public WriteConcernResolver writeConcernResolver() {
        return action -> {
            log.info("Using Write Concern of Acknowledged");
            return WriteConcern.ACKNOWLEDGED;
        };
    }
}

