/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import io.github.microcks.domain.Binding;
import io.github.microcks.domain.BindingType;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.ParameterConstraint;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.event.ChangeType;
import io.github.microcks.event.ServiceChangeEvent;
import io.github.microcks.repository.EventMessageRepository;
import io.github.microcks.repository.RequestRepository;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.repository.TestResultRepository;
import io.github.microcks.util.EntityAlreadyExistsException;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.MockRepositoryImporterFactory;
import io.github.microcks.util.ReferenceResolver;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Service;

@Service
public class ServiceService {
    private static Logger log = LoggerFactory.getLogger(ServiceService.class);
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private RequestRepository requestRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private EventMessageRepository eventMessageRepository;
    @Autowired
    private TestResultRepository testResultRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${async-api.default-binding}")
    private final String defaultAsyncBinding;
    @Value(value="${async-api.default-frequency}")
    private final Long defaultAsyncFrequency = 30L;

    public ServiceService() {
        this.defaultAsyncBinding = null;
    }

    public List<io.github.microcks.domain.Service> importServiceDefinition(String repositoryUrl, Secret repositorySecret, boolean disableSSLValidation) throws MockRepositoryImportException {
        log.info("Importing service definitions from " + repositoryUrl);
        File localFile = null;
        if (repositoryUrl.startsWith("http")) {
            try {
                localFile = HTTPDownloader.handleHTTPDownloadToFile(repositoryUrl, repositorySecret, disableSSLValidation);
            }
            catch (IOException ioe) {
                log.error("Exception while downloading " + repositoryUrl, (Throwable)ioe);
                throw new MockRepositoryImportException(repositoryUrl + " cannot be downloaded", ioe);
            }
        } else {
            localFile = new File(repositoryUrl);
        }
        ReferenceResolver referenceResolver = new ReferenceResolver(repositoryUrl.substring(0, repositoryUrl.lastIndexOf("/")), repositorySecret, disableSSLValidation);
        return this.importServiceDefinition(localFile, referenceResolver);
    }

    public List<io.github.microcks.domain.Service> importServiceDefinition(File repositoryFile, ReferenceResolver referenceResolver) throws MockRepositoryImportException {
        MockRepositoryImporter importer = null;
        try {
            importer = MockRepositoryImporterFactory.getMockRepositoryImporter(repositoryFile, referenceResolver);
        }
        catch (IOException ioe) {
            log.error("Exception while accessing file " + repositoryFile.getPath(), (Throwable)ioe);
            throw new MockRepositoryImportException(ioe.getMessage(), ioe);
        }
        boolean serviceUpdate = false;
        List<io.github.microcks.domain.Service> services = importer.getServiceDefinitions();
        for (io.github.microcks.domain.Service service : services) {
            io.github.microcks.domain.Service existingService = this.serviceRepository.findByNameAndVersion(service.getName(), service.getVersion());
            log.debug("Service [{}, {}] exists ? {}", new Object[]{service.getName(), service.getVersion(), existingService != null});
            if (existingService != null) {
                service.setId(existingService.getId());
                service.setMetadata(existingService.getMetadata());
                this.copyOverridenOperations(existingService, service);
                serviceUpdate = true;
            }
            if (service.getMetadata() == null) {
                service.setMetadata(new Metadata());
            }
            if (service.getType().equals((Object)ServiceType.EVENT)) {
                for (Operation operation : service.getOperations()) {
                    if (operation.getDefaultDelay() == null) {
                        operation.setDefaultDelay(this.defaultAsyncFrequency);
                    }
                    if (operation.getBindings() != null && !operation.getBindings().isEmpty()) continue;
                    operation.addBinding(this.defaultAsyncBinding, new Binding(BindingType.valueOf((String)this.defaultAsyncBinding)));
                }
            }
            service.getMetadata().objectUpdated();
            service = (io.github.microcks.domain.Service)this.serviceRepository.save(service);
            List<Resource> existingResources = this.resourceRepository.findByServiceId(service.getId());
            if (existingResources != null && existingResources.size() > 0) {
                this.resourceRepository.deleteAll(existingResources);
            }
            List<Resource> resources = importer.getResourceDefinitions(service);
            for (Resource resource : resources) {
                resource.setServiceId(service.getId());
            }
            this.resourceRepository.saveAll(resources);
            for (Operation operation : service.getOperations()) {
                String operationId = IdBuilder.buildOperationId((io.github.microcks.domain.Service)service, (Operation)operation);
                this.requestRepository.deleteAll(this.requestRepository.findByOperationId(operationId));
                this.responseRepository.deleteAll(this.responseRepository.findByOperationId(operationId));
                this.eventMessageRepository.deleteAll(this.eventMessageRepository.findByOperationId(operationId));
                List<Exchange> exchanges = importer.getMessageDefinitions(service, operation);
                for (Exchange exchange : exchanges) {
                    if (exchange instanceof RequestResponsePair) {
                        RequestResponsePair pair = (RequestResponsePair)exchange;
                        pair.getRequest().setOperationId(operationId);
                        pair.getResponse().setOperationId(operationId);
                        this.responseRepository.save(pair.getResponse());
                        pair.getRequest().setResponseId(pair.getResponse().getId());
                        this.requestRepository.save(pair.getRequest());
                        continue;
                    }
                    if (!(exchange instanceof UnidirectionalEvent)) continue;
                    UnidirectionalEvent event = (UnidirectionalEvent)exchange;
                    event.getEventMessage().setOperationId(operationId);
                    this.eventMessageRepository.save(event.getEventMessage());
                }
            }
            this.serviceRepository.save(service);
            this.publishServiceChangeEvent(service, serviceUpdate ? ChangeType.UPDATED : ChangeType.CREATED);
        }
        log.info("Having imported {} services definitions into repository", (Object)services.size());
        return services;
    }

    public io.github.microcks.domain.Service createGenericResourceService(String name, String version, String resource) throws EntityAlreadyExistsException {
        log.info("Creating a new Service '{}-{}' for generic resource {}", new Object[]{name, version, resource});
        io.github.microcks.domain.Service existingService = this.serviceRepository.findByNameAndVersion(name, version);
        if (existingService != null) {
            log.warn("A Service '{}-{}' is already existing. Throwing an Exception", (Object)name, (Object)version);
            throw new EntityAlreadyExistsException(String.format("Service '%s-%s' is already present in store", name, version));
        }
        io.github.microcks.domain.Service service = new io.github.microcks.domain.Service();
        service.setName(name);
        service.setVersion(version);
        service.setType(ServiceType.GENERIC_REST);
        service.setMetadata(new Metadata());
        Operation createOp = new Operation();
        createOp.setName("POST /" + resource);
        createOp.setMethod("POST");
        service.addOperation(createOp);
        Operation getOp = new Operation();
        getOp.setName("GET /" + resource + "/:id");
        getOp.setMethod("GET");
        getOp.setDispatcher("URI_PARTS");
        getOp.setDispatcherRules("id");
        service.addOperation(getOp);
        Operation updateOp = new Operation();
        updateOp.setName("PUT /" + resource + "/:id");
        updateOp.setMethod("PUT");
        updateOp.setDispatcher("URI_PARTS");
        updateOp.setDispatcherRules("id");
        service.addOperation(updateOp);
        Operation listOp = new Operation();
        listOp.setName("GET /" + resource);
        listOp.setMethod("GET");
        service.addOperation(listOp);
        Operation delOp = new Operation();
        delOp.setName("DELETE /" + resource + "/:id");
        delOp.setMethod("DELETE");
        delOp.setDispatcher("URI_PARTS");
        delOp.setDispatcherRules("id");
        service.addOperation(delOp);
        this.serviceRepository.save(service);
        log.info("Having create Service '{}' for generic resource {}", (Object)service.getId(), (Object)resource);
        return service;
    }

    public void deleteService(String id) {
        io.github.microcks.domain.Service service = this.serviceRepository.findById(id).orElse(null);
        this.resourceRepository.deleteAll(this.resourceRepository.findByServiceId(id));
        if (service != null) {
            for (Operation operation : service.getOperations()) {
                String operationId = IdBuilder.buildOperationId((io.github.microcks.domain.Service)service, (Operation)operation);
                this.requestRepository.deleteAll(this.requestRepository.findByOperationId(operationId));
                this.responseRepository.deleteAll(this.responseRepository.findByOperationId(operationId));
            }
        }
        this.testResultRepository.deleteAll(this.testResultRepository.findByServiceId(id));
        this.serviceRepository.delete(service);
        this.publishServiceChangeEvent(service, ChangeType.DELETED);
        log.info("Service [{}] has been fully deleted", (Object)id);
    }

    public Boolean updateMetadata(String id, Metadata metadata) {
        io.github.microcks.domain.Service service = this.serviceRepository.findById(id).orElse(null);
        if (service != null) {
            service.getMetadata().setLabels(metadata.getLabels());
            service.getMetadata().setAnnotations(metadata.getAnnotations());
            service.getMetadata().objectUpdated();
            this.serviceRepository.save(service);
            return true;
        }
        return false;
    }

    public Boolean updateOperation(String id, String operationName, String dispatcher, String dispatcherRules, Long delay, List<ParameterConstraint> constraints) {
        io.github.microcks.domain.Service service = this.serviceRepository.findById(id).orElse(null);
        if (service != null) {
            for (Operation operation : service.getOperations()) {
                if (!operation.getName().equals(operationName)) continue;
                operation.setDispatcher(dispatcher);
                operation.setDispatcherRules(dispatcherRules);
                operation.setParameterConstraints(constraints);
                operation.setDefaultDelay(delay);
                operation.setOverride(true);
                this.serviceRepository.save(service);
                this.publishServiceChangeEvent(service, ChangeType.UPDATED);
                return true;
            }
        }
        return false;
    }

    private void copyOverridenOperations(io.github.microcks.domain.Service existingService, io.github.microcks.domain.Service newService) {
        for (Operation existingOperation : existingService.getOperations()) {
            if (!existingOperation.hasOverride()) continue;
            for (Operation op : newService.getOperations()) {
                if (!existingOperation.getName().equals(op.getName())) continue;
                op.setDefaultDelay(existingOperation.getDefaultDelay());
                op.setDispatcher(existingOperation.getDispatcher());
                op.setDispatcherRules(existingOperation.getDispatcherRules());
                op.setParameterConstraints(existingOperation.getParameterConstraints());
                op.setOverride(true);
            }
        }
    }

    private void publishServiceChangeEvent(io.github.microcks.domain.Service service, ChangeType changeType) {
        ServiceChangeEvent event = new ServiceChangeEvent(this, service.getId(), changeType);
        this.applicationContext.publishEvent((ApplicationEvent)event);
        log.debug("Service change event has been published");
    }
}

