/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.domain.Secret;
import io.github.microcks.util.HTTPDownloader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceResolver {
    private static Logger log = LoggerFactory.getLogger(ReferenceResolver.class);
    private String baseRepositoryUrl;
    private Secret repositorySecret;
    private boolean disableSSLValidation;
    private Map<String, File> resolvedReferences = new HashMap<String, File>();

    public ReferenceResolver(String baseRepositoryUrl, Secret repositorySecret, boolean disableSSLValidation) {
        this.repositorySecret = repositorySecret;
        this.disableSSLValidation = disableSSLValidation;
        this.baseRepositoryUrl = baseRepositoryUrl.endsWith("/") ? baseRepositoryUrl.substring(0, baseRepositoryUrl.length() - 1) : baseRepositoryUrl;
    }

    public String getHttpReferenceContent(String relativePath, String encoding) throws IOException {
        File referenceFile = this.resolvedReferences.get(relativePath);
        if (referenceFile == null) {
            Object remoteUrl = this.baseRepositoryUrl;
            String pathToAppend = relativePath;
            while (pathToAppend.startsWith("../")) {
                remoteUrl = ((String)remoteUrl).substring(0, ((String)remoteUrl).lastIndexOf("/"));
                pathToAppend = pathToAppend.substring(3);
            }
            if (pathToAppend.startsWith("./")) {
                pathToAppend = pathToAppend.substring(2);
            }
            if (pathToAppend.startsWith("/")) {
                pathToAppend = pathToAppend.substring(1);
            }
            remoteUrl = (String)remoteUrl + "/" + pathToAppend;
            log.info("Downloading a reference file at {}", remoteUrl);
            referenceFile = HTTPDownloader.handleHTTPDownloadToFile((String)remoteUrl, this.repositorySecret, this.disableSSLValidation);
            this.resolvedReferences.put(relativePath, referenceFile);
        }
        return Files.readString(referenceFile.toPath(), Charset.forName(encoding));
    }

    public void cleanResolvedReferences() {
        for (File referenceFile : this.resolvedReferences.values()) {
            referenceFile.delete();
        }
        this.resolvedReferences.clear();
    }
}

