/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.repository.ImportJobRepository;
import io.github.microcks.service.JobService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class JobController {
    private static Logger log = LoggerFactory.getLogger(JobController.class);
    @Autowired
    private ImportJobRepository jobRepository;
    @Autowired
    private JobService jobService;

    @RequestMapping(value={"/jobs"}, method={RequestMethod.GET})
    public List<ImportJob> listJobs(@RequestParam(value="page", required=false, defaultValue="0") int page, @RequestParam(value="size", required=false, defaultValue="20") int size, @RequestParam(value="name", required=false) String name) {
        log.debug("Getting job list for page {} and size {}", (Object)page, (Object)size);
        if (name != null) {
            return this.jobRepository.findByNameLike(name);
        }
        return this.jobRepository.findAll((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"name"}))).getContent();
    }

    @RequestMapping(value={"/jobs/count"}, method={RequestMethod.GET})
    public Map<String, Long> countJobs() {
        log.debug("Counting jobs...");
        HashMap<String, Long> counter = new HashMap<String, Long>();
        counter.put("counter", this.jobRepository.count());
        return counter;
    }

    @RequestMapping(value={"/jobs"}, method={RequestMethod.POST})
    public ResponseEntity<ImportJob> createJob(@RequestBody ImportJob job) {
        log.debug("Creating new job: {}", (Object)job);
        job.setCreatedDate(new Date());
        return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.CREATED);
    }

    @RequestMapping(value={"/jobs/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<ImportJob> getJob(@PathVariable(value="id") String jobId) {
        log.debug("Retrieving job with id {}", (Object)jobId);
        return new ResponseEntity((Object)this.jobRepository.findById(jobId).orElse(null), HttpStatus.OK);
    }

    @RequestMapping(value={"/jobs/{id}"}, method={RequestMethod.POST})
    public ResponseEntity<ImportJob> saveJob(@RequestBody ImportJob job) {
        log.debug("Saving existing job: {}", (Object)job);
        return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.OK);
    }

    @RequestMapping(value={"/jobs/{id}/activate"}, method={RequestMethod.PUT})
    public ResponseEntity<ImportJob> activateJob(@PathVariable(value="id") String jobId) {
        log.debug("Activating job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        job.setActive(true);
        return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.OK);
    }

    @RequestMapping(value={"/jobs/{id}/start"}, method={RequestMethod.PUT})
    public ResponseEntity<ImportJob> startJob(@PathVariable(value="id") String jobId) {
        log.debug("Starting job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        job.setActive(true);
        this.jobService.doImportJob(job);
        return new ResponseEntity((Object)job, HttpStatus.OK);
    }

    @RequestMapping(value={"/jobs/{id}/stop"}, method={RequestMethod.PUT})
    public ResponseEntity<ImportJob> stopJob(@PathVariable(value="id") String jobId) {
        log.debug("Stopping job with id {}", (Object)jobId);
        ImportJob job = this.jobRepository.findById(jobId).orElse(null);
        job.setActive(false);
        return new ResponseEntity((Object)((ImportJob)this.jobRepository.save(job)), HttpStatus.OK);
    }

    @RequestMapping(value={"/jobs/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<String> deleteJob(@PathVariable(value="id") String jobId) {
        log.debug("Removing job with id {}", (Object)jobId);
        this.jobRepository.deleteById(jobId);
        return new ResponseEntity(HttpStatus.OK);
    }
}

