/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/keycloak"})
public class KeycloakConfigController {
    private static Logger log = LoggerFactory.getLogger(KeycloakConfigController.class);
    @Value(value="${sso.public-url}")
    private final String keycloakServerUrl;
    @Value(value="${keycloak.realm}")
    private final String keycloakRealmName;

    public KeycloakConfigController() {
        this.keycloakServerUrl = null;
        this.keycloakRealmName = null;
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.GET})
    public ResponseEntity<?> getConfig() {
        Config config = new Config(this.keycloakRealmName, this.keycloakServerUrl);
        log.debug("Returning '{}' realm config, for {}", (Object)this.keycloakRealmName, (Object)this.keycloakServerUrl);
        return new ResponseEntity((Object)config, HttpStatus.OK);
    }

    private class Config {
        private String realm = "microcks";
        @JsonProperty(value="auth-server-url")
        private String authServerUrl = "http://localhost:8180/auth";
        @JsonProperty(value="ssl-required")
        private final String sslRequired = "external";
        @JsonProperty(value="public-client")
        private final boolean publicClient = true;
        private final String resource = "microcks-app-js";

        public Config(String realmName, String authServerUrl) {
            if (realmName != null && !this.realm.isEmpty()) {
                this.realm = realmName;
            }
            if (authServerUrl != null && !authServerUrl.isEmpty()) {
                this.authServerUrl = authServerUrl;
            }
        }

        public String getRealm() {
            return this.realm;
        }

        public String getAuthServerUrl() {
            return this.authServerUrl;
        }

        public String getSslRequired() {
            return "external";
        }

        public boolean isPublicClient() {
            return true;
        }

        public String getResource() {
            return "microcks-app-js";
        }
    }
}

