/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui;

import com.eviware.soapui.impl.support.http.HttpRequestTestStep;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.impl.wsdl.teststeps.RestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStepResult;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.types.StringToObjectMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.util.test.AbstractTestRunner;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class SoapUITestStepsRunner
extends AbstractTestRunner<HttpMethod> {
    private static Logger log = LoggerFactory.getLogger(SoapUITestStepsRunner.class);
    private WsdlProject project;

    public SoapUITestStepsRunner(String projectFilePath) throws IOException {
        try {
            this.project = new WsdlProject(projectFilePath);
        }
        catch (Exception e) {
            throw new IOException("SoapUI project file cannot be found or accessed");
        }
    }

    @Override
    public List<TestReturn> runTest(Service service, Operation operation, TestResult testResult, List<Request> requests, String endpointUrl, HttpMethod method) throws URISyntaxException, IOException {
        return this.runAllTestSteps(endpointUrl);
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return null;
    }

    public List<TestReturn> runAllTestSteps(String endpointUrl) {
        return this.runTestSteps(endpointUrl, null);
    }

    public List<TestReturn> runTestSteps(String endpointUrl, List<String> testStepNames) {
        ProxyUtils.setProxyEnabled((boolean)false);
        ArrayList<TestReturn> results = new ArrayList<TestReturn>();
        for (TestSuite testSuite : this.project.getTestSuiteList()) {
            for (TestCase testCase : testSuite.getTestCaseList()) {
                TestCaseRunner testCaseRunner = this.buildTestCaseRunner(testCase);
                if (testCaseRunner == null) continue;
                for (TestStep testStep : testCase.getTestStepList()) {
                    if (!(testStep instanceof HttpRequestTestStep) || testStepNames != null && !testStepNames.contains(testStep.getName())) continue;
                    log.debug("Picking up step " + testStep.getName() + " for running SoapUI test");
                    ((HttpRequestTestStep)testStep).getHttpRequest().setEndpoint(endpointUrl);
                    TestStepResult result = testStep.run(testCaseRunner, testCaseRunner.getRunContext());
                    log.debug("SoapUI test result is " + result.getStatus());
                    results.add(this.extractTestReturn(testStep.getName(), result));
                }
            }
        }
        return results;
    }

    private TestCaseRunner buildTestCaseRunner(TestCase testCase) {
        if (testCase instanceof WsdlTestCase) {
            return new WsdlTestCaseRunner((WsdlTestCase)testCase, new StringToObjectMap());
        }
        return null;
    }

    private TestReturn extractTestReturn(String testStepName, TestStepResult result) {
        int code = 1;
        if (result.getStatus() == TestStepResult.TestStepStatus.OK) {
            code = 0;
        }
        String message = null;
        Request request = new Request();
        request.setName(testStepName);
        Response response = new Response();
        if (result instanceof WsdlTestRequestStepResult) {
            WsdlTestRequestStepResult wtrsr = (WsdlTestRequestStepResult)result;
            request.setContent(wtrsr.getRequestContent());
            request.setHeaders(this.buildHeaders(wtrsr.getRequestHeaders()));
            response.setContent(wtrsr.getResponseContent());
            response.setHeaders(this.buildHeaders(wtrsr.getResponseHeaders()));
            message = this.buildConsolidatedMessage(wtrsr.getMessages());
        }
        if (result instanceof RestRequestStepResult) {
            RestRequestStepResult rrsr = (RestRequestStepResult)result;
            request.setContent(rrsr.getRequestContent());
            request.setHeaders(this.buildHeaders(rrsr.getRequestHeaders()));
            response.setContent(rrsr.getResponseContent());
            response.setHeaders(this.buildHeaders(rrsr.getResponseHeaders()));
            message = this.buildConsolidatedMessage(rrsr.getMessages());
            if (result.getStatus() == TestStepResult.TestStepStatus.UNKNOWN) {
                code = rrsr.getResponse().getStatusCode() == 404 ? 1 : 0;
            }
        }
        return new TestReturn(code, result.getTimeTaken(), message, request, response);
    }

    private Set<Header> buildHeaders(StringToStringsMap headers) {
        if (headers != null && headers.size() > 0) {
            HashSet<Header> results = new HashSet<Header>();
            for (Map.Entry entry : headers.entrySet()) {
                Header header = new Header();
                header.setName((String)entry.getKey());
                header.setValues(new HashSet((Collection)entry.getValue()));
                results.add(header);
            }
            return results;
        }
        return null;
    }

    private String buildConsolidatedMessage(String[] messages) {
        if (messages == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (String message : messages) {
            result.append(message);
            result.append("<br/>").append(" ================ ").append("<br/>");
        }
        return result.toString();
    }
}

