/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.dispatcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.microcks.util.dispatcher.DispatchCases;
import io.github.microcks.util.dispatcher.JsonEvaluationSpecification;
import io.github.microcks.util.dispatcher.JsonMappingException;
import java.io.Reader;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonExpressionEvaluator {
    private static Logger log = LoggerFactory.getLogger(JsonExpressionEvaluator.class);

    public static String evaluate(String jsonText, JsonEvaluationSpecification specification) throws JsonMappingException {
        JsonNode rootNode;
        try {
            ObjectMapper mapper = new ObjectMapper();
            rootNode = mapper.readTree((Reader)new StringReader(jsonText));
        }
        catch (Exception e) {
            log.error("Exception while parsing Json text", (Throwable)e);
            throw new JsonMappingException("Exception while parsing Json payload");
        }
        JsonNode evaluatedNode = rootNode.at(specification.getExp());
        String caseKey = evaluatedNode.asText();
        switch (specification.getOperator()) {
            case equals: {
                String value = (String)specification.getCases().get(caseKey);
                return value != null ? value : specification.getCases().getDefault();
            }
            case range: {
                double caseNumber = 0.0;
                try {
                    caseNumber = Double.parseDouble(caseKey);
                }
                catch (NumberFormatException nfe) {
                    log.error(caseKey + " into range expression cannot be parsed as number. Considering default case.");
                    return specification.getCases().getDefault();
                }
                return JsonExpressionEvaluator.foundRangeMatchingCase(caseNumber, specification.getCases());
            }
            case regexp: {
                for (String choiceKey : specification.getCases().keySet()) {
                    if ("default".equals(choiceKey) || !Pattern.matches(choiceKey, caseKey)) continue;
                    return (String)specification.getCases().get(choiceKey);
                }
                break;
            }
            case size: {
                if (!evaluatedNode.isArray()) break;
                int size = evaluatedNode.size();
                return JsonExpressionEvaluator.foundRangeMatchingCase(size, specification.getCases());
            }
            case presence: {
                if (caseKey != null && caseKey.length() > 0) {
                    if (!specification.getCases().containsKey("found")) break;
                    return (String)specification.getCases().get("found");
                }
                if (!specification.getCases().containsKey("missing")) break;
                return (String)specification.getCases().get("missing");
            }
        }
        return specification.getCases().getDefault();
    }

    private static String foundRangeMatchingCase(double caseNumber, DispatchCases dispatchCases) {
        for (String choiceKey : dispatchCases.keySet()) {
            boolean match = false;
            if (JsonExpressionEvaluator.isValidRangeKey(choiceKey)) {
                try {
                    double[] minAndMax = JsonExpressionEvaluator.extractMinAndMaxFromRange(choiceKey);
                    if (choiceKey.startsWith("[") && choiceKey.endsWith("]")) {
                        if (caseNumber >= minAndMax[0] && caseNumber <= minAndMax[1]) {
                            match = true;
                        }
                    } else if (choiceKey.startsWith("]") && choiceKey.endsWith("]")) {
                        if (caseNumber > minAndMax[0] && caseNumber <= minAndMax[1]) {
                            match = true;
                        }
                    } else if (choiceKey.startsWith("[") && choiceKey.endsWith("[")) {
                        if (caseNumber >= minAndMax[0] && caseNumber < minAndMax[1]) {
                            match = true;
                        }
                    } else if (choiceKey.startsWith("]") && choiceKey.endsWith("[") && caseNumber > minAndMax[0] && caseNumber < minAndMax[1]) {
                        match = true;
                    }
                }
                catch (NumberFormatException nfe) {
                    log.warn(choiceKey + " expression cannot be parsed as number for min and max range.");
                }
            }
            if (!match) continue;
            return (String)dispatchCases.get(choiceKey);
        }
        return dispatchCases.getDefault();
    }

    private static boolean isValidRangeKey(String key) {
        boolean hasCorrectStart = key.startsWith("[") || key.startsWith("]");
        boolean hasCorrectEnd = key.endsWith("[") || key.endsWith("]");
        boolean hasDelimiter = key.contains(";");
        return hasCorrectStart && hasDelimiter && hasCorrectEnd;
    }

    private static double[] extractMinAndMaxFromRange(String range) throws NumberFormatException {
        double[] results = new double[2];
        String[] minAndMax = range.split(";");
        results[0] = Double.parseDouble(minAndMax[0].substring(1));
        results[1] = Double.parseDouble(minAndMax[1].substring(0, minAndMax[1].length() - 1));
        return results;
    }
}

