/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import com.github.os72.protocjar.Protoc;
import com.google.protobuf.DescriptorProtos;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.ReferenceResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufImporter
implements MockRepositoryImporter {
    private static final Logger log = LoggerFactory.getLogger(ProtobufImporter.class);
    private String specContent;
    private String protoDirectory;
    private String protoFileName;
    private ReferenceResolver referenceResolver;
    private DescriptorProtos.FileDescriptorSet fds;
    private static final String BINARY_DESCRIPTOR_EXT = ".pbb";

    public ProtobufImporter(String protoFilePath, ReferenceResolver referenceResolver) throws IOException {
        this.referenceResolver = referenceResolver;
        File protoFile = new File(protoFilePath);
        this.protoDirectory = protoFile.getParentFile().getAbsolutePath();
        this.protoFileName = protoFile.getName();
        String[] args = new String[]{"-v3.11.4", "--include_std_types", "--include_imports", "--proto_path=" + this.protoDirectory, "--descriptor_set_out=" + this.protoDirectory + "/" + this.protoFileName + BINARY_DESCRIPTOR_EXT, this.protoFileName};
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(protoFilePath, new String[0]));
            this.specContent = new String(bytes, Charset.forName("UTF-8"));
            ArrayList<File> resolvedImportsLocalFiles = null;
            if (referenceResolver != null) {
                resolvedImportsLocalFiles = new ArrayList<File>();
                this.resolveAndPrepareRemoteImports(Paths.get(protoFilePath, new String[0]), resolvedImportsLocalFiles);
            }
            int result = Protoc.runProtoc((String[])args);
            File protoFileB = new File(this.protoDirectory + "/" + this.protoFileName + BINARY_DESCRIPTOR_EXT);
            this.fds = DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)new FileInputStream(protoFileB));
            if (resolvedImportsLocalFiles != null) {
                resolvedImportsLocalFiles.forEach(f -> f.delete());
            }
        }
        catch (Exception e) {
            log.error("Exception while parsing Protobuf schema file " + protoFilePath, (Throwable)e);
            throw new IOException("Protobuf schema file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> results = new ArrayList<Service>();
        for (DescriptorProtos.FileDescriptorProto fdp : this.fds.getFileList()) {
            String packageName = fdp.getPackage();
            String[] parts = packageName.split("\\.");
            String version = parts.length > 2 ? parts[parts.length - 1] : packageName;
            for (DescriptorProtos.ServiceDescriptorProto sdp : fdp.getServiceList()) {
                Service service = new Service();
                service.setName(sdp.getName());
                service.setVersion(version);
                service.setType(ServiceType.GRPC);
                service.setXmlNS(packageName);
                service.setOperations(this.extractOperations(sdp));
                results.add(service);
            }
        }
        return results;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) throws MockRepositoryImportException {
        ArrayList<Resource> results = new ArrayList<Resource>();
        Resource textResource = new Resource();
        textResource.setName(service.getName() + "-" + service.getVersion() + ".proto");
        textResource.setType(ResourceType.PROTOBUF_SCHEMA);
        textResource.setContent(this.specContent);
        results.add(textResource);
        try {
            byte[] binaryPB = Files.readAllBytes(Path.of(this.protoDirectory, this.protoFileName + BINARY_DESCRIPTOR_EXT));
            String base64PB = new String(Base64.getEncoder().encode(binaryPB), "UTF-8");
            Resource descResource = new Resource();
            descResource.setName(service.getName() + "-" + service.getVersion() + BINARY_DESCRIPTOR_EXT);
            descResource.setType(ResourceType.PROTOBUF_DESCRIPTOR);
            descResource.setContent(base64PB);
            results.add(descResource);
        }
        catch (Exception e) {
            log.error("Exception while encoding Protobuf binary descriptor into base64", (Throwable)e);
            throw new MockRepositoryImportException("Exception while encoding Protobuf binary descriptor into base64");
        }
        if (this.referenceResolver != null) {
            this.referenceResolver.getResolvedReferences().forEach((p, f) -> {
                Resource protoResource = new Resource();
                protoResource.setName(service.getName() + "-" + service.getVersion() + "-" + p.replaceAll("/", "~1"));
                protoResource.setType(ResourceType.PROTOBUF_SCHEMA);
                protoResource.setPath(p);
                try {
                    protoResource.setContent(Files.readString(f.toPath(), Charset.forName("UTF-8")));
                }
                catch (IOException ioe) {
                    log.error("", (Throwable)ioe);
                }
                results.add(protoResource);
            });
            this.referenceResolver.cleanResolvedReferences();
        }
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> result = new ArrayList<Exchange>();
        return result;
    }

    private void resolveAndPrepareRemoteImports(Path protoFilePath, List<File> resolvedImportsLocalFiles) {
        String line = null;
        try {
            BufferedReader reader = Files.newBufferedReader(protoFilePath, Charset.forName("UTF-8"));
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("import ")) continue;
                String importStr = line.substring("import ".length() + 1);
                if (importStr.endsWith(";")) {
                    importStr = importStr.substring(0, importStr.length() - 1);
                }
                if (importStr.endsWith("\"") || importStr.endsWith("'")) {
                    importStr = importStr.substring(0, importStr.length() - 1);
                }
                if (importStr.startsWith("\"") || importStr.startsWith("'")) {
                    importStr = importStr.substring(1);
                }
                log.debug("Found an import to resolve in protobuf: {}", (Object)importStr);
                Path importPath = protoFilePath.getParent().resolve(importStr);
                if (Files.exists(importPath, new LinkOption[0])) continue;
                String importContent = this.referenceResolver.getHttpReferenceContent(importStr, "UTF-8");
                try {
                    Files.createDirectories(importPath.getParent(), new FileAttribute[0]);
                    Files.createFile(importPath, new FileAttribute[0]);
                }
                catch (FileAlreadyExistsException faee) {
                    log.warn("Exception while writing protobuf dependency", (Throwable)faee);
                }
                Files.write(importPath, importContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                resolvedImportsLocalFiles.add(importPath.toFile());
            }
        }
        catch (Exception e) {
            log.error("Exception while retrieving protobuf dependency", (Throwable)e);
        }
    }

    private List<Operation> extractOperations(DescriptorProtos.ServiceDescriptorProto service) {
        ArrayList<Operation> results = new ArrayList<Operation>();
        for (DescriptorProtos.MethodDescriptorProto method : service.getMethodList()) {
            Operation operation = new Operation();
            operation.setName(method.getName());
            operation.setInputName(method.getInputType());
            operation.setOutputName(method.getOutputType());
            results.add(operation);
        }
        return results;
    }
}

