/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.service.ImportExportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api"})
public class ImportController {
    private static Logger log = LoggerFactory.getLogger(ImportController.class);
    @Autowired
    private ImportExportService importExportService;

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public ResponseEntity<?> importRepository(@RequestParam(value="file") MultipartFile file) {
        log.debug("Importing new services and resources definitions");
        if (!file.isEmpty()) {
            log.debug("Content type of " + file.getOriginalFilename() + " is " + file.getContentType());
            if ("application/json".equals(file.getContentType())) {
                try {
                    byte[] bytes = file.getBytes();
                    String json = new String(bytes);
                    this.importExportService.importRepository(json);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
        }
        return new ResponseEntity(HttpStatus.CREATED);
    }
}

