/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.security;

import io.github.microcks.security.KeycloakTokenToUserInfoMapper;
import io.github.microcks.security.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class UserInfoHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static Logger log = LoggerFactory.getLogger(UserInfoHandlerMethodArgumentResolver.class);

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().equals(UserInfo.class);
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        Object userInfoObj = nativeWebRequest.getAttribute(UserInfo.class.getName(), 0);
        if (userInfoObj != null) {
            log.debug("UserInfo is already present into request attribute");
            return UserInfo.class.cast(userInfoObj);
        }
        log.debug("Creating a new UserInfo to resolve {} argument", (Object)methodParameter.getMethod());
        UserInfo userInfo = null;
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext.getAuthentication() != null) {
            log.debug("Found a Spring Security Authentication to map to UserInfo");
            userInfo = KeycloakTokenToUserInfoMapper.map(securityContext);
            nativeWebRequest.setAttribute(UserInfo.class.getName(), (Object)userInfo, 0);
        }
        return userInfo;
    }
}

