/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import io.github.microcks.util.grpc.GrpcUtil;
import io.github.microcks.web.GrpcServerCallHandler;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCallHandler;
import io.grpc.ServerMethodDefinition;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GrpcMockHandlerRegistry
extends HandlerRegistry {
    private static Logger log = LoggerFactory.getLogger(GrpcMockHandlerRegistry.class);
    @Autowired
    private GrpcServerCallHandler serverCallHandler;

    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String fullMethodName, @Nullable String authority) {
        log.debug("lookupMethod() with fullMethodName: " + fullMethodName);
        return ServerMethodDefinition.create(this.mockMethodDescriptor(fullMethodName), this.mockServerCallHandler(fullMethodName));
    }

    protected MethodDescriptor<byte[], byte[]> mockMethodDescriptor(String fullMethodName) {
        return GrpcUtil.buildGenericUnaryMethodDescriptor(fullMethodName);
    }

    protected ServerCallHandler<byte[], byte[]> mockServerCallHandler(String fullMethodName) {
        return this.serverCallHandler.getUnaryServerCallHandler(fullMethodName);
    }
}

