/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import io.github.microcks.util.grpc.GrpcMockHandlerRegistry;
import io.grpc.Grpc;
import io.grpc.HandlerRegistry;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerCredentials;
import io.grpc.TlsServerCredentials;
import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GrpcServerStarter {
    private static Logger log = LoggerFactory.getLogger(GrpcServerStarter.class);
    private static final String BEGIN_RSA_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String END_RSA_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";
    @Value(value="${grpc.server.port:9090}")
    private final Integer serverPort = 9090;
    @Value(value="${grpc.server.certChainFilePath:}")
    private final String certChainFilePath;
    @Value(value="${grpc.server.privateKeyFilePath:}")
    private final String privateKeyFilePath;
    @Autowired
    private GrpcMockHandlerRegistry mockHandlerRegistry;
    private AtomicBoolean isRunning = new AtomicBoolean(false);
    private CountDownLatch latch;

    public GrpcServerStarter() {
        this.certChainFilePath = null;
        this.privateKeyFilePath = null;
    }

    @PostConstruct
    public void startGrpcServer() {
        try {
            this.latch = new CountDownLatch(1);
            Server grpcServer = null;
            if (this.certChainFilePath != null && this.certChainFilePath.length() > 0 && this.privateKeyFilePath != null && this.privateKeyFilePath.length() > 0) {
                TlsServerCredentials.Builder tlsBuilder = TlsServerCredentials.newBuilder().keyManager(new File(this.certChainFilePath), new File(this.privateKeyFilePath));
                try {
                    grpcServer = Grpc.newServerBuilderForPort((int)this.serverPort, (ServerCredentials)tlsBuilder.build()).fallbackHandlerRegistry((HandlerRegistry)this.mockHandlerRegistry).build();
                }
                catch (IllegalArgumentException iae) {
                    if (iae.getCause() instanceof NoSuchAlgorithmException || iae.getCause() instanceof InvalidKeySpecException) {
                        log.warn("GRPC PrivateKey appears to be invalid. Trying to convert it.");
                        byte[] privateKeyBytes = GrpcServerStarter.extractPrivateKeyIfAny(this.privateKeyFilePath);
                        if (privateKeyBytes != null) {
                            log.info("Building a GRPC server with converted key");
                            tlsBuilder = TlsServerCredentials.newBuilder().keyManager((InputStream)new FileInputStream(this.certChainFilePath), (InputStream)new ByteArrayInputStream(privateKeyBytes));
                            grpcServer = Grpc.newServerBuilderForPort((int)this.serverPort, (ServerCredentials)tlsBuilder.build()).fallbackHandlerRegistry((HandlerRegistry)this.mockHandlerRegistry).build();
                        }
                    }
                }
            } else {
                grpcServer = ServerBuilder.forPort((int)this.serverPort).fallbackHandlerRegistry((HandlerRegistry)this.mockHandlerRegistry).build();
            }
            grpcServer.start();
            log.info("GRPC Server started on port " + this.serverPort);
            final Server finalGrpcServer = grpcServer;
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        if (finalGrpcServer != null) {
                            log.info("Shutting down gRPC server since JVM is shutting down");
                            finalGrpcServer.shutdown().awaitTermination(2L, TimeUnit.SECONDS);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
            this.startDaemonAwaitThread();
        }
        catch (Exception e) {
            log.error("GRPC Server cannot be started", (Throwable)e);
        }
    }

    private void startDaemonAwaitThread() {
        Thread awaitThread = new Thread(() -> {
            try {
                this.isRunning.set(true);
                this.latch.await();
            }
            catch (InterruptedException e) {
                log.error("GRPC Server awaiter interrupted.", (Throwable)e);
            }
            finally {
                this.isRunning.set(false);
            }
        });
        awaitThread.setName("grpc-server-awaiter");
        awaitThread.setDaemon(false);
        awaitThread.start();
    }

    private static byte[] extractPrivateKeyIfAny(String privateKeyFilePath) throws IOException {
        String privateKey = new String(Files.readAllBytes(Path.of(privateKeyFilePath, new String[0])), StandardCharsets.UTF_8);
        if (privateKey.startsWith(BEGIN_RSA_PRIVATE_KEY)) {
            PEMParser pemParser = new PEMParser((Reader)new FileReader(privateKeyFilePath));
            Object object = pemParser.readObject();
            pemParser.close();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            PrivateKey privatekey = null;
            log.debug("Parsed PrivateKey: {}", object);
            if (object instanceof PEMKeyPair) {
                privatekey = converter.getPrivateKey(((PEMKeyPair)object).getPrivateKeyInfo());
            }
            if (object instanceof PrivateKeyInfo) {
                privatekey = converter.getPrivateKey((PrivateKeyInfo)object);
            }
            if (privatekey != null) {
                log.debug("Found PrivateKey Algorithm: {}", (Object)privatekey.getAlgorithm());
                log.debug("Found PrivateKey Format: {}", (Object)privatekey.getFormat());
                String privateKeyPem = "-----BEGIN RSA PRIVATE KEY-----\n" + Base64.getEncoder().encodeToString(privatekey.getEncoded()) + "\n-----END RSA PRIVATE KEY-----\n";
                log.debug("New PrivateKey PEM is {}", (Object)privateKeyPem);
                return privateKeyPem.getBytes(StandardCharsets.UTF_8);
            }
        }
        return null;
    }
}

