/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soap.SoapMessageValidator;
import io.github.microcks.util.soapui.assertions.AssertionStatus;
import io.github.microcks.util.soapui.assertions.ExchangeContext;
import io.github.microcks.util.soapui.assertions.RequestResponseExchange;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapResponseAssertion
implements SoapUIAssertion {
    private static Logger log = LoggerFactory.getLogger(SoapResponseAssertion.class);
    private List<String> errorMessages;

    @Override
    public void configure(Map<String, String> configParams) {
    }

    @Override
    public AssertionStatus assertResponse(RequestResponseExchange exchange, ExchangeContext context) {
        log.debug("Asserting response is a SOAP response");
        this.errorMessages = SoapMessageValidator.validateSoapEnvelope((String)exchange.responseContent());
        if (!this.errorMessages.isEmpty()) {
            return AssertionStatus.FAILED;
        }
        return AssertionStatus.VALID;
    }

    @Override
    public List<String> getErrorMessages() {
        return this.errorMessages;
    }
}

