/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.service;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.microcks.domain.Binding;
import io.github.microcks.domain.BindingType;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.GenericResource;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.ParameterConstraint;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Secret;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.event.ChangeType;
import io.github.microcks.event.ServiceChangeEvent;
import io.github.microcks.repository.EventMessageRepository;
import io.github.microcks.repository.GenericResourceRepository;
import io.github.microcks.repository.RequestRepository;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.repository.ResponseRepository;
import io.github.microcks.repository.ServiceRepository;
import io.github.microcks.repository.TestResultRepository;
import io.github.microcks.security.AuthorizationChecker;
import io.github.microcks.security.UserInfo;
import io.github.microcks.service.ArtifactInfo;
import io.github.microcks.util.EntityAlreadyExistsException;
import io.github.microcks.util.HTTPDownloader;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.MockRepositoryImporterFactory;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.RelativeReferenceURLBuilder;
import io.github.microcks.util.RelativeReferenceURLBuilderFactory;
import io.github.microcks.util.ResourceUtil;
import io.github.microcks.util.openapi.OpenAPISchemaBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.json.JsonParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

@org.springframework.stereotype.Service
public class ServiceService {
    private static Logger log = LoggerFactory.getLogger(ServiceService.class);
    private static final String AI_COPILOT_SOURCE = "AI Copilot";
    @Autowired
    private ServiceRepository serviceRepository;
    @Autowired
    private ResourceRepository resourceRepository;
    @Autowired
    private GenericResourceRepository genericResourceRepository;
    @Autowired
    private RequestRepository requestRepository;
    @Autowired
    private ResponseRepository responseRepository;
    @Autowired
    private EventMessageRepository eventMessageRepository;
    @Autowired
    private TestResultRepository testResultRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AuthorizationChecker authorizationChecker;
    @Value(value="${async-api.default-binding}")
    private final String defaultAsyncBinding;
    @Value(value="${async-api.default-frequency}")
    private final Long defaultAsyncFrequency = 30L;

    public ServiceService() {
        this.defaultAsyncBinding = null;
    }

    public List<Service> importServiceDefinition(String repositoryUrl, Secret repositorySecret, boolean disableSSLValidation, boolean mainArtifact) throws MockRepositoryImportException {
        log.info("Importing service definitions from {}", (Object)repositoryUrl);
        File localFile = null;
        Map<String, List<String>> fileProperties = null;
        if (repositoryUrl.startsWith("http")) {
            try {
                HTTPDownloader.FileAndHeaders fileAndHeaders = HTTPDownloader.handleHTTPDownloadToFileAndHeaders(repositoryUrl, repositorySecret, disableSSLValidation);
                localFile = fileAndHeaders.getLocalFile();
                fileProperties = fileAndHeaders.getResponseHeaders();
            }
            catch (IOException ioe) {
                throw new MockRepositoryImportException(repositoryUrl + " cannot be downloaded", ioe);
            }
        } else {
            localFile = new File(repositoryUrl);
        }
        RelativeReferenceURLBuilder referenceURLBuilder = RelativeReferenceURLBuilderFactory.getRelativeReferenceURLBuilder(fileProperties);
        String artifactName = referenceURLBuilder.getFileName(repositoryUrl, fileProperties);
        ReferenceResolver referenceResolver = new ReferenceResolver(repositoryUrl, repositorySecret, disableSSLValidation, referenceURLBuilder);
        return this.importServiceDefinition(localFile, referenceResolver, new ArtifactInfo(artifactName, mainArtifact));
    }

    public List<Service> importServiceDefinition(File repositoryFile, ReferenceResolver referenceResolver, ArtifactInfo artifactInfo) throws MockRepositoryImportException {
        MockRepositoryImporter importer = null;
        try {
            importer = MockRepositoryImporterFactory.getMockRepositoryImporter(repositoryFile, referenceResolver);
        }
        catch (IOException ioe) {
            throw new MockRepositoryImportException(ioe.getMessage(), ioe);
        }
        Service reference = null;
        boolean serviceUpdate = false;
        List<Service> services = importer.getServiceDefinitions();
        for (Service service : services) {
            Service existingService = this.serviceRepository.findByNameAndVersion(service.getName(), service.getVersion());
            log.debug("Service [{}, {}] exists ? {}", new Object[]{service.getName(), service.getVersion(), existingService != null});
            if (artifactInfo.isMainArtifact()) {
                if (existingService != null) {
                    Metadata backup = service.getMetadata();
                    service.setId(existingService.getId());
                    service.setMetadata(existingService.getMetadata());
                    if (backup != null) {
                        existingService.getMetadata().setLabels(backup.getLabels());
                        existingService.getMetadata().setAnnotations(backup.getAnnotations());
                    }
                    this.copyOverridenOperations(existingService, service);
                    serviceUpdate = true;
                }
                if (service.getMetadata() == null) {
                    service.setMetadata(new Metadata());
                }
                if (service.getType().equals((Object)ServiceType.EVENT)) {
                    this.manageEventServiceDefaults(service);
                }
                service.getMetadata().objectUpdated();
                service.setSourceArtifact(artifactInfo.getArtifactName());
                reference = service = (Service)this.serviceRepository.save(service);
            } else {
                if (existingService == null) {
                    log.warn("Trying to import {} as a secondary artifact but there's no existing [{}, {}] Service. Just skipping.", new Object[]{artifactInfo.getArtifactName(), service.getName(), service.getVersion()});
                    break;
                }
                if (service.getMetadata() != null) {
                    existingService.getMetadata().setLabels(service.getMetadata().getLabels());
                    existingService.getMetadata().setAnnotations(service.getMetadata().getAnnotations());
                }
                for (Operation operation : service.getOperations()) {
                    Operation existingOp = existingService.getOperations().stream().filter(op -> op.getName().equals(operation.getName())).findFirst().orElse(null);
                    if (existingOp == null) continue;
                    if (operation.getDefaultDelay() != null) {
                        existingOp.setDefaultDelay(operation.getDefaultDelay());
                    }
                    if (operation.getDispatcher() != null) {
                        existingOp.setDispatcher(operation.getDispatcher());
                    }
                    if (operation.getDispatcherRules() == null) continue;
                    existingOp.setDispatcherRules(operation.getDispatcherRules());
                }
                reference = existingService;
                services.remove(service);
                services.add(reference);
            }
            List<Resource> existingResources = this.resourceRepository.findByServiceIdAndSourceArtifact(reference.getId(), artifactInfo.getArtifactName());
            if (existingResources != null && !existingResources.isEmpty()) {
                this.resourceRepository.deleteAll(existingResources);
            }
            List<Resource> resources = importer.getResourceDefinitions(service);
            for (Resource resource : resources) {
                resource.setServiceId(reference.getId());
                resource.setSourceArtifact(artifactInfo.getArtifactName());
            }
            this.resourceRepository.saveAll(resources);
            for (Operation operation : reference.getOperations()) {
                String operationId = IdBuilder.buildOperationId((Service)reference, (Operation)operation);
                this.requestRepository.deleteAll(this.requestRepository.findByOperationIdAndSourceArtifact(operationId, artifactInfo.getArtifactName()));
                this.responseRepository.deleteAll(this.responseRepository.findByOperationIdAndSourceArtifact(operationId, artifactInfo.getArtifactName()));
                this.eventMessageRepository.deleteAll(this.eventMessageRepository.findByOperationIdAndSourceArtifact(operationId, artifactInfo.getArtifactName()));
                List<Exchange> exchanges = importer.getMessageDefinitions(service, operation);
                for (Exchange exchange : exchanges) {
                    if (exchange instanceof RequestResponsePair) {
                        RequestResponsePair pair = (RequestResponsePair)exchange;
                        pair.getRequest().setOperationId(operationId);
                        pair.getResponse().setOperationId(operationId);
                        pair.getRequest().setSourceArtifact(artifactInfo.getArtifactName());
                        pair.getResponse().setSourceArtifact(artifactInfo.getArtifactName());
                        this.responseRepository.save(pair.getResponse());
                        pair.getRequest().setResponseId(pair.getResponse().getId());
                        this.requestRepository.save(pair.getRequest());
                        continue;
                    }
                    if (!(exchange instanceof UnidirectionalEvent)) continue;
                    UnidirectionalEvent event = (UnidirectionalEvent)exchange;
                    event.getEventMessage().setOperationId(operationId);
                    event.getEventMessage().setSourceArtifact(artifactInfo.getArtifactName());
                    this.eventMessageRepository.save(event.getEventMessage());
                }
            }
            this.serviceRepository.save(reference);
            this.publishServiceChangeEvent(reference, serviceUpdate ? ChangeType.UPDATED : ChangeType.CREATED);
        }
        log.info("Having imported {} services definitions into repository", (Object)services.size());
        return services;
    }

    public Service createGenericResourceService(String name, String version, String resource, String referencePayload) throws EntityAlreadyExistsException {
        log.info("Creating a new Service '{}-{}' for generic resource {}", new Object[]{name, version, resource});
        Service existingService = this.serviceRepository.findByNameAndVersion(name, version);
        if (existingService != null) {
            log.warn("A Service '{}-{}' is already existing. Throwing an Exception", (Object)name, (Object)version);
            throw new EntityAlreadyExistsException(String.format("Service '%s-%s' is already present in store", name, version));
        }
        Service service = new Service();
        service.setName(name);
        service.setVersion(version);
        service.setType(ServiceType.GENERIC_REST);
        service.setMetadata(new Metadata());
        Operation createOp = new Operation();
        createOp.setName("POST /" + resource);
        createOp.setMethod("POST");
        service.addOperation(createOp);
        Operation getOp = new Operation();
        getOp.setName("GET /" + resource + "/:id");
        getOp.setMethod("GET");
        getOp.setDispatcher("URI_PARTS");
        getOp.setDispatcherRules("id");
        service.addOperation(getOp);
        Operation updateOp = new Operation();
        updateOp.setName("PUT /" + resource + "/:id");
        updateOp.setMethod("PUT");
        updateOp.setDispatcher("URI_PARTS");
        updateOp.setDispatcherRules("id");
        service.addOperation(updateOp);
        Operation listOp = new Operation();
        listOp.setName("GET /" + resource);
        listOp.setMethod("GET");
        service.addOperation(listOp);
        Operation delOp = new Operation();
        delOp.setName("DELETE /" + resource + "/:id");
        delOp.setMethod("DELETE");
        delOp.setDispatcher("URI_PARTS");
        delOp.setDispatcherRules("id");
        service.addOperation(delOp);
        this.serviceRepository.save(service);
        log.info("Having created Service '{}' for generic resource {}", (Object)service.getId(), (Object)resource);
        if (referencePayload != null) {
            GenericResource genericResource = new GenericResource();
            genericResource.setServiceId(service.getId());
            genericResource.setReference(true);
            try {
                Document document = Document.parse((String)referencePayload);
                genericResource.setPayload(document);
                this.genericResourceRepository.save(genericResource);
            }
            catch (JsonParseException jpe) {
                log.error("Cannot parse the provided reference payload as JSON: {}", (Object)referencePayload);
                log.error("Reference is ignored, please provide JSON the next time");
            }
        }
        this.publishServiceChangeEvent(service, ChangeType.CREATED);
        return service;
    }

    public Service createGenericEventService(String name, String version, String event, String referencePayload) throws EntityAlreadyExistsException {
        log.info("Creating a new Service '{}-{}' for generic event {}", new Object[]{name, version, event});
        Service existingService = this.serviceRepository.findByNameAndVersion(name, version);
        if (existingService != null) {
            log.warn("A Service '{}-{}' is already existing. Throwing an Exception", (Object)name, (Object)version);
            throw new EntityAlreadyExistsException(String.format("Service '%s-%s' is already present in store", name, version));
        }
        Service service = new Service();
        service.setName(name);
        service.setVersion(version);
        service.setType(ServiceType.GENERIC_EVENT);
        service.setMetadata(new Metadata());
        Operation subscribeOp = new Operation();
        subscribeOp.setName("SUBSCRIBE " + event);
        subscribeOp.setMethod("SUBSCRIBE");
        subscribeOp.setDefaultDelay(this.defaultAsyncFrequency);
        Binding kafkaBinding = new Binding(BindingType.KAFKA);
        kafkaBinding.setKeyType("string");
        Binding wsBinding = new Binding(BindingType.WS);
        wsBinding.setMethod("POST");
        subscribeOp.addBinding(BindingType.KAFKA.name(), kafkaBinding);
        subscribeOp.addBinding(BindingType.WS.name(), wsBinding);
        service.addOperation(subscribeOp);
        this.serviceRepository.save(service);
        log.info("Having created Service '{}' for generic event {}", (Object)service.getId(), (Object)event);
        if (referencePayload != null) {
            Resource artifact = new Resource();
            artifact.setName(event + "-asyncapi.yaml");
            artifact.setType(ResourceType.ASYNC_API_SPEC);
            artifact.setServiceId(service.getId());
            artifact.setSourceArtifact(event + "-asyncapi.yaml");
            artifact.setContent(this.buildAsyncAPISpecContent(service, event, referencePayload));
            this.resourceRepository.save(artifact);
            EventMessage eventMessage = new EventMessage();
            eventMessage.setName("Reference");
            eventMessage.setContent(referencePayload);
            eventMessage.setOperationId(IdBuilder.buildOperationId((Service)service, (Operation)subscribeOp));
            eventMessage.setMediaType("application/json");
            this.eventMessageRepository.save(eventMessage);
            log.info("Having created resource '{}' for Service '{}'", (Object)artifact.getId(), (Object)service.getId());
        }
        this.publishServiceChangeEvent(service, ChangeType.CREATED);
        return service;
    }

    public Boolean deleteService(String id, UserInfo userInfo) {
        Service service = this.serviceRepository.findById(id).orElse(null);
        if (this.authorizationChecker.hasRole(userInfo, "admin") || this.authorizationChecker.hasRoleForService(userInfo, "manager", service)) {
            this.resourceRepository.deleteAll(this.resourceRepository.findByServiceId(id));
            this.testResultRepository.deleteAll(this.testResultRepository.findByServiceId(id));
            if (service != null) {
                for (Operation operation : service.getOperations()) {
                    String operationId = IdBuilder.buildOperationId((Service)service, (Operation)operation);
                    this.requestRepository.deleteAll(this.requestRepository.findByOperationId(operationId));
                    this.responseRepository.deleteAll(this.responseRepository.findByOperationId(operationId));
                    this.eventMessageRepository.deleteAll(this.eventMessageRepository.findByOperationId(operationId));
                }
                this.serviceRepository.delete(service);
                this.publishServiceChangeEvent(service, ChangeType.DELETED);
            }
            log.info("Service [{}] has been fully deleted", (Object)id);
            return true;
        }
        return false;
    }

    public Boolean updateMetadata(String id, Metadata metadata, UserInfo userInfo) {
        Service service = this.serviceRepository.findById(id).orElse(null);
        if (service != null && this.authorizationChecker.hasRoleForService(userInfo, "manager", service)) {
            service.getMetadata().setLabels(metadata.getLabels());
            service.getMetadata().setAnnotations(metadata.getAnnotations());
            service.getMetadata().objectUpdated();
            this.serviceRepository.save(service);
            this.publishServiceChangeEvent(service, ChangeType.UPDATED);
            return true;
        }
        return false;
    }

    public Boolean updateOperation(String id, String operationName, String dispatcher, String dispatcherRules, Long delay, List<ParameterConstraint> constraints, UserInfo userInfo) {
        Service service = this.serviceRepository.findById(id).orElse(null);
        log.debug("Is user allowed? {}", (Object)this.authorizationChecker.hasRoleForService(userInfo, "manager", service));
        if (service != null && this.authorizationChecker.hasRoleForService(userInfo, "manager", service)) {
            for (Operation operation : service.getOperations()) {
                if (!operation.getName().equals(operationName)) continue;
                operation.setDispatcher(dispatcher);
                operation.setDispatcherRules(dispatcherRules);
                operation.setParameterConstraints(constraints);
                operation.setDefaultDelay(delay);
                operation.setOverride(true);
                this.serviceRepository.save(service);
                this.publishServiceChangeEvent(service, ChangeType.UPDATED);
                return true;
            }
        }
        return false;
    }

    public Boolean addExchangesToServiceOperation(String id, String operationName, List<Exchange> exchanges, UserInfo userInfo) {
        Service service = this.serviceRepository.findById(id).orElse(null);
        log.debug("Is user allowed? {}", (Object)this.authorizationChecker.hasRoleForService(userInfo, "manager", service));
        if (service != null && this.authorizationChecker.hasRoleForService(userInfo, "manager", service)) {
            for (Operation operation : service.getOperations()) {
                if (!operation.getName().equals(operationName)) continue;
                String operationId = IdBuilder.buildOperationId((Service)service, (Operation)operation);
                for (Exchange exchange : exchanges) {
                    if (exchange instanceof RequestResponsePair) {
                        RequestResponsePair pair = (RequestResponsePair)exchange;
                        pair.getRequest().setOperationId(operationId);
                        pair.getResponse().setOperationId(operationId);
                        pair.getRequest().setSourceArtifact(AI_COPILOT_SOURCE);
                        pair.getResponse().setSourceArtifact(AI_COPILOT_SOURCE);
                        this.responseRepository.save(pair.getResponse());
                        pair.getRequest().setResponseId(pair.getResponse().getId());
                        this.requestRepository.save(pair.getRequest());
                        continue;
                    }
                    if (!(exchange instanceof UnidirectionalEvent)) continue;
                    UnidirectionalEvent event = (UnidirectionalEvent)exchange;
                    event.getEventMessage().setOperationId(operationId);
                    event.getEventMessage().setSourceArtifact(AI_COPILOT_SOURCE);
                    this.eventMessageRepository.save(event.getEventMessage());
                }
                this.publishServiceChangeEvent(service, ChangeType.UPDATED);
                return true;
            }
        }
        return false;
    }

    private void copyOverridenOperations(Service existingService, Service newService) {
        for (Operation existingOperation : existingService.getOperations()) {
            if (!existingOperation.hasOverride()) continue;
            for (Operation op : newService.getOperations()) {
                if (!existingOperation.getName().equals(op.getName())) continue;
                op.setDefaultDelay(existingOperation.getDefaultDelay());
                op.setDispatcher(existingOperation.getDispatcher());
                op.setDispatcherRules(existingOperation.getDispatcherRules());
                op.setParameterConstraints(existingOperation.getParameterConstraints());
                op.setOverride(true);
            }
        }
    }

    private void manageEventServiceDefaults(Service service) {
        if (service.getType().equals((Object)ServiceType.EVENT)) {
            for (Operation operation : service.getOperations()) {
                if (operation.getDefaultDelay() == null) {
                    operation.setDefaultDelay(this.defaultAsyncFrequency);
                }
                if (operation.getBindings() != null && !operation.getBindings().isEmpty()) continue;
                operation.addBinding(this.defaultAsyncBinding, new Binding(BindingType.valueOf((String)this.defaultAsyncBinding)));
            }
        }
    }

    private String buildAsyncAPISpecContent(Service service, String event, String referencePayload) {
        InputStream stream = null;
        JsonNode referenceSchema = null;
        try {
            stream = ResourceUtil.getClasspathResource("templates/asyncapi-2.4.yaml");
            referenceSchema = OpenAPISchemaBuilder.buildTypeSchemaFromJson((String)referencePayload);
            return ResourceUtil.replaceTemplatesInSpecStream(stream, service, event, referenceSchema, referencePayload);
        }
        catch (IOException ioe) {
            log.error("Exception while building ASyncAPISpec for Service '{}': {}", (Object)service.getId(), (Object)ioe.getMessage());
            return "";
        }
    }

    private void publishServiceChangeEvent(Service service, ChangeType changeType) {
        ServiceChangeEvent event = new ServiceChangeEvent(this, service.getId(), changeType);
        this.applicationContext.publishEvent((ApplicationEvent)event);
        log.debug("Service change event has been published");
    }
}

